/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.pty.PTYInputStream;
import org.eclipse.cdt.utils.pty.PTYOutputStream;

public class PTY {
    final boolean console;
    String slave;
    PTYInputStream in;
    PTYOutputStream out;
    int master;
    private static boolean hasPTY;
    private static boolean setTerminalSizeErrorAlreadyLogged;

    static {
        try {
            System.loadLibrary("pty");
            hasPTY = true;
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    public PTY() throws IOException {
        this(true);
    }

    public PTY(boolean console) throws IOException {
        this.console = console;
        if (hasPTY) {
            this.slave = this.openMaster(console);
        }
        if (this.slave == null) {
            throw new IOException(CCorePlugin.getResourceString((String)"Util.exception.cannotCreatePty"));
        }
        this.in = new PTYInputStream(new MasterFD());
        this.out = new PTYOutputStream(new MasterFD());
    }

    public String getSlaveName() {
        return this.slave;
    }

    public MasterFD getMasterFD() {
        return new MasterFD();
    }

    public final boolean isConsole() {
        return this.console;
    }

    public PTYOutputStream getOutputStream() {
        return this.out;
    }

    public PTYInputStream getInputStream() {
        return this.in;
    }

    public final void setTerminalSize(int width, int height) {
        block2: {
            try {
                this.change_window_size(this.master, width, height);
            }
            catch (UnsatisfiedLinkError ule) {
                if (setTerminalSizeErrorAlreadyLogged) break block2;
                setTerminalSizeErrorAlreadyLogged = true;
                CCorePlugin.log((String)CCorePlugin.getResourceString((String)"Util.exception.cannotSetTerminalSize"), (Throwable)ule);
            }
        }
    }

    public static boolean isSupported() {
        return hasPTY;
    }

    native String openMaster(boolean var1);

    native int change_window_size(int var1, int var2, int var3);

    public class MasterFD {
        public int getFD() {
            return PTY.this.master;
        }

        void setFD(int fd) {
            PTY.this.master = fd;
        }
    }
}

