/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class TemplateArgumentDeduction {
    private final CPPTemplateParameterMap fExplicitArgs;
    private CPPTemplateParameterMap fDeducedArgs;
    private Set<Integer> fTemplateParameterPacks;
    private int fPackOffset;
    private final int fPackSize;

    static ICPPTemplateArgument[] deduceForFunctionCall(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argIsLValue, CPPTemplateParameterMap map, IASTNode point) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        if (tmplArgs != null && !TemplateArgumentDeduction.addExplicitArguments(tmplParams, tmplArgs, map, point)) {
            return null;
        }
        if (!TemplateArgumentDeduction.deduceFromFunctionArgs(template, fnArgs, argIsLValue, map, point)) {
            return null;
        }
        return TemplateArgumentDeduction.createArguments(map, tmplParams);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static boolean deduceFromFunctionArgs(ICPPFunctionTemplate template, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, CPPTemplateParameterMap map, IASTNode point) {
        try {
            IType[] fnPars = template.getType().getParameterTypes();
            int fnParCount = fnPars.length;
            ICPPTemplateParameter[] tmplPars = template.getTemplateParameters();
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplPars, map, new CPPTemplateParameterMap(fnParCount), 0);
            IType fnParPack = null;
            int j = 0;
            while (j < fnArgs.size()) {
                block27: {
                    IType par;
                    block29: {
                        block28: {
                            if (fnParPack == null) break block28;
                            par = fnParPack;
                            deduct.incPackOffset();
                            break block29;
                        }
                        if (j >= fnParCount) break;
                        par = fnPars[j];
                        if (!(par instanceof ICPPParameterPackType)) break block29;
                        if (j != fnParCount - 1) break block27;
                        par = fnParPack = ((ICPPParameterPackType)par).getType();
                        deduct = new TemplateArgumentDeduction(deduct, fnArgs.size() - j);
                    }
                    par = CPPTemplates.instantiateType(par, map, -1, null, point);
                    if (!CPPTemplates.isValidType(par)) {
                        return false;
                    }
                    if (CPPTemplates.isDependentType(par)) {
                        IType arg = fnArgs.get(j);
                        par = SemanticUtil.getNestedType(par, 1);
                        if (arg instanceof InitializerListType) {
                            IType inner = Conversions.getInitListType(par = SemanticUtil.getNestedType(par, 13));
                            if (inner != null) {
                                EvalInitList eval = ((InitializerListType)arg).getEvaluation();
                                ICPPEvaluation[] iCPPEvaluationArray = eval.getClauses();
                                int n = iCPPEvaluationArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ICPPEvaluation clause = iCPPEvaluationArray[n2];
                                    if (!TemplateArgumentDeduction.deduceFromFunctionArg(inner, clause.getTypeOrFunctionSet(point), clause.getValueCategory(point), deduct, point)) {
                                        return false;
                                    }
                                    ++n2;
                                }
                            }
                        } else if (arg instanceof FunctionSetType) {
                            ICPPFunction[] fs;
                            ICPPFunction[] iCPPFunctionArray = fs = ((FunctionSetType)arg).getFunctionSet().getBindings();
                            int n = fs.length;
                            int clause = 0;
                            while (clause < n) {
                                ICPPFunction f = iCPPFunctionArray[clause];
                                if (!(f instanceof ICPPFunctionTemplate)) {
                                    ++clause;
                                    continue;
                                }
                                break block27;
                            }
                            CPPTemplateParameterMap success = null;
                            HashSet<String> handled = new HashSet<String>();
                            ICPPFunction[] iCPPFunctionArray2 = fs;
                            int n3 = fs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ICPPFunction f = iCPPFunctionArray2[n4];
                                arg = f.getType();
                                if (f instanceof ICPPMethod && !f.isStatic()) {
                                    arg = new CPPPointerToMemberType(arg, ((ICPPMethod)f).getClassOwner(), false, false, false);
                                }
                                if (handled.add(ASTTypeUtil.getType(arg, true))) {
                                    CPPTemplateParameterMap state = deduct.saveState();
                                    if (TemplateArgumentDeduction.deduceFromFunctionArg(par, arg, argCats.get(j), deduct, point)) {
                                        if (success != null) {
                                            deduct.restoreState(state);
                                            break block27;
                                        }
                                        success = deduct.saveState();
                                    }
                                    deduct.restoreState(state);
                                }
                                ++n4;
                            }
                            if (success == null) {
                                return false;
                            }
                            deduct.restoreState(success);
                        } else if (!TemplateArgumentDeduction.deduceFromFunctionArg(par, arg, argCats.get(j), deduct, point)) {
                            return false;
                        }
                    }
                }
                ++j;
            }
            if (!map.addDeducedArgs(deduct.fDeducedArgs)) {
                return false;
            }
            ICPPTemplateParameter[] iCPPTemplateParameterArray = tmplPars;
            int n = tmplPars.length;
            int n5 = 0;
            while (n5 < n) {
                ICPPTemplateArgument arg;
                ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n5];
                if (tpar instanceof ICPPTemplateNonTypeParameter && (arg = deduct.fDeducedArgs.getArgument(tpar)) != null) {
                    IType type2;
                    IType type1 = ((ICPPTemplateNonTypeParameter)tpar).getType();
                    if (!(type1 = CPPTemplates.instantiateType(type1, map, -1, null, point)).isSameType(type2 = arg.getTypeOfNonTypeValue())) {
                        return false;
                    }
                }
                ++n5;
            }
            return TemplateArgumentDeduction.verifyDeduction(tmplPars, map, true, point);
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static boolean deduceFromFunctionArg(IType par, IType arg, IASTExpression.ValueCategory valueCat, TemplateArgumentDeduction deduct, IASTNode point) throws DOMException {
        IType pcheck;
        boolean isReferenceTypeParameter = false;
        if (par instanceof ICPPReferenceType) {
            isReferenceTypeParameter = true;
            ICPPReferenceType refPar = (ICPPReferenceType)par;
            arg = refPar.isRValueReference() && refPar.getType() instanceof ICPPTemplateParameter && valueCat == IASTExpression.ValueCategory.LVALUE ? new CPPReferenceType(SemanticUtil.getSimplifiedType(arg), false) : TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, true);
            par = SemanticUtil.getNestedType(par, 5);
        } else {
            arg = TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, false);
        }
        CVQualifier cvPar = SemanticUtil.getCVQualifier(par);
        CVQualifier cvArg = SemanticUtil.getCVQualifier(arg);
        if ((cvPar == cvArg || isReferenceTypeParameter && cvPar.isAtLeastAsQualifiedAs(cvArg)) && !((pcheck = SemanticUtil.getNestedType(par, 8)) instanceof ICPPTemplateParameter)) {
            ICPPClassType aInst;
            ICPPTemplateInstance pInst;
            ICPPClassTemplate pTemplate;
            par = pcheck;
            IType argcheck = arg = SemanticUtil.getNestedType(arg, 8);
            if (par instanceof IPointerType && arg instanceof IPointerType) {
                pcheck = ((IPointerType)par).getType();
                argcheck = ((IPointerType)arg).getType();
                if (pcheck instanceof ICPPTemplateParameter) {
                    pcheck = null;
                } else {
                    cvPar = SemanticUtil.getCVQualifier(pcheck);
                    if (cvPar.isAtLeastAsQualifiedAs(cvArg = SemanticUtil.getCVQualifier(argcheck))) {
                        pcheck = SemanticUtil.getNestedType(pcheck, 8);
                        argcheck = SemanticUtil.getNestedType(argcheck, 8);
                    } else {
                        pcheck = null;
                    }
                }
            }
            if (pcheck instanceof ICPPTemplateInstance && argcheck instanceof ICPPClassType && (pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst = (ICPPTemplateInstance)((Object)pcheck))) != null && (aInst = TemplateArgumentDeduction.findBaseInstance((ICPPClassType)argcheck, pTemplate, point)) != null && aInst != argcheck) {
                par = pcheck;
                arg = aInst;
            }
        }
        return deduct.fromType(par, arg, true, point);
    }

    static ICPPTemplateArgument[] deduceForAddressOf(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, IFunctionType arg, CPPTemplateParameterMap map, IASTNode point) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        if (!TemplateArgumentDeduction.addExplicitArguments(tmplParams, tmplArgs, map, point)) {
            return null;
        }
        IType par = template.getType();
        if (!CPPTemplates.isValidType(par = CPPTemplates.instantiateType(par, map, -1, null, point))) {
            return null;
        }
        boolean isDependentPar = CPPTemplates.isDependentType(par);
        if (isDependentPar) {
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, map, new CPPTemplateParameterMap(tmplParams.length), 0);
            par = SemanticUtil.getNestedType(par, 1);
            if (arg != null && !deduct.fromType(par, arg, false, point)) {
                return null;
            }
            if (!map.addDeducedArgs(deduct.fDeducedArgs)) {
                return null;
            }
        }
        if (!TemplateArgumentDeduction.verifyDeduction(tmplParams, map, true, point)) {
            return null;
        }
        if (isDependentPar) {
            par = CPPTemplates.instantiateType(par, map, -1, null, point);
        }
        if (arg == null || arg.isSameType(par)) {
            return TemplateArgumentDeduction.createArguments(map, tmplParams);
        }
        return null;
    }

    static ICPPTemplateArgument[] deduceForConversion(ICPPFunctionTemplate template, IType conversionType, CPPTemplateParameterMap map, IASTNode point) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int length = tmplParams.length;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[length];
        IType a = SemanticUtil.getSimplifiedType(conversionType);
        IType p = template.getType().getReturnType();
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, null, map, 0);
        if (!deduct.fromType(p = TemplateArgumentDeduction.getArgumentTypeForDeduction(p, a instanceof ICPPReferenceType), a = SemanticUtil.getNestedType(a, 5), true, point)) {
            return null;
        }
        int i = 0;
        while (i < length) {
            if (result[i] == null) {
                ICPPTemplateParameter tpar = tmplParams[i];
                ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                if (deducedArg == null && (deducedArg = tpar.getDefaultValue()) == null) {
                    return null;
                }
                result[i] = deducedArg;
            }
            ++i;
        }
        return result;
    }

    static ICPPTemplateArgument[] deduceForDeclaration(ICPPFunctionTemplate template, ICPPTemplateArgument[] args, ICPPFunctionType ftype, CPPTemplateParameterMap map, IASTNode point) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        if (!TemplateArgumentDeduction.addExplicitArguments(tmplParams, args, map, point)) {
            return null;
        }
        IType a = SemanticUtil.getSimplifiedType(ftype);
        IType p = CPPTemplates.instantiateType(template.getType(), map, -1, null, point);
        if (!CPPTemplates.isValidType(p)) {
            return null;
        }
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, map, new CPPTemplateParameterMap(tmplParams.length), 0);
        if (!deduct.fromType(p, a, false, point)) {
            return null;
        }
        if (!map.addDeducedArgs(deduct.fDeducedArgs)) {
            return null;
        }
        if (!TemplateArgumentDeduction.verifyDeduction(tmplParams, map, true, point)) {
            return null;
        }
        IType type = CPPTemplates.instantiateType(p, map, -1, null, point);
        if (!ftype.isSameType(type)) {
            return null;
        }
        return TemplateArgumentDeduction.createArguments(map, tmplParams);
    }

    static int deduceForPartialOrdering(ICPPTemplateParameter[] tmplPars, IType[] fnPars, IType[] fnArgs, IASTNode point) {
        try {
            int fnParCount = fnPars.length;
            int fnArgCount = fnArgs.length;
            int result = 0;
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplPars, new CPPTemplateParameterMap(0), new CPPTemplateParameterMap(fnParCount), 0);
            IType fnParPack = null;
            int j = 0;
            while (j < fnArgCount) {
                block11: {
                    IType par;
                    block10: {
                        block9: {
                            if (fnParPack == null) break block9;
                            par = fnParPack;
                            deduct.incPackOffset();
                            break block10;
                        }
                        if (j >= fnParCount) {
                            return result;
                        }
                        par = fnPars[j];
                        if (!(par instanceof ICPPParameterPackType)) break block10;
                        if (j != fnParCount - 1) break block11;
                        par = fnParPack = ((ICPPParameterPackType)par).getType();
                        deduct = new TemplateArgumentDeduction(deduct, fnArgs.length - j);
                    }
                    IType arg = fnArgs[j];
                    int cmpSpecialized = TemplateArgumentDeduction.deduceForPartialOrdering(par, arg, deduct, point);
                    if (cmpSpecialized < 0) {
                        return cmpSpecialized;
                    }
                    if (cmpSpecialized > 0) {
                        result = cmpSpecialized;
                    }
                }
                ++j;
            }
            return result;
        }
        catch (DOMException dOMException) {
            return -1;
        }
    }

    private static int deduceForPartialOrdering(IType par, IType arg, TemplateArgumentDeduction deduct, IASTNode point) throws DOMException {
        par = SemanticUtil.getNestedType(par, 1);
        arg = SemanticUtil.getNestedType(arg, 1);
        boolean isMoreCVQualified = false;
        if (par instanceof ICPPReferenceType && arg instanceof ICPPReferenceType) {
            par = SemanticUtil.getNestedType(par, 5);
            arg = SemanticUtil.getNestedType(arg, 5);
            CVQualifier cvp = SemanticUtil.getCVQualifier(par);
            CVQualifier cva = SemanticUtil.getCVQualifier(arg);
            isMoreCVQualified = cva.isMoreQualifiedThan(cvp);
        }
        if (!deduct.fromType(par = SemanticUtil.getNestedType(par, 21), arg = SemanticUtil.getNestedType(arg, 21), false, point)) {
            return -1;
        }
        return isMoreCVQualified ? 1 : 0;
    }

    public static boolean addExplicitArguments(ICPPTemplateParameter[] tmplParams, ICPPTemplateArgument[] tmplArgs, CPPTemplateParameterMap map, IASTNode point) {
        tmplArgs = SemanticUtil.getSimplifiedArguments(tmplArgs);
        ICPPTemplateParameter tmplParam = null;
        int packOffset = -1;
        int i = 0;
        while (i < tmplArgs.length) {
            if (packOffset < 0 || tmplParam == null) {
                if (i >= tmplParams.length) {
                    return false;
                }
                tmplParam = tmplParams[i];
                if (tmplParam.isParameterPack()) {
                    packOffset = i;
                }
            }
            ICPPTemplateArgument tmplArg = tmplArgs[i];
            if ((tmplArg = CPPTemplates.matchTemplateParameterAndArgument(tmplParam, tmplArg, map, point)) == null) {
                return false;
            }
            if (packOffset < 0) {
                map.put(tmplParam, tmplArg);
            }
            ++i;
        }
        if (packOffset >= 0) {
            int packSize = tmplArgs.length - packOffset;
            ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
            System.arraycopy(tmplArgs, packOffset, pack, 0, packSize);
            map.put(tmplParam, pack);
        }
        return true;
    }

    private static ICPPTemplateArgument[] createArguments(CPPTemplateParameterMap map, ICPPTemplateParameter[] tmplParams) {
        ArrayList<ICPPTemplateArgument> result = new ArrayList<ICPPTemplateArgument>(tmplParams.length);
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tmplParams;
        int n = tmplParams.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = map.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    return null;
                }
                result.addAll(Arrays.asList(deducedArgs));
            } else {
                ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                if (deducedArg == null) {
                    return null;
                }
                result.add(deducedArg);
            }
            ++n2;
        }
        return result.toArray(new ICPPTemplateArgument[result.size()]);
    }

    private static ICPPClassType findBaseInstance(ICPPClassType a, ICPPClassTemplate pTemplate, IASTNode point) throws DOMException {
        return TemplateArgumentDeduction.findBaseInstance(a, pTemplate, 16, new HashSet<Object>(), point);
    }

    private static ICPPClassType findBaseInstance(ICPPClassType a, ICPPClassTemplate pTemplate, int maxdepth, HashSet<Object> handled, IASTNode point) throws DOMException {
        ICPPTemplateInstance inst;
        ICPPClassTemplate tmpl;
        if (a instanceof ICPPTemplateInstance && pTemplate.isSameType(tmpl = TemplateArgumentDeduction.getPrimaryTemplate(inst = (ICPPTemplateInstance)((Object)a)))) {
            return a;
        }
        if (maxdepth-- > 0) {
            ICPPBase[] iCPPBaseArray = ClassTypeHelper.getBases(a, point);
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType inst2;
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof ICPPClassType && handled.add(base) && (inst2 = TemplateArgumentDeduction.findBaseInstance((ICPPClassType)base, pTemplate, maxdepth, handled, point)) != null) {
                    return inst2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static ICPPClassTemplate getPrimaryTemplate(ICPPTemplateInstance inst) throws DOMException {
        ICPPTemplateDefinition template = inst.getTemplateDefinition();
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return ((ICPPClassTemplatePartialSpecialization)template).getPrimaryClassTemplate();
        }
        if (template instanceof ICPPClassTemplate) {
            return (ICPPClassTemplate)template;
        }
        return null;
    }

    private static IType getArgumentTypeForDeduction(IType type, boolean parameterIsAReferenceType) {
        if ((type = SemanticUtil.getSimplifiedType(type)) instanceof ICPPReferenceType) {
            type = ((ICPPReferenceType)type).getType();
        }
        IType result = type;
        if (!parameterIsAReferenceType) {
            result = type instanceof IArrayType ? new CPPPointerType(((IArrayType)type).getType()) : (type instanceof IFunctionType ? new CPPPointerType(type) : SemanticUtil.getNestedType(type, 17));
        }
        return result;
    }

    public static boolean fromTemplateArguments(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] p, ICPPTemplateArgument[] a, CPPTemplateParameterMap map, IASTNode point) throws DOMException {
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(pars, null, map, 0);
        int len = a.length;
        if (p == null || p.length != len) {
            return false;
        }
        int j = 0;
        while (j < len) {
            if (!deduct.fromTemplateArgument(p[j], a[j], point)) {
                return false;
            }
            ++j;
        }
        return TemplateArgumentDeduction.verifyDeduction(pars, map, false, point);
    }

    private static boolean verifyDeduction(ICPPTemplateParameter[] pars, CPPTemplateParameterMap tpMap, boolean useDefaults, IASTNode point) {
        ICPPTemplateParameter[] iCPPTemplateParameterArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = tpMap.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    tpMap.put(tpar, ICPPTemplateArgument.EMPTY_ARGUMENTS);
                } else {
                    ICPPTemplateArgument[] iCPPTemplateArgumentArray = deducedArgs;
                    int n3 = deducedArgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n4];
                        if (arg == null) {
                            return false;
                        }
                        ++n4;
                    }
                }
            } else {
                ICPPTemplateArgument deducedArg = tpMap.getArgument(tpar);
                if (deducedArg == null && useDefaults && (deducedArg = tpar.getDefaultValue()) != null && (deducedArg = CPPTemplates.instantiateArgument(deducedArg, tpMap, -1, null, point)) != null) {
                    tpMap.put(tpar, deducedArg);
                }
                if (deducedArg == null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private TemplateArgumentDeduction(ICPPTemplateParameter[] tpars, CPPTemplateParameterMap explicit, CPPTemplateParameterMap result, int packSize) {
        this.fExplicitArgs = explicit;
        this.fDeducedArgs = result;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tpars;
        int n = tpars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                if (this.fTemplateParameterPacks == null) {
                    this.fTemplateParameterPacks = new HashSet<Integer>();
                }
                this.fTemplateParameterPacks.add(tpar.getParameterID());
            }
            ++n2;
        }
    }

    private TemplateArgumentDeduction(TemplateArgumentDeduction base, int packSize) {
        this.fExplicitArgs = base.fExplicitArgs;
        this.fDeducedArgs = base.fDeducedArgs;
        this.fTemplateParameterPacks = base.fTemplateParameterPacks;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
    }

    private CPPTemplateParameterMap saveState() {
        return new CPPTemplateParameterMap(this.fDeducedArgs);
    }

    private void restoreState(CPPTemplateParameterMap saved) {
        this.fDeducedArgs = saved;
    }

    private void incPackOffset() {
        ++this.fPackOffset;
        assert (this.fPackOffset < this.fPackSize);
    }

    private boolean fromTemplateArgument(ICPPTemplateArgument p, ICPPTemplateArgument a, IASTNode point) throws DOMException {
        if (p.isNonTypeValue() != a.isNonTypeValue()) {
            return false;
        }
        if (p.isNonTypeValue()) {
            IValue tval = p.getNonTypeValue();
            if (Value.referencesTemplateParameter(tval)) {
                int parId = Value.isTemplateParameter(tval);
                if (parId >= 0) {
                    ICPPTemplateArgument old = this.fDeducedArgs.getArgument(parId, this.fPackOffset);
                    if (old == null) {
                        return this.deduce(parId, a);
                    }
                    return old.isSameValue(a);
                }
                return true;
            }
            IValue sval = a.getNonTypeValue();
            return tval.equals(sval);
        }
        return this.fromType(p.getTypeValue(), a.getOriginalTypeValue(), false, point);
    }

    private boolean fromType(IType p, IType a, boolean allowCVQConversion, IASTNode point) throws DOMException {
        while (p != null) {
            IPointerType ptrA;
            IPointerType ptrP;
            IType argumentTypeBeforeTypedefResolution = a;
            while (a instanceof ITypedef) {
                a = ((ITypedef)a).getType();
            }
            if (p instanceof IBasicType) {
                return p.isSameType(a);
            }
            if (p instanceof ICPPPointerToMemberType) {
                if (!(a instanceof ICPPPointerToMemberType)) {
                    return false;
                }
                ptrP = (ICPPPointerToMemberType)p;
                ptrA = (ICPPPointerToMemberType)a;
                if (!(allowCVQConversion || ptrP.isConst() == ptrA.isConst() && ptrP.isVolatile() == ptrA.isVolatile())) {
                    return false;
                }
                if (!this.fromType(ptrP.getMemberOfClass(), ptrA.getMemberOfClass(), false, point)) {
                    return false;
                }
                p = ptrP.getType();
                a = ptrA.getType();
                continue;
            }
            if (p instanceof IPointerType) {
                if (!(a instanceof IPointerType)) {
                    return false;
                }
                ptrP = (IPointerType)p;
                ptrA = (IPointerType)a;
                if (!(allowCVQConversion || ptrP.isConst() == ptrA.isConst() && ptrP.isVolatile() == ptrA.isVolatile())) {
                    return false;
                }
                p = ptrP.getType();
                a = ptrA.getType();
                continue;
            }
            if (p instanceof ICPPReferenceType) {
                if (!(a instanceof ICPPReferenceType)) {
                    return false;
                }
                ICPPReferenceType rp = (ICPPReferenceType)p;
                ICPPReferenceType ra = (ICPPReferenceType)a;
                if (ra.isRValueReference() != rp.isRValueReference()) {
                    return false;
                }
                p = rp.getType();
                a = ra.getType();
                continue;
            }
            if (p instanceof IArrayType) {
                IValue ps;
                if (!(a instanceof IArrayType)) {
                    return false;
                }
                IArrayType aa = (IArrayType)a;
                IArrayType pa = (IArrayType)p;
                IValue as = aa.getSize();
                if (as != (ps = pa.getSize())) {
                    CPPBasicType wildcardIntegralType;
                    ICPPTemplateArgument old;
                    if (as == null || ps == null) {
                        return false;
                    }
                    int parID = Value.isTemplateParameter(ps);
                    if (parID >= 0 ? ((old = this.fDeducedArgs.getArgument(parID, this.fPackOffset)) == null ? !this.deduce(parID, new CPPTemplateNonTypeArgument(as, wildcardIntegralType = new CPPBasicType(IBasicType.Kind.eInt, 0x40000000))) : !as.equals(old.getNonTypeValue())) : !as.equals(as)) {
                        return false;
                    }
                }
                p = pa.getType();
                a = aa.getType();
                continue;
            }
            if (p instanceof IQualifierType) {
                CVQualifier cvqP = SemanticUtil.getCVQualifier(p);
                CVQualifier cvqA = SemanticUtil.getCVQualifier(a);
                CVQualifier remaining = CVQualifier.NONE;
                if (cvqP != cvqA) {
                    if (!allowCVQConversion && !cvqA.isAtLeastAsQualifiedAs(cvqP)) {
                        return false;
                    }
                    remaining = cvqA.remove(cvqP);
                }
                p = SemanticUtil.getNestedType(p, 16);
                a = SemanticUtil.getNestedType(a, 16);
                if (p instanceof IQualifierType) {
                    return false;
                }
                if (remaining == CVQualifier.NONE) continue;
                a = SemanticUtil.addQualifiers(a, remaining.isConst(), remaining.isVolatile(), remaining.isRestrict());
                continue;
            }
            if (p instanceof ICPPFunctionType) {
                if (!(a instanceof ICPPFunctionType)) {
                    return false;
                }
                return this.fromFunctionType((ICPPFunctionType)p, (ICPPFunctionType)a, point);
            }
            if (p instanceof ICPPTemplateParameter) {
                ICPPTemplateArgument current = this.fDeducedArgs.getArgument(((ICPPTemplateParameter)((Object)p)).getParameterID(), this.fPackOffset);
                if (current != null) {
                    if (current.isNonTypeValue()) {
                        return false;
                    }
                    return current.getTypeValue().isSameType(a);
                }
                if (a == null) {
                    return false;
                }
                return this.deduce(((ICPPTemplateParameter)((Object)p)).getParameterID(), new CPPTemplateTypeArgument(a, argumentTypeBeforeTypedefResolution));
            }
            if (p instanceof ICPPTemplateInstance) {
                if (!(a instanceof ICPPTemplateInstance)) {
                    return false;
                }
                return this.fromTemplateInstance((ICPPTemplateInstance)((Object)p), (ICPPTemplateInstance)((Object)a), point);
            }
            if (p instanceof ICPPUnknownBinding) {
                return true;
            }
            return p.isSameType(a);
        }
        return false;
    }

    private boolean fromTemplateInstance(ICPPTemplateInstance pInst, ICPPTemplateInstance aInst, IASTNode point) throws DOMException {
        int tparId;
        ICPPTemplateArgument current;
        ICPPClassTemplate pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst);
        ICPPClassTemplate aTemplate = TemplateArgumentDeduction.getPrimaryTemplate(aInst);
        if (pTemplate == null || aTemplate == null) {
            return false;
        }
        if (pTemplate instanceof ICPPTemplateTemplateParameter ? ((current = this.fDeducedArgs.getArgument(tparId = ((ICPPTemplateTemplateParameter)pTemplate).getParameterID(), this.fPackOffset)) != null ? current.isNonTypeValue() || !current.getTypeValue().isSameType(aTemplate) : !this.deduce(tparId, new CPPTemplateTypeArgument(aTemplate))) : !aTemplate.isSameType(pTemplate)) {
            return false;
        }
        ICPPTemplateArgument[] pArgs = pInst.getTemplateArguments();
        int i = 0;
        while (i < pArgs.length - 1) {
            if (pArgs[i].isPackExpansion()) {
                return true;
            }
            ++i;
        }
        ICPPTemplateArgument[] aArgs = aInst.getTemplateArguments();
        if (pArgs.length != aArgs.length) {
            if (pArgs.length == 0 || pArgs.length > aArgs.length + 1) {
                return false;
            }
            ICPPTemplateArgument lastPParam = pArgs[pArgs.length - 1];
            if (!lastPParam.isPackExpansion()) {
                return false;
            }
        }
        ICPPTemplateArgument expansionPattern = null;
        TemplateArgumentDeduction deduct = this;
        int i2 = 0;
        while (i2 < aArgs.length) {
            ICPPTemplateArgument p;
            if (expansionPattern != null) {
                p = expansionPattern;
                deduct.incPackOffset();
                p = CPPTemplates.instantiateArgument(p, this.fExplicitArgs, deduct.fPackOffset, null, point);
                if (!CPPTemplates.isValidArgument(p)) {
                    return false;
                }
            } else {
                p = pArgs[i2];
                if (p.isPackExpansion()) {
                    p = expansionPattern = p.getExpansionPattern();
                    deduct = new TemplateArgumentDeduction(this, aArgs.length - i2);
                    if (!CPPTemplates.isValidArgument(p = CPPTemplates.instantiateArgument(p, this.fExplicitArgs, deduct.fPackOffset, null, point))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromTemplateArgument(p, aArgs[i2], point)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean fromFunctionType(ICPPFunctionType ftp, ICPPFunctionType fta, IASTNode point) throws DOMException {
        IType[] aParams;
        if (ftp.isConst() != fta.isConst() || ftp.isVolatile() != fta.isVolatile()) {
            return false;
        }
        if (!this.fromType(ftp.getReturnType(), fta.getReturnType(), false, point)) {
            return false;
        }
        IType[] pParams = ftp.getParameterTypes();
        if (pParams.length != (aParams = fta.getParameterTypes()).length) {
            if (SemanticUtil.isEmptyParameterList(pParams) && SemanticUtil.isEmptyParameterList(aParams)) {
                return true;
            }
            if (pParams.length == 0 || pParams.length > aParams.length + 1) {
                return false;
            }
            IType lastPParam = pParams[pParams.length - 1];
            if (!(lastPParam instanceof ICPPParameterPackType)) {
                return false;
            }
        }
        IType parameterPack = null;
        TemplateArgumentDeduction deduct = this;
        int i = 0;
        while (i < aParams.length) {
            IType p;
            if (parameterPack != null) {
                p = parameterPack;
                deduct.incPackOffset();
                p = CPPTemplates.instantiateType(p, this.fExplicitArgs, deduct.fPackOffset, null, point);
                if (!CPPTemplates.isValidType(p)) {
                    return false;
                }
            } else {
                p = pParams[i];
                if (p instanceof ICPPParameterPackType) {
                    p = parameterPack = ((ICPPParameterPackType)p).getType();
                    deduct = new TemplateArgumentDeduction(this, aParams.length - i);
                    if (!CPPTemplates.isValidType(p = CPPTemplates.instantiateType(p, this.fExplicitArgs, deduct.fPackOffset, null, point))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromType(p, aParams[i], false, point)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean deduce(int parID, ICPPTemplateArgument arg) {
        if (this.fTemplateParameterPacks != null && this.fTemplateParameterPacks.contains(parID)) {
            if (this.fPackSize == 0) {
                return false;
            }
            return this.fDeducedArgs.putPackElement(parID, this.fPackOffset, arg, this.fPackSize);
        }
        if (SemanticUtil.containsUniqueTypeForParameterPack(arg.getTypeValue())) {
            return false;
        }
        this.fDeducedArgs.put(parID, arg);
        return true;
    }
}

