/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.RemoteUIServicesProxy;
import org.eclipse.ptp.remote.ui.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTPRemoteUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.remote.ui";
    public static final String EXTENSION_POINT_ID = "remoteUIServices";
    private static PTPRemoteUIPlugin plugin;
    private IRemoteServices[] fInitializedServices = null;
    private IRemoteServices fRemoteService = null;
    private Map<String, RemoteUIServicesProxy> remoteUIServices = null;

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPRemoteUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPRemoteUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PTPRemoteUIPlugin getDefault() {
        return plugin;
    }

    public static Shell getShell() {
        if (PTPRemoteUIPlugin.getActiveWorkbenchWindow() != null) {
            return PTPRemoteUIPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static void log(IStatus status) {
        PTPRemoteUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        PTPRemoteUIPlugin.log((IStatus)new Status(4, PTPRemoteUIPlugin.getDefault().getBundle().getSymbolicName(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPRemoteUIPlugin.log((IStatus)new Status(4, PTPRemoteUIPlugin.getDefault().getBundle().getSymbolicName(), 4, Messages.PTPRemoteUIPlugin_3, e));
    }

    public synchronized IRemoteServices[] getRemoteServices(IRunnableContext context) {
        if (this.fInitializedServices == null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PTPRemoteUIPlugin_4, (int)10);
                    try {
                        PTPRemoteUIPlugin.this.fInitializedServices = PTPRemoteCorePlugin.getDefault().getAllRemoteServices((IProgressMonitor)progress.newChild(10));
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                IRemoteServices[] iRemoteServicesArray = this.fInitializedServices = PTPRemoteCorePlugin.getDefault().getAllRemoteServices();
                int n = this.fInitializedServices.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteServices services = iRemoteServicesArray[n2];
                    if (!services.isInitialized()) {
                        if (context != null) {
                            context.run(true, false, runnable);
                        } else {
                            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (InvocationTargetException e) {
                PTPRemoteUIPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.fInitializedServices;
    }

    public synchronized IRemoteServices getRemoteServices(final String id, IRunnableContext context) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PTPRemoteUIPlugin_4, (int)10);
                try {
                    PTPRemoteUIPlugin.this.fRemoteService = PTPRemoteCorePlugin.getDefault().getRemoteServices(id, (IProgressMonitor)progress.newChild(10));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.fRemoteService = PTPRemoteCorePlugin.getDefault().getRemoteServices(id);
            if (this.fRemoteService != null && !this.fRemoteService.isInitialized()) {
                if (context != null) {
                    context.run(true, false, runnable);
                } else {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                }
            }
        }
        catch (InvocationTargetException e) {
            PTPRemoteUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return this.fRemoteService;
    }

    public synchronized IRemoteServices getRemoteServices(final URI uri, IRunnableContext context) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PTPRemoteUIPlugin_4, (int)10);
                try {
                    PTPRemoteUIPlugin.this.fRemoteService = PTPRemoteCorePlugin.getDefault().getRemoteServices(uri, (IProgressMonitor)progress.newChild(10));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.fRemoteService = PTPRemoteCorePlugin.getDefault().getRemoteServices(uri);
            if (!this.fRemoteService.isInitialized()) {
                if (context != null) {
                    context.run(true, false, runnable);
                } else {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                }
            }
        }
        catch (InvocationTargetException e) {
            PTPRemoteUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return this.fRemoteService;
    }

    public IRemoteUIServices getRemoteUIServices(IRemoteServices services) {
        RemoteUIServicesProxy proxy;
        if (this.remoteUIServices == null) {
            this.remoteUIServices = this.retrieveRemoteUIServices();
        }
        if ((proxy = this.remoteUIServices.get(services.getId())) != null) {
            return proxy.getUIServices(services);
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private Map<String, RemoteUIServicesProxy> retrieveRemoteUIServices() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        HashMap<String, RemoteUIServicesProxy> services = new HashMap<String, RemoteUIServicesProxy>(5);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                RemoteUIServicesProxy proxy = new RemoteUIServicesProxy(ce);
                services.put(proxy.getId(), proxy);
                ++n4;
            }
            ++n2;
        }
        return services;
    }
}

