/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.runnable;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.rm.jaxb.control.internal.data.LineImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.EnvironmentVariableUtils;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.ArgType;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.LineType;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptHandler
extends Job {
    private final String uuid;
    private final IVariableMap map;
    private final Map<String, String> launchEnv;
    private ScriptType script;
    private String scriptValue;

    public ScriptHandler(String uuid, ScriptType script, IVariableMap map, Map<String, String> launchEnv, boolean convert) {
        super(Messages.ScriptHandlerJob);
        this.uuid = uuid;
        this.script = script;
        this.launchEnv = launchEnv;
        this.map = map;
        if (convert) {
            this.convertScript();
        }
    }

    public String getScriptValue() {
        return this.scriptValue;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.scriptValue = this.composeScript(monitor);
        if (this.map instanceof RMVariableMap) {
            RMVariableMap rmMap = (RMVariableMap)this.map;
            AttributeType a = new AttributeType();
            a.setName("script");
            a.setValue((Object)this.scriptValue);
            a.setVisible(Boolean.valueOf(false));
            rmMap.put("script", a);
        }
        return Status.OK_STATUS;
    }

    private String composeScript(IProgressMonitor monitor) {
        List line = this.script.getLine();
        int len = line.size();
        if (len == 0) {
            return "";
        }
        int envAfter = this.script.getInsertEnvironmentAfter();
        if (envAfter == -1 || envAfter < 0 || envAfter >= len) {
            envAfter = 1;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)len);
        StringBuffer buffer = new StringBuffer();
        String s = null;
        int i = 0;
        String firstLine = new LineImpl(this.uuid, (LineType)line.get(0), this.map).getResolved();
        while (i <= envAfter) {
            s = new LineImpl(this.uuid, (LineType)line.get(i), this.map).getResolved();
            if (!"".equals(s)) {
                buffer.append(s).append("\n");
            }
            progress.worked(1);
            ++i;
        }
        if (this.launchEnv != null) {
            for (String var : this.launchEnv.keySet()) {
                EnvironmentVariableUtils.addVariable(var, this.launchEnv.get(var), firstLine, buffer);
            }
        }
        while (i < len) {
            s = new LineImpl(this.uuid, (LineType)line.get(i), this.map).getResolved();
            if (!"".equals(s)) {
                buffer.append(s).append("\n");
            }
            progress.worked(1);
            ++i;
        }
        return buffer.toString();
    }

    private void convertScript() {
        ScriptType ltScript = new ScriptType();
        ltScript.setInsertEnvironmentAfter(Integer.valueOf(this.script.getInsertEnvironmentAfter()));
        List lines = ltScript.getLine();
        List args = null;
        for (LineType line : this.script.getLine()) {
            LineType newLine = new LineType();
            args = newLine.getArg();
            for (ArgType a : line.getArg()) {
                ArgType newA = new ArgType();
                newA.setIsUndefinedIfMatches(a.getIsUndefinedIfMatches());
                newA.setContent(a.getContent().replaceAll("ptp_rm:", "ptp_lc:"));
                newA.setResolve(Boolean.valueOf(a.isResolve()));
                args.add(newA);
            }
            lines.add(newLine);
        }
        this.script = ltScript;
    }
}

