/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.model;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.cell.SpinnerCellEditor;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.model.AbstractUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public abstract class CellEditorUpdateModel
extends AbstractUpdateModel
implements ICellEditorUpdateModel {
    protected boolean readOnly;
    protected boolean checked;
    protected String tooltip;
    protected String description;
    protected String status;
    protected String itemsFrom;
    protected Color[] foreground;
    protected Color[] background;
    protected Font[] font;
    protected CellEditor editor;
    protected ViewerUpdateModel viewer;
    protected String stringValue;
    protected int index;
    protected String[] items;
    protected boolean booleanValue;
    protected int integerValue;

    private static String replaceAll(String sequence, String tag, String with) {
        int i = 0;
        int j = 0;
        int ln = sequence.length();
        StringBuffer buffer = new StringBuffer();
        while (i < ln) {
            j = sequence.indexOf(tag, i);
            if (j < 0) {
                j = ln;
                break;
            }
            buffer.append(sequence.substring(i, j)).append(with);
            i = j + tag.length();
        }
        buffer.append(sequence.substring(i, j));
        return buffer.toString();
    }

    protected CellEditorUpdateModel(String name, ValueUpdateHandler handler, CellEditor editor, String[] items, String translateBooleanAs, boolean readOnly, String tooltip, String description, String status, String itemsFrom) {
        super(name, handler);
        this.editor = editor;
        this.readOnly = readOnly;
        this.items = items;
        this.itemsFrom = itemsFrom;
        this.tooltip = tooltip;
        this.description = description;
        this.status = status;
        this.setBooleanToString(translateBooleanAs);
    }

    public boolean canEdit() {
        return this.isChecked() && (!(this.editor instanceof TextCellEditor) || !this.readOnly);
    }

    public Color getBackground(Object element, int columnIndex) {
        if (this.background == null) {
            return null;
        }
        return this.background[columnIndex];
    }

    public CellEditor getCellEditor() {
        return this.editor;
    }

    public Image getColumnImage(String columnName) {
        return null;
    }

    public Object getControl() {
        return this.editor;
    }

    public String getDescription() {
        return this.description;
    }

    public Font getFont(Object element, int columnIndex) {
        if (this.font == null) {
            return null;
        }
        return this.font[columnIndex];
    }

    public Color getForeground(Object element, int columnIndex) {
        if (this.foreground == null) {
            return null;
        }
        return this.foreground[columnIndex];
    }

    public Viewer getParent() {
        return (Viewer)this.viewer.getControl();
    }

    public String getReplacedValue(String pattern) {
        if (!this.isChecked()) {
            return "";
        }
        String value = this.getValueAsString();
        if ("".equals(value)) {
            return "";
        }
        String result = CellEditorUpdateModel.replaceAll(pattern, "@name", this.name);
        return CellEditorUpdateModel.replaceAll(result, "@value", value);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getType() {
        if (this.editor instanceof CheckboxCellEditor) {
            return Boolean.TYPE.getCanonicalName();
        }
        if (this.editor instanceof SpinnerCellEditor) {
            return Integer.TYPE.getCanonicalName();
        }
        return "string";
    }

    public Object getValueForEditor() {
        if (this.editor instanceof TextCellEditor) {
            return this.stringValue;
        }
        if (this.editor instanceof CheckboxCellEditor) {
            return this.booleanValue;
        }
        if (this.editor instanceof SpinnerCellEditor) {
            return this.integerValue;
        }
        if (this.editor instanceof ComboBoxCellEditor) {
            return this.index;
        }
        return null;
    }

    public Object getValueFromControl() {
        return this.mapValue;
    }

    public void initialize(IVariableMap rmMap, LCVariableMap lcMap) {
        this.lcMap = lcMap;
        if (this.editor instanceof ComboBoxCellEditor && this.itemsFrom != null) {
            this.items = WidgetActionUtils.getItemsFrom(rmMap, this.itemsFrom);
            if (this.items.length == 0) {
                this.items = WidgetActionUtils.getItemsFrom(lcMap, this.itemsFrom);
            }
            this.items = WidgetBuilderUtils.normalizeComboItems((String[])this.items);
            ((ComboBoxCellEditor)this.editor).setItems(this.items);
        }
        super.initialize(rmMap, lcMap);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void refreshValueFromMap() {
        this.refreshing = true;
        this.mapValue = this.lcMap.getValue(this.name);
        if (this.editor instanceof TextCellEditor) {
            this.stringValue = "";
            if (this.mapValue != null) {
                this.stringValue = (String)this.mapValue;
            }
        } else if (this.editor instanceof CheckboxCellEditor) {
            this.booleanValue = false;
            if ("".equals(this.mapValue)) {
                this.mapValue = null;
            }
            if (this.mapValue != null) {
                this.booleanValue = this.maybeGetBooleanFromString(this.mapValue);
                Object o = this.getBooleanValue(this.booleanValue);
                if (o instanceof String) {
                    this.stringValue = (String)o;
                }
            }
        } else if (this.editor instanceof SpinnerCellEditor) {
            SpinnerCellEditor e = (SpinnerCellEditor)this.editor;
            this.integerValue = e.getMin();
            if ("".equals(this.mapValue)) {
                this.mapValue = null;
            }
            if (this.mapValue != null) {
                this.integerValue = this.mapValue instanceof String ? Integer.parseInt((String)this.mapValue) : (Integer)this.mapValue;
            }
        } else if (this.editor instanceof ComboBoxCellEditor) {
            if (this.mapValue == null) {
                this.index = -1;
                this.stringValue = "";
            } else {
                this.stringValue = (String)this.mapValue;
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i].equals(this.stringValue)) {
                        this.index = i;
                        break;
                    }
                    ++i;
                }
                if (this.index == this.items.length) {
                    this.index = -1;
                    this.stringValue = "";
                }
            }
        }
        this.refreshing = false;
    }

    public void setBackground(Color[] background) {
        this.background = background;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void setFont(Font[] font) {
        this.font = font;
    }

    public void setForeground(Color[] foreground) {
        this.foreground = foreground;
    }

    public void setValueFromEditor(Object value) {
        if (this.editor instanceof TextCellEditor) {
            this.stringValue = "";
            if (value != null) {
                this.stringValue = (String)value;
            }
            this.mapValue = this.stringValue;
        } else if (this.editor instanceof CheckboxCellEditor) {
            if (value == null) {
                this.booleanValue = false;
            } else {
                this.booleanValue = (Boolean)value;
                Object o = this.getBooleanValue((Boolean)value);
                if (o instanceof String) {
                    this.stringValue = (String)o;
                    this.mapValue = this.stringValue;
                } else {
                    this.mapValue = this.booleanValue;
                }
            }
        } else if (this.editor instanceof SpinnerCellEditor) {
            SpinnerCellEditor e = (SpinnerCellEditor)this.editor;
            this.integerValue = value == null ? e.getMin() : ((Integer)value).intValue();
            this.mapValue = this.integerValue;
        } else if (this.editor instanceof ComboBoxCellEditor) {
            if (value == null || (Integer)value == -1) {
                this.index = -1;
                this.stringValue = "";
            } else {
                this.index = (Integer)value;
                this.stringValue = this.items[this.index];
            }
            this.mapValue = this.stringValue;
        }
        try {
            Object v = this.storeValue();
            this.viewer.storeValue();
            this.handleUpdate(v);
        }
        catch (Exception exception) {}
    }

    public void setViewer(ViewerUpdateModel viewer) {
        this.viewer = viewer;
    }

    protected String getValueAsString() {
        if (this.editor instanceof TextCellEditor || this.editor instanceof ComboBoxCellEditor) {
            return this.stringValue;
        }
        if (this.editor instanceof CheckboxCellEditor) {
            return String.valueOf(this.booleanValue);
        }
        if (this.editor instanceof SpinnerCellEditor) {
            return String.valueOf(this.integerValue);
        }
        return "";
    }
}

