/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rm.core.utils.IInputStreamListener;

public class InputStreamListenerToOutputStream
implements IInputStreamListener {
    boolean enabled = true;
    OutputStream outputStream;

    public InputStreamListenerToOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void newBytes(byte[] bytes, int length) {
        try {
            if (this.isEnabled()) {
                this.outputStream.write(bytes, 0, length);
            }
        }
        catch (IOException e) {
            this.disable();
            this.log(e);
        }
    }

    public void streamClosed() {
        try {
            this.disable();
            this.outputStream.close();
        }
        catch (IOException e) {
            this.log(e);
        }
    }

    public void streamError(Exception e) {
        this.disable();
        this.log(e);
    }

    protected void log(Exception e) {
        PTPCorePlugin.log((Throwable)e);
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }
}

