/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.core.StreamCopyThread;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;

public class CommandRunner {
    public static DirectoryStatus checkLocalDirectory(String localDirectory) {
        File localDir = new File(localDirectory);
        if (!localDir.exists()) {
            return DirectoryStatus.NOT_PRESENT;
        }
        if (localDir.isDirectory()) {
            return DirectoryStatus.PRESENT;
        }
        return DirectoryStatus.NOT_A_DIRECTORY;
    }

    public static DirectoryStatus checkRemoteDirectory(IRemoteConnection conn, String remoteDir) {
        IRemoteFileManager fileManager = conn.getRemoteServices().getFileManager(conn);
        IFileStore fileStore = fileManager.getResource(remoteDir);
        IFileInfo fileInfo = fileStore.fetchInfo();
        if (!fileInfo.exists()) {
            return DirectoryStatus.NOT_PRESENT;
        }
        if (!fileInfo.isDirectory()) {
            return DirectoryStatus.NOT_A_DIRECTORY;
        }
        return DirectoryStatus.PRESENT;
    }

    public static DirectoryStatus createLocalDirectory(String localDirectory) {
        DirectoryStatus directoryStatus = CommandRunner.checkLocalDirectory(localDirectory);
        if (directoryStatus == DirectoryStatus.NOT_PRESENT) {
            File localDir = new File(localDirectory);
            localDir.mkdir();
        }
        return directoryStatus;
    }

    public static DirectoryStatus createRemoteDirectory(IRemoteConnection conn, String remoteDir, IProgressMonitor monitor) throws CoreException {
        IRemoteFileManager fileManager = conn.getRemoteServices().getFileManager(conn);
        IFileStore fileStore = fileManager.getResource(remoteDir);
        IFileInfo fileInfo = fileStore.fetchInfo();
        if (fileInfo.exists()) {
            if (fileInfo.isDirectory()) {
                return DirectoryStatus.PRESENT;
            }
            return DirectoryStatus.NOT_A_DIRECTORY;
        }
        fileStore.mkdir(0, monitor);
        return DirectoryStatus.NOT_PRESENT;
    }

    public static CommandResults executeRemoteCommand(IRemoteConnection conn, String command, String remoteDirectory, IProgressMonitor monitor) throws IOException, InterruptedException, RemoteConnectionException, RemoteSyncException {
        LinkedList<String> commandList = new LinkedList<String>();
        commandList.add("sh");
        commandList.add("-c");
        commandList.add(command);
        return CommandRunner.executeRemoteCommand(conn, commandList, remoteDirectory, monitor);
    }

    public static CommandResults executeRemoteCommand(IRemoteConnection conn, List<String> commandList, String remoteDirectory, IProgressMonitor monitor) throws IOException, InterruptedException, RemoteConnectionException, RemoteSyncException {
        RecursiveSubMonitor progress = RecursiveSubMonitor.convert(monitor, 100);
        try {
            StreamCopyThread getError;
            IRemoteProcess rp;
            ByteArrayOutputStream error;
            ByteArrayOutputStream output;
            block6: {
                progress.subTask(Messages.CommandRunner_4);
                conn.open((IProgressMonitor)progress.newChild(50));
                IRemoteProcessBuilder rpb = conn.getRemoteServices().getProcessBuilder(conn, commandList);
                IRemoteFileManager rfm = conn.getRemoteServices().getFileManager(conn);
                if (remoteDirectory != null && remoteDirectory.length() > 0) {
                    rpb.directory(rfm.getResource(remoteDirectory));
                }
                output = new ByteArrayOutputStream();
                error = new ByteArrayOutputStream();
                progress.subTask(Messages.CommandRunner_3);
                rp = rpb.start();
                StreamCopyThread getOutput = new StreamCopyThread(rp.getInputStream(), output);
                getError = new StreamCopyThread(rp.getErrorStream(), error);
                getOutput.start();
                getError.start();
                do {
                    getOutput.join(250L);
                    if (!getOutput.isAlive()) break block6;
                } while (!progress.isCanceled());
                throw new RemoteSyncException(new Status(8, "org.eclipse.ptp.rdt.sync.core", Messages.CommandRunner_0));
            }
            int exitCode = rp.waitFor();
            getError.halt();
            CommandResults commandResults = new CommandResults();
            commandResults.setExitCode(exitCode);
            commandResults.setStdout(((Object)output).toString());
            commandResults.setStderr(((Object)error).toString());
            CommandResults commandResults2 = commandResults;
            return commandResults2;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private CommandRunner() {
        throw new AssertionError((Object)Messages.CommandRunner_1);
    }

    public static class CommandResults {
        private String stdout;
        private String stderr;
        private int exitCode;

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String getStdout() {
            return this.stdout;
        }

        public void setExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public void setStderr(String stderr) {
            this.stderr = stderr;
        }

        public void setStdout(String stdout) {
            this.stdout = stdout;
        }
    }

    static enum DirectoryStatus {
        NOT_A_DIRECTORY,
        NOT_PRESENT,
        PRESENT;

    }
}

