/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.internal.core.model.LMLCheck;

public class Mask {
    private static final String number = "\\s*(-|\\+)?(0x|0X)?([a-fA-F\\d]+)";
    private String maskString;
    private String regularMask;
    private int outputLength;
    private String pre;
    private String post;
    private String[] names;
    private final SchemeElement scheme;
    private int[] numbers = null;

    public Mask(SchemeElement scheme) {
        this.scheme = scheme;
        if (scheme.getMap() != null) {
            this.names = scheme.getMap().split(",");
            this.outputLength = -1;
            this.regularMask = scheme.getMap().replace(',', '|');
            this.pre = "";
            this.post = "";
            this.maskString = "";
        } else {
            this.names = null;
            this.maskString = scheme.getMask();
            this.outputLength = this.maskString.matches("([^%])*%(\\-|\\+|\\s|\\#)*d([^%])+") ? -1 : String.format(this.maskString, 1).length();
            int perCent = this.maskString.indexOf(37);
            int dPos = this.maskString.indexOf(100, perCent);
            this.pre = this.maskString.substring(0, perCent);
            this.post = this.maskString.substring(dPos + 1, this.maskString.length());
            this.regularMask = String.valueOf(this.pre) + number + this.post;
        }
    }

    public String getImplicitLevelName(int id) {
        return LMLCheck.getLevelName(this.scheme, id);
    }

    public String getMask() {
        return this.maskString;
    }

    public int getNumberOfLevelString(String levelString) {
        if (this.names == null) {
            if (!this.isOutputAllowed(levelString)) {
                return -1;
            }
            levelString = levelString.substring(this.pre.length());
            levelString = levelString.substring(0, levelString.length() - this.post.length());
            char[] chars = levelString.toCharArray();
            int i = 0;
            while (i < chars.length && chars[i] < '0' || chars[i] > '9') {
                ++i;
            }
            if (i == chars.length) {
                return -1;
            }
            String number = String.valueOf(chars[i]);
            ++i;
            while (i < chars.length && chars[i] >= '0' && chars[i] <= '9') {
                number = String.valueOf(number) + chars[i];
                ++i;
            }
            return Integer.parseInt(number);
        }
        int pos = 0;
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(levelString)) {
                if (this.scheme.getList() != null) {
                    if (this.numbers == null) {
                        this.numbers = LMLCheck.getNumbersFromNumberlist(this.scheme.getList());
                    }
                    return this.numbers[pos];
                }
                return this.scheme.getMin().intValue() + this.scheme.getStep().intValue() * pos;
            }
            ++pos;
            ++n2;
        }
        return -1;
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public boolean isOutputAllowed(String output) {
        if (this.names == null) {
            return output.matches(this.regularMask) && (this.outputLength == -1 || this.outputLength == output.length());
        }
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(output)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

