/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.rephraserengine.core.preservation.ModelDiff;
import org.eclipse.rephraserengine.core.preservation.PreservationRuleset;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

abstract class PreservationAnalyzer<A, T, R extends IVPGNode<T>>
extends PreservationRuleset.Processor {
    private final Iterable<VPGEdge<A, T, R>> initialEdges;
    private final Iterable<VPGEdge<A, T, R>> finalEdges;
    private final PreservationRuleset ruleset;
    private final Iterator<VPGEdge<A, T, R>> initialIterator;
    private final Iterator<VPGEdge<A, T, R>> finalIterator;
    private VPGEdge<A, T, R> initialEdge;
    private VPGEdge<A, T, R> finalEdge;
    private int targetType;
    private VPGEdge.Classification targetClassification;

    public PreservationAnalyzer(Collection<VPGEdge<A, T, R>> initialEdges, Collection<VPGEdge<A, T, R>> finalEdges, PreservationRuleset ruleset) {
        this.initialEdges = initialEdges;
        this.finalEdges = finalEdges;
        this.ruleset = ruleset;
        this.initialIterator = initialEdges.iterator();
        this.finalIterator = finalEdges.iterator();
        this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
        this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
    }

    public void checkPreservation(int targetType, VPGEdge.Classification targetClassification, ModelDiff diff) throws UnexpectedEdgeException {
        this.targetType = targetType;
        this.targetClassification = targetClassification;
        while (this.finalEdge() != null || this.initialEdge() != null) {
            try {
                this.ruleset.invokeCallback(targetType, targetClassification, this);
            }
            catch (UnexpectedInitialEdge exception) {
                VPGEdge entry = exception.getEdge();
                System.err.println("Unexpected initial edge " + entry);
                VPGEdge otherEntry = this.findEdgeWithNewSink(entry);
                if (otherEntry != null) {
                    diff.add(new ModelDiff.EdgeSinkChanged(entry, otherEntry));
                    continue;
                }
                diff.add(new ModelDiff.EdgeDeleted(entry));
            }
            catch (UnexpectedFinalEdge exception) {
                VPGEdge edge = exception.getEdge();
                System.err.println("Unexpected final edge " + edge);
                diff.add(new ModelDiff.EdgeAdded(edge));
            }
        }
    }

    private VPGEdge<A, T, R> finalEdge() {
        return this.getEdge(this.finalEdge);
    }

    private VPGEdge<A, T, R> initialEdge() {
        return this.getEdge(this.initialEdge);
    }

    private VPGEdge<A, T, R> getEdge(VPGEdge<A, T, R> edge) {
        if (edge == null) {
            return null;
        }
        if (edge.getType() < this.targetType) {
            throw new IllegalStateException("INTERNAL ERROR: Type " + this.targetType + " processing terminated prematurely");
        }
        if (edge.getType() != this.targetType) {
            return null;
        }
        if (!edge.getClassification().equals((Object)this.targetClassification)) {
            return null;
        }
        return edge;
    }

    @Override
    void handleIgnore() {
        if (this.finalEdge() != null) {
            VPGEdge<A, T, R> vPGEdge = this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
        }
        if (this.initialEdge() != null) {
            this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
        }
    }

    @Override
    void handlePreserveAll() {
        VPGEdge<A, T, R> finalEdge = this.finalEdge();
        VPGEdge<A, T, R> initialEdge = this.initialEdge();
        if (finalEdge != null && initialEdge == null) {
            this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
            throw new UnexpectedFinalEdge(finalEdge);
        }
        if (finalEdge == null && initialEdge != null) {
            this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
            throw new UnexpectedInitialEdge(initialEdge);
        }
        if (finalEdge != null && initialEdge != null) {
            int comparison = finalEdge.compareTo(initialEdge);
            if (comparison < 0) {
                this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
                throw new UnexpectedFinalEdge(finalEdge);
            }
            if (comparison == 0) {
                this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
                this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
            } else {
                this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
                throw new UnexpectedInitialEdge(finalEdge);
            }
        }
    }

    @Override
    void handlePreserveSubset() {
        VPGEdge<A, T, R> finalEdge = this.finalEdge();
        VPGEdge<A, T, R> initialEdge = this.initialEdge();
        if (finalEdge != null && initialEdge == null) {
            this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
            throw new UnexpectedFinalEdge(finalEdge);
        }
        if (finalEdge != null && initialEdge != null) {
            int comparison = finalEdge.compareTo(initialEdge);
            if (comparison < 0) {
                this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
                throw new UnexpectedFinalEdge(finalEdge);
            }
            if (comparison == 0) {
                this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
                this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
            } else {
                this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
            }
        }
    }

    @Override
    void handlePreserveSuperset() {
        VPGEdge<A, T, R> finalEdge = this.finalEdge();
        VPGEdge<A, T, R> initialEdge = this.initialEdge();
        if (finalEdge == null && initialEdge != null) {
            this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
            throw new UnexpectedInitialEdge(initialEdge);
        }
        if (finalEdge != null && initialEdge != null) {
            int comparison = finalEdge.compareTo(initialEdge);
            if (comparison < 0) {
                this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
                throw new UnexpectedFinalEdge(finalEdge);
            }
            if (comparison == 0) {
                this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
                this.finalEdge = this.finalIterator.hasNext() ? this.finalIterator.next() : null;
            } else {
                this.initialEdge = this.initialIterator.hasNext() ? this.initialIterator.next() : null;
            }
        }
    }

    public boolean hasEdgesRemaining() {
        return this.initialIterator.hasNext() || this.finalIterator.hasNext();
    }

    public void ensureNoEdgesRemaining(int type) {
        if (this.initialEdge != null && this.initialEdge.getType() == type) {
            throw new IllegalStateException("INTERNAL ERROR: Type " + type + " processing incomplete - initial edge " + this.initialEdge);
        }
        if (this.finalEdge != null && this.finalEdge.getType() == type) {
            throw new IllegalStateException("INTERNAL ERROR: Type " + type + " processing incomplete - final edge " + this.finalEdge);
        }
    }

    private VPGEdge<A, T, R> findEdgeWithNewSink(VPGEdge<A, T, R> initialEdge) {
        for (VPGEdge<A, T, R> finalEdge : this.finalEdges) {
            if (finalEdge.getSource() == null || !finalEdge.getSource().equals(initialEdge.getSource()) || finalEdge.getType() != initialEdge.getType()) continue;
            return finalEdge;
        }
        return null;
    }

    public int countEdgesRemaining() {
        if (this.initialEdges instanceof List && this.initialIterator instanceof ListIterator && this.finalEdges instanceof List && this.initialIterator instanceof ListIterator) {
            return ((List)this.initialEdges).size() - ((ListIterator)this.initialIterator).nextIndex() + (((List)this.finalEdges).size() - ((ListIterator)this.finalIterator).nextIndex());
        }
        return 0;
    }

    private static abstract class UnexpectedEdgeException
    extends Error {
        private VPGEdge<?, ?, ?> edge;

        public UnexpectedEdgeException(VPGEdge<?, ?, ?> edge) {
            this.edge = edge;
        }

        public <A, T, R extends IVPGNode<T>> VPGEdge<A, T, R> getEdge() {
            return this.edge;
        }
    }

    private static class UnexpectedFinalEdge
    extends UnexpectedEdgeException {
        public UnexpectedFinalEdge(VPGEdge<?, ?, ?> edge) {
            super(edge);
        }
    }

    private static class UnexpectedInitialEdge
    extends UnexpectedEdgeException {
        public UnexpectedInitialEdge(VPGEdge<?, ?, ?> edge) {
            super(edge);
        }
    }
}

