/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.generic.core.rtsystem;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.rm.core.MPIJobAttributes;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.core.utils.IInputStreamListener;
import org.eclipse.ptp.rm.core.utils.InputStreamObserver;
import org.eclipse.ptp.rm.generic.core.GenericRMCorePlugin;
import org.eclipse.ptp.rm.generic.core.messages.Messages;
import org.eclipse.ptp.rm.generic.core.rtsystem.GenericRMRuntimeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRMRuntimeSystemJob
extends AbstractToolRuntimeSystemJob {
    private InputStreamObserver stderrObserver;
    private InputStreamObserver stdoutObserver;

    public GenericRMRuntimeSystemJob(String jobID, String name, AbstractToolRuntimeSystem rtSystem, AttributeManager attrMgr) {
        super(jobID, name, rtSystem, attrMgr);
    }

    private void terminateProcesses() {
        IPJob ipJob;
        GenericRMRuntimeSystem rtSystem = (GenericRMRuntimeSystem)this.getRtSystem();
        IPResourceManager rm = rtSystem.getPResourceManager();
        if (rm != null && (ipJob = rm.getJobById(this.getJobID())) != null) {
            AttributeManager attrMrg = new AttributeManager();
            attrMrg.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.COMPLETED));
            BitSet procJobRanks = ipJob.getProcessJobRanks();
            rtSystem.changeProcesses(ipJob.getID(), procJobRanks, attrMrg);
        }
    }

    protected void addProcess(IPJob job) {
        GenericRMRuntimeSystem rts = (GenericRMRuntimeSystem)this.getRtSystem();
        rts.createProcesses(job.getID(), 1);
        BitSet processIndices = new BitSet();
        processIndices.set(0);
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)ProcessAttributes.getNodeIdAttributeDefinition().create(rts.getNodeId()));
        attrMgr.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.RUNNING));
        this.getRtSystem().changeProcesses(job.getID(), processIndices, attrMgr);
    }

    protected void doBeforeExecution(IProgressMonitor monitor, IRemoteProcessBuilder builder) throws CoreException {
    }

    protected void doExecutionCleanUp(IProgressMonitor monitor) {
        if (this.getProcess() != null) {
            this.getProcess().destroy();
            this.setProcess(null);
        }
        if (this.getStderrObserver() != null) {
            this.getStderrObserver().kill();
            this.setStderrObserver(null);
        }
        if (this.getStdoutObserver() != null) {
            this.getStdoutObserver().kill();
            this.setStdoutObserver(null);
        }
        this.terminateProcesses();
    }

    protected void doExecutionFinished(IProgressMonitor monitor) throws CoreException {
        this.terminateProcesses();
        if (this.getProcess().exitValue() != 0) {
            if (!this.terminateJobFlag) {
                this.changeJobStatusMessage(NLS.bind((String)Messages.GenericRMRuntimeSystemJob_Exception_ExecutionFailedWithExitValue, (Object)new Integer(this.getProcess().exitValue())));
                this.changeJobStatus(MPIJobAttributes.Status.ERROR);
            }
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING, (String)"RTS job #{0}: ignoring exit value {1} because job was forced to terminate by user", (Object[])new Object[]{this.getJobID(), new Integer(this.getProcess().exitValue())});
        }
    }

    protected void doExecutionStarted(IProgressMonitor monitor) throws CoreException {
        IPResourceManager rm = this.getRtSystem().getPResourceManager();
        final IPJob job = rm.getJobById(this.getJobID());
        this.addProcess(job);
        final BitSet procZero = new BitSet();
        if (job.hasProcessByJobRank(0)) {
            procZero.set(0);
        }
        IInputStreamListener stdoutListener = new IInputStreamListener(){

            public void newBytes(byte[] bytes, int length) {
                String line = new String(bytes, 0, length);
                if (!procZero.isEmpty()) {
                    AttributeManager attributes = new AttributeManager((IAttribute)ProcessAttributes.getStdoutAttributeDefinition().create(line));
                    job.addProcessAttributes(procZero, attributes);
                }
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}: {1}", (Object[])new Object[]{GenericRMRuntimeSystemJob.this.getJobID(), line});
            }

            public void streamClosed() {
            }

            public void streamError(Exception e) {
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout stream: {0}", (Object[])new Object[]{e});
                GenericRMCorePlugin.log(e);
            }
        };
        IInputStreamListener stderrListener = new IInputStreamListener(){

            public void newBytes(byte[] bytes, int length) {
                String line = new String(bytes, 0, length);
                if (!procZero.isEmpty()) {
                    AttributeManager attributes = new AttributeManager((IAttribute)ProcessAttributes.getStderrAttributeDefinition().create(line));
                    job.addProcessAttributes(procZero, attributes);
                }
                DebugUtil.error((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}: {1}", (Object[])new Object[]{GenericRMRuntimeSystemJob.this.getJobID(), line});
            }

            public void streamClosed() {
            }

            public void streamError(Exception e) {
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr stream: {0}", (Object[])new Object[]{e});
                GenericRMCorePlugin.log(e);
            }
        };
        this.setStderrObserver(new InputStreamObserver(this.getProcess().getErrorStream()));
        this.getStderrObserver().addListener(stderrListener);
        this.getStderrObserver().start();
        this.setStdoutObserver(new InputStreamObserver(this.getProcess().getInputStream()));
        this.getStdoutObserver().addListener(stdoutListener);
        this.getStdoutObserver().start();
    }

    protected void doPrepareExecution(IProgressMonitor monitor) throws CoreException {
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolBaseSubstitutionAttributes() throws CoreException {
        return null;
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolCommandSubstitutionAttributes(AttributeManager baseSubstitutionAttributeManager, String directory, Map<String, String> environment) {
        return null;
    }

    protected HashMap<String, String> doRetrieveToolEnvironment() throws CoreException {
        return null;
    }

    protected void doTerminateJob() {
    }

    protected void doWaitExecution(IProgressMonitor monitor) throws CoreException {
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stderr thread to finish", (Object[])new Object[]{this.getJobID()});
        try {
            this.getStderrObserver().join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stdout thread to finish", (Object[])new Object[]{this.getJobID()});
        try {
            this.getStdoutObserver().join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting mpi process to finish completely", (Object[])new Object[]{this.getJobID()});
        try {
            this.getProcess().waitFor();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.getProcess().getErrorStream().close();
            this.getProcess().getInputStream().close();
        }
        catch (IOException iOException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: completely finished", (Object[])new Object[]{this.getJobID()});
    }

    protected InputStreamObserver getStderrObserver() {
        return this.stderrObserver;
    }

    protected InputStreamObserver getStdoutObserver() {
        return this.stdoutObserver;
    }

    protected void setStderrObserver(InputStreamObserver stderrObserver) {
        this.stderrObserver = stderrObserver;
    }

    protected void setStdoutObserver(InputStreamObserver stdoutObserver) {
        this.stdoutObserver = stdoutObserver;
    }
}

