/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.rm.jaxb.core.JAXBCoreConstants;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.JAXBInitializationUtils;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.osgi.framework.Bundle;

public class JAXBExtensionUtils {
    private static Map<String, URL> fPluginConfigurations = new TreeMap<String, URL>();
    private static Map<String, URL> fExternalConfigurations = new TreeMap<String, URL>();
    private static String fInvalid;

    public static String getInvalid() {
        return fInvalid;
    }

    public static String[] getConfiguationNames() {
        JAXBExtensionUtils.loadExtensions();
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(fPluginConfigurations.keySet());
        set.addAll(fExternalConfigurations.keySet());
        return set.toArray(new String[0]);
    }

    public static URL getConfigurationURL(String name) {
        JAXBExtensionUtils.loadExtensions();
        URL url = fPluginConfigurations.get(name);
        if (url == null) {
            url = fExternalConfigurations.get(name);
        }
        return url;
    }

    public static Map<String, URL> getPluginConfiguations() {
        JAXBExtensionUtils.loadExtensions();
        TreeMap<String, URL> map = new TreeMap<String, URL>();
        map.putAll(fPluginConfigurations);
        map.putAll(fExternalConfigurations);
        return map;
    }

    private static void loadExtensions() {
        JAXBExtensionUtils.loadPlugins();
        JAXBExtensionUtils.loadExternal();
    }

    private static void loadExternal() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("resourceManagers");
        StringBuffer invalid = new StringBuffer();
        if (project.exists()) {
            try {
                IResource[] resources;
                fExternalConfigurations.clear();
                IResource[] iResourceArray = resources = project.members();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        IFile file;
                        IResource resource = iResourceArray[n2];
                        if (resource instanceof IFile && (file = (IFile)resource).exists() && file.getName().endsWith(".xml")) {
                            try {
                                ResourceManagerData data;
                                URI uri = file.getLocationURI();
                                URL url = uri.toURL();
                                try {
                                    data = JAXBInitializationUtils.initializeRMData(url);
                                }
                                catch (Throwable t) {
                                    invalid.append(JAXBCoreConstants.LINE_SEP).append(file.getName());
                                    JAXBCorePlugin.log(t.getMessage());
                                    break block9;
                                }
                                fExternalConfigurations.put(data.getName(), url);
                            }
                            catch (MalformedURLException t) {
                                JAXBCorePlugin.log(t);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                JAXBCorePlugin.log(e);
            }
        }
        fInvalid = invalid.length() > 0 ? invalid.toString() : null;
    }

    private static void loadPlugins() {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        if (fPluginConfigurations.isEmpty() && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint("org.eclipse.ptp.rm.jaxb.core.JAXBResourceManagerConfigurations")) != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    URL url;
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String name = ce.getAttribute("name");
                    String configurationFile = ce.getAttribute("configurationFile");
                    String bundleId = ce.getDeclaringExtension().getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (name != null && configurationFile != null && bundle != null && (url = bundle.getEntry(configurationFile)) != null) {
                        fPluginConfigurations.put(name, url);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private JAXBExtensionUtils() {
    }
}

