/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.git.core;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class RmCommandCached
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();

    public RmCommandCached(Repository repo) {
        super(repo);
    }

    public RmCommandCached addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        try {
            try {
                dc = this.repo.lockDirCache();
                DirCacheBuilder builder = dc.builder();
                TreeWalk tw = new TreeWalk(this.repo);
                tw.reset();
                tw.setRecursive(true);
                tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
                tw.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
                while (tw.next()) {
                    new File(this.repo.getWorkTree(), tw.getPathString());
                    FileMode mode = tw.getFileMode(0);
                    mode.getObjectType();
                }
                builder.commit();
                this.setCallable(false);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, (Throwable)e);
            }
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }

    private void delete(File p) {
        while (p != null && !p.equals(this.repo.getWorkTree()) && p.delete()) {
            p = p.getParentFile();
        }
    }
}

