/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml_jaxb.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.internal.core.model.Row;
import org.eclipse.ptp.rm.lml_jaxb.actions.AbstractStatusAction;
import org.eclipse.ptp.rm.lml_jaxb.actions.ActionUtils;
import org.eclipse.ptp.rm.lml_jaxb.messages.Messages;
import org.eclipse.ui.IViewPart;

public class CancelJob
extends AbstractStatusAction {
    public void run(IAction action) {
        Job j = new Job(Messages.CancelJob){

            protected IStatus run(IProgressMonitor monitor) {
                for (Row row : CancelJob.this.selected) {
                    JobStatusData status = row.status;
                    try {
                        ActionUtils.callDoControl(status, "TERMINATE", monitor);
                        if (!monitor.isCanceled()) continue;
                        break;
                    }
                    catch (CoreException t) {
                        return CoreExceptionUtils.getErrorStatus((String)Messages.CancelJobError, (Throwable)t);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    protected void validate(IAction action) {
        for (Row row : this.selected) {
            JobStatusData status = row.status;
            if (status == null || !ActionUtils.isAuthorised(status)) {
                action.setEnabled(false);
                return;
            }
            if (!CancelJob.operationSupported(status, "TERMINATE", (IViewPart)this.view)) {
                action.setEnabled(false);
                return;
            }
            String state = status.getState();
            if (!"COMPLETED".equals(state)) continue;
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
    }
}

