/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.internal.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.ui.preferences.ScrolledPageContent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SDMPage
extends AbstractLaunchConfigurationTab {
    protected static final String EXTENSION_POINT_ID = "defaultPath";
    protected static final String ATTR_PATH = "path";
    protected static final String EMPTY_STRING = "";
    protected static final String LOCALHOST = "localhost";
    private IRemoteConnection fRemoteConnection;
    protected Combo fSDMBackendCombo;
    protected Text fSDMPathText;
    protected Text fSessionAddressText;
    protected Text fBackendPathText;
    protected Button fSDMPathBrowseButton;
    protected Button fBackendPathBrowseButton;
    protected Button fDefaultSessionAddressButton;
    protected ExpandableComposite fAdvancedOptions;

    public boolean canSave() {
        this.setErrorMessage(null);
        if (this.getFieldContent(this.fSessionAddressText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_7);
        } else if (this.getFieldContent(this.fSDMPathText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_8);
        }
        return this.getErrorMessage() == null;
    }

    public void createControl(Composite parent) {
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        pageContent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp = pageContent.getBody();
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(comp, 0);
        label.setText(Messages.SDMPage_11);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fSDMBackendCombo = new Combo(comp, 8);
        this.fSDMBackendCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSDMBackendCombo.setItems(SDMDebugCorePlugin.getDefault().getDebuggerBackends());
        this.fSDMBackendCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDMPage.this.updateBackend();
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.SDMPage_0);
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fSDMPathText = new Text(comp, 2052);
        this.fSDMPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fSDMPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSDMPathBrowseButton = this.createPushButton(comp, Messages.SDMPage_1, null);
        this.fSDMPathBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fSDMPathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file = SDMPage.this.browseFile();
                if (file != null) {
                    SDMPage.this.fSDMPathText.setText(file);
                }
            }
        });
        this.fAdvancedOptions = new ExpandableComposite(comp, 0, 18);
        this.fAdvancedOptions.setText(Messages.SDMPage_12);
        this.fAdvancedOptions.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parent = SDMPage.this.getParentScrolledComposite((Control)((ExpandableComposite)e.getSource()));
                if (parent != null) {
                    parent.reflow(true);
                }
            }
        });
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        this.fAdvancedOptions.setLayoutData((Object)gd);
        Composite advComp = new Composite((Composite)this.fAdvancedOptions, 0);
        this.fAdvancedOptions.setClient((Control)advComp);
        advComp.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        advComp.setLayoutData((Object)gd);
        Group sessGroup = new Group(advComp, 16);
        sessGroup.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 3;
        sessGroup.setLayoutData((Object)gd);
        this.fDefaultSessionAddressButton = this.createCheckButton((Composite)sessGroup, Messages.SDMPage_Use_default_session_address);
        this.fDefaultSessionAddressButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDMPage.this.updateEnablement();
            }
        });
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        this.fDefaultSessionAddressButton.setLayoutData((Object)gd);
        this.fDefaultSessionAddressButton.setSelection(true);
        label = new Label((Composite)sessGroup, 0);
        label.setText(Messages.SDMPage_Session_address);
        gd = new GridData(4, 1, false, false);
        label.setLayoutData((Object)gd);
        this.fSessionAddressText = new Text((Composite)sessGroup, 2052);
        this.fSessionAddressText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSessionAddressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        gd = new GridData(4, 1, true, false);
        this.fSessionAddressText.setLayoutData((Object)gd);
        label = new Label(advComp, 0);
        label.setText(Messages.SDMPage_13);
        gd = new GridData(4, 0x1000000, false, false);
        label.setLayoutData((Object)gd);
        this.fBackendPathText = new Text(advComp, 2052);
        this.fBackendPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fBackendPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fBackendPathBrowseButton = this.createPushButton(advComp, Messages.SDMPage_1, null);
        this.fBackendPathBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fBackendPathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file = SDMPage.this.browseFile();
                if (file != null) {
                    SDMPage.this.fBackendPathText.setText(file);
                }
            }
        });
        this.setControl((Control)parent);
    }

    public String getName() {
        return Messages.SDMPage_3;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String backend = Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.PREFS_SDM_BACKEND);
            this.fSDMBackendCombo.setText(configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", backend));
            this.fSessionAddressText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", LOCALHOST));
            this.fSDMPathText.setText(configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)(String.valueOf(SDMPreferenceConstants.PREFS_SDM_PATH) + backend))));
            this.fBackendPathText.setText(configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND_PATH", Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)(String.valueOf(SDMPreferenceConstants.PREFS_SDM_BACKEND_PATH) + backend))));
            this.fRemoteConnection = this.getRemoteConnection(configuration);
            this.fDefaultSessionAddressButton.setSelection(this.fRemoteConnection == null || this.fRemoteConnection.supportsTCPPortForwarding() && this.fSessionAddressText.getText().equals(LOCALHOST));
            this.updateEnablement();
        }
        catch (CoreException coreException) {}
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.getFieldContent(this.fSessionAddressText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_4);
        } else if (this.getFieldContent(this.fSDMPathText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_5);
        }
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid((ILaunchConfiguration)configuration)) {
            configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", this.getFieldContent(this.fSDMBackendCombo.getText()));
            configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND_PATH", this.getFieldContent(this.fBackendPathText.getText()));
            configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", this.getFieldContent(this.fSDMPathText.getText()));
            configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", this.getFieldContent(this.fSessionAddressText.getText()));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String backend = Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.PREFS_SDM_BACKEND);
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", backend);
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)(String.valueOf(SDMPreferenceConstants.PREFS_SDM_PATH) + backend)));
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND_PATH", Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)(String.valueOf(SDMPreferenceConstants.PREFS_SDM_BACKEND_PATH) + backend)));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", LOCALHOST);
    }

    private String browseFile() {
        IRemoteUIFileManager fileManager;
        IRemoteUIServices remoteUISrv;
        if (this.fRemoteConnection != null && (remoteUISrv = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fRemoteConnection.getRemoteServices())) != null && (fileManager = remoteUISrv.getUIFileManager()) != null) {
            fileManager.setConnection(this.fRemoteConnection);
            return fileManager.browseFile(this.getShell(), Messages.SDMPage_10, this.fSDMPathText.getText(), 0);
        }
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(Messages.SDMPage_10);
        dialog.setFileName(this.fSDMPathText.getText());
        return dialog.open();
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private IRemoteConnection getRemoteConnection(ILaunchConfiguration configuration) {
        block6: {
            try {
                String name;
                final String remId = configuration.getAttribute("org.eclipse.ptp.launch.REMOTE_SERVICES_ID", null);
                if (remId == null) break block6;
                final IRemoteServices[] services = new IRemoteServices[1];
                try {
                    this.getLaunchConfigurationDialog().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            services[0] = PTPRemoteCorePlugin.getDefault().getRemoteServices(remId, monitor);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                if (services[0] != null && (name = configuration.getAttribute("org.eclipse.ptp.launch.CONNECTION_NAME", null)) != null) {
                    return services[0].getConnectionManager().getConnection(name);
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private void updateBackend() {
        String backend = this.getFieldContent(this.fSDMBackendCombo.getText());
        if (backend != null) {
            this.fSDMPathText.setText(Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)(String.valueOf(SDMPreferenceConstants.PREFS_SDM_PATH) + backend)));
            this.fBackendPathText.setText(Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)(String.valueOf(SDMPreferenceConstants.PREFS_SDM_BACKEND_PATH) + backend)));
        }
    }

    private void updateEnablement() {
        this.fSessionAddressText.setEnabled(!this.fDefaultSessionAddressButton.getSelection());
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }
}

