/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.rdt.core.miners.PositionCollector;
import org.eclipse.ptp.internal.rdt.core.miners.SemanticHighlighting;

public class SemanticHighlightings {
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new MacroReferenceHighlighting(), new ProblemHighlighting(), new ExternalSDKHighlighting(), new ClassHighlighting(), new StaticFieldHighlighting(), new FieldHighlighting(), new MethodDeclarationHighlighting(), new StaticMethodInvocationHighlighting(), new ParameterVariableHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new GlobalVariableHighlighting(), new TemplateParameterHighlighting(), new OverloadedOperatorHighlighting(), new MethodHighlighting(), new EnumHighlighting(), new MacroDefinitionHighlighting(), new FunctionDeclarationHighlighting(), new FunctionHighlighting(), new TypedefHighlighting(), new NamespaceHighlighting(), new LabelHighlighting(), new EnumeratorHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    private SemanticHighlightings() {
    }

    private static final class ClassHighlighting
    extends SemanticHighlighting {
        private ClassHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            if (node instanceof ICPPASTQualifiedName || node instanceof ICPPASTTemplateId) {
                return false;
            }
            return node instanceof IASTName && (binding = token.getBinding()) instanceof ICPPClassType;
        }
    }

    private static final class EnumHighlighting
    extends SemanticHighlighting {
        private EnumHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            return node instanceof IASTName && (binding = token.getBinding()) instanceof IEnumeration;
        }
    }

    private static final class EnumeratorHighlighting
    extends SemanticHighlighting {
        private EnumeratorHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IEnumerator) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ExternalSDKHighlighting
    extends SemanticHighlighting {
        private ExternalSDKHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                if (name instanceof IASTImplicitName) {
                    return false;
                }
                if (name.isReference()) {
                    IBinding binding = token.getBinding();
                    IIndex index = token.getRoot().getIndex();
                    return this.isExternalSDKReference(binding, index);
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isExternalSDKReference(IBinding binding, IIndex index) {
            if (!(binding instanceof IFunction)) return false;
            try {
                IIndexName[] decls;
                if (binding instanceof IIndexBinding ? ((IIndexBinding)binding).isFileLocal() : !(binding instanceof ICExternalBinding)) {
                    return false;
                }
                IIndexName[] iIndexNameArray = decls = index.findNames(binding, 9);
                int n = decls.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        if (decls.length == 0) return false;
                        return true;
                    }
                    IIndexName decl = iIndexNameArray[n2];
                    IIndexFile indexFile = decl.getFile();
                    if (indexFile != null && indexFile.getLocation().getFullPath() != null) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
    }

    private static final class FieldHighlighting
    extends SemanticHighlighting {
        private FieldHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IField) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class FunctionDeclarationHighlighting
    extends SemanticHighlighting {
        private FunctionDeclarationHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isDeclaration()) {
                IBinding binding = token.getBinding();
                if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                    return true;
                }
                if (binding instanceof IProblemBinding) {
                    if (name instanceof ICPPASTQualifiedName) {
                        return false;
                    }
                    node = name.getParent();
                    while (node instanceof IASTName) {
                        node = node.getParent();
                    }
                    if (node instanceof IASTFunctionDeclarator) {
                        while (node != token.getRoot() && !(node.getParent() instanceof IASTDeclSpecifier)) {
                            node = node.getParent();
                        }
                        return !(node instanceof ICPPASTCompositeTypeSpecifier);
                    }
                }
            }
            return false;
        }
    }

    private static final class FunctionHighlighting
    extends SemanticHighlighting {
        private FunctionHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTImplicitName) {
                return false;
            }
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class GlobalVariableHighlighting
    extends SemanticHighlighting {
        private GlobalVariableHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (!(!(binding instanceof IVariable) || binding instanceof IField || binding instanceof IParameter || binding instanceof ICPPTemplateNonTypeParameter || binding instanceof IProblemBinding)) {
                    try {
                        IScope scope = binding.getScope();
                        if (!LocalVariableHighlighting.isLocalScope(scope)) {
                            return true;
                        }
                    }
                    catch (DOMException dOMException) {
                    }
                    catch (Error error) {}
                }
            }
            return false;
        }
    }

    private static final class LabelHighlighting
    extends SemanticHighlighting {
        private LabelHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof ILabel;
        }
    }

    private static final class LocalVariableDeclarationHighlighting
    extends SemanticHighlighting {
        private LocalVariableDeclarationHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding;
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isDeclaration() && (binding = token.getBinding()) instanceof IVariable && !(binding instanceof IField) && !(binding instanceof IParameter) && !(binding instanceof IProblemBinding)) {
                try {
                    IScope scope = binding.getScope();
                    if (LocalVariableHighlighting.isLocalScope(scope)) {
                        return true;
                    }
                }
                catch (DOMException dOMException) {
                }
                catch (Error error) {}
            }
            return false;
        }
    }

    private static final class LocalVariableHighlighting
    extends SemanticHighlighting {
        private LocalVariableHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding;
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isReference() && (binding = token.getBinding()) instanceof IVariable && !(binding instanceof IField) && !(binding instanceof IParameter) && !(binding instanceof IProblemBinding)) {
                try {
                    IScope scope = binding.getScope();
                    if (LocalVariableHighlighting.isLocalScope(scope)) {
                        return true;
                    }
                }
                catch (DOMException dOMException) {
                }
                catch (Error error) {}
            }
            return false;
        }

        public static boolean isLocalScope(IScope scope) {
            while (scope != null) {
                if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                    return true;
                }
                try {
                    scope = scope.getParent();
                }
                catch (DOMException dOMException) {
                    scope = null;
                }
            }
            return false;
        }
    }

    private static final class MacroDefinitionHighlighting
    extends SemanticHighlighting {
        private MacroDefinitionHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTName name;
            IBinding binding = token.getBinding();
            return binding instanceof IMacroBinding && !(name = (IASTName)token.getNode()).isReference();
        }
    }

    private static final class MacroReferenceHighlighting
    extends SemanticHighlighting {
        private MacroReferenceHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTName name;
            IBinding binding = token.getBinding();
            return binding instanceof IMacroBinding && (name = (IASTName)token.getNode()).isReference();
        }
    }

    private static final class MethodDeclarationHighlighting
    extends SemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean consumes(PositionCollector.SemanticToken token) {
            block7: {
                node = token.getNode();
                if (!(node instanceof IASTName) || (name = (IASTName)node).isReference()) break block7;
                binding = token.getBinding();
                if (binding instanceof ICPPMethod) {
                    return true;
                }
                if (!(binding instanceof IProblemBinding)) break block7;
                node = name.getParent();
                while (node instanceof IASTName) {
                    node = node.getParent();
                }
                if (!(node instanceof ICPPASTFunctionDeclarator)) break block7;
                if (!(name instanceof ICPPASTQualifiedName)) ** GOTO lbl18
                qName = (ICPPASTQualifiedName)name;
                names = qName.getNames();
                if (names.length <= 1 || !(names[names.length - 2].getBinding() instanceof ICPPClassType)) break block7;
                return true;
lbl-1000:
                // 1 sources

                {
                    node = node.getParent();
lbl18:
                    // 2 sources

                    ** while (node != token.getRoot() && !(node.getParent() instanceof IASTDeclSpecifier))
                }
lbl19:
                // 1 sources

                if (node instanceof ICPPASTCompositeTypeSpecifier) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class MethodHighlighting
    extends SemanticHighlighting {
        private MethodHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTImplicitName) {
                return false;
            }
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ICPPMethod) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class NamespaceHighlighting
    extends SemanticHighlighting {
        private NamespaceHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof ICPPNamespace;
        }
    }

    private static final class OverloadedOperatorHighlighting
    extends SemanticHighlighting {
        private OverloadedOperatorHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTImplicitName) {
                IASTImplicitName name = (IASTImplicitName)node;
                IBinding binding = name.resolveBinding();
                if (binding instanceof ICPPMethod && !(binding instanceof IProblemBinding) && ((ICPPMethod)binding).isImplicit()) {
                    return false;
                }
                char[] chars = name.toCharArray();
                return chars[0] != '~' && !OverloadableOperator.isNew((char[])chars) && !OverloadableOperator.isDelete((char[])chars);
            }
            return false;
        }
    }

    private static final class ParameterVariableHighlighting
    extends SemanticHighlighting {
        private ParameterVariableHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof IParameter;
        }
    }

    private static final class ProblemHighlighting
    extends SemanticHighlighting {
        private ProblemHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTProblem) {
                return true;
            }
            IBinding binding = token.getBinding();
            return binding instanceof IProblemBinding;
        }
    }

    private static final class StaticFieldHighlighting
    extends SemanticHighlighting {
        private StaticFieldHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IField && !(binding instanceof IProblemBinding)) {
                    try {
                        return ((IField)binding).isStatic();
                    }
                    catch (Error error) {}
                }
            }
            return false;
        }
    }

    private static final class StaticMethodInvocationHighlighting
    extends SemanticHighlighting {
        private StaticMethodInvocationHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                if (!name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ICPPMethod && !(binding instanceof IProblemBinding)) {
                    try {
                        return ((ICPPMethod)binding).isStatic();
                    }
                    catch (Error error) {}
                }
            }
            return false;
        }
    }

    private static final class TemplateParameterHighlighting
    extends SemanticHighlighting {
        private TemplateParameterHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            return node instanceof IASTName && (binding = token.getBinding()) instanceof ICPPTemplateParameter;
        }
    }

    private static final class TypedefHighlighting
    extends SemanticHighlighting {
        private TypedefHighlighting() {
        }

        public boolean consumes(PositionCollector.SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ITypedef) {
                    return true;
                }
            }
            return false;
        }
    }
}

