/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.eclipse.photran.internal.core.preprocessor.c.CPreprocessor;
import org.eclipse.photran.internal.core.preprocessor.c.IToken;
import org.eclipse.photran.internal.core.preprocessor.c.Lexer;

public class TokenTypeTranslator {
    private static HashMap<Integer, String> typeMap = null;

    public static String typeToString(int type) {
        String str;
        if (typeMap == null) {
            TokenTypeTranslator.initialize();
        }
        if ((str = typeMap.get(type)) == null) {
            return "unknown";
        }
        return str;
    }

    private static void initialize() {
        HashMap<Integer, String> newTypeMap = new HashMap<Integer, String>();
        TokenTypeTranslator.mapTypesFromClass(newTypeMap, IToken.class);
        TokenTypeTranslator.mapTypesFromClass(newTypeMap, Lexer.class);
        TokenTypeTranslator.mapTypesFromClass(newTypeMap, CPreprocessor.class);
        typeMap = newTypeMap;
    }

    private static void mapTypesFromClass(HashMap<Integer, String> typeMap, Class<?> myClass) {
        Field[] fields = myClass.getFields();
        int i = 0;
        while (i < fields.length) {
            try {
                String name;
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && (name = field.getName()).length() != 0 && name.charAt(0) == 't') {
                    typeMap.put(field.getInt(null), name);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++i;
        }
    }
}

