/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.etfw.AbstractToolDataManager;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.messages.Messages;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.etfw.toolopts.ExecTool;
import org.eclipse.ptp.etfw.toolopts.ExternalTool;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.IToolUITab;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.ptp.etfw.toolopts.ToolMaker;
import org.eclipse.ptp.etfw.ui.AbstractToolConfigurationTab;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.etfw";
    private static Activator plugin;
    private static ExternalToolProcess[] tools;
    private static ArrayList<IFileStore> workflowList;
    private static ArrayList<AbstractToolConfigurationTab> perfConfTabs;
    private static ArrayList<IToolUITab> toolUITabs;
    private static ArrayList<AbstractToolDataManager> perfConfManagers;

    static {
        tools = null;
        workflowList = null;
        perfConfTabs = null;
        toolUITabs = null;
        perfConfManagers = null;
    }

    public static ExternalToolProcess[] getTools() {
        return tools;
    }

    public static ExternalToolProcess getTool(String toolName) {
        int i = 0;
        while (i < tools.length) {
            if (Activator.tools[i].toolName.equals(toolName)) {
                return tools[i];
            }
            ++i;
        }
        return null;
    }

    public static ExternalToolProcess getTool(int dex) {
        if (dex < tools.length) {
            return tools[dex];
        }
        return null;
    }

    private static void insertPanes(IToolUITab[] panes, List<IToolUITab> paneList) {
        if (panes != null && panes.length > 0) {
            int k = 0;
            while (k < panes.length) {
                if (!panes[k].isVirtual()) {
                    paneList.add(panes[k]);
                }
                ++k;
            }
        }
    }

    private static void insertPanes(List<IToolUITab> panes, List<IToolUITab> paneList) {
        if (panes != null && panes.size() > 0) {
            int k = 0;
            while (k < panes.size()) {
                if (!panes.get(k).isVirtual()) {
                    paneList.add(panes.get(k));
                }
                ++k;
            }
        }
    }

    public static IToolUITab[] getToolPanes() {
        ArrayList<IToolUITab> paneList = new ArrayList<IToolUITab>();
        IToolUITab[] panes = null;
        if (tools.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < tools.length) {
            int j = 0;
            while (j < Activator.tools[i].externalTools.size()) {
                int k;
                ExternalTool t = (ExternalTool)Activator.tools[i].externalTools.get(j);
                if (t instanceof BuildTool) {
                    BuildTool bt = (BuildTool)t;
                    Activator.insertPanes(bt.getAllCompilerPanes(), paneList);
                } else if (t instanceof ExecTool) {
                    ExecTool et = (ExecTool)t;
                    k = 0;
                    while (k < et.execUtils.length) {
                        Activator.insertPanes((IToolUITab[])et.execUtils[k].toolPanes, paneList);
                        ++k;
                    }
                } else if (t instanceof PostProcTool) {
                    PostProcTool pt = (PostProcTool)t;
                    k = 0;
                    while (k < pt.analysisCommands.length) {
                        Activator.insertPanes((IToolUITab[])pt.analysisCommands[k].toolPanes, paneList);
                        ++k;
                    }
                }
                if (t.global != null) {
                    Activator.insertPanes((IToolUITab[])t.global.toolPanes, paneList);
                }
                ++j;
            }
            ++i;
        }
        ArrayList<IToolUITab> uitList = Activator.getToolUITabs();
        if (uitList != null && uitList.size() > 0) {
            int i2 = 0;
            while (i2 < uitList.size()) {
                paneList.add(uitList.get(i2));
                ++i2;
            }
        }
        panes = new IToolUITab[paneList.size()];
        paneList.toArray(panes);
        return panes;
    }

    private ArrayList<IFileStore> getInternalXMLWorkflows() {
        if (workflowList != null) {
            return workflowList;
        }
        workflowList = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.workflows");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            IFileStore ifs = null;
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    String plugspace = ext.getNamespaceIdentifier();
                    String aGetter = ce.getAttribute("XMLFile");
                    URI iuri = new URI(FileLocator.toFileURL((URL)Platform.getBundle((String)plugspace).getEntry(aGetter)).toString().replaceAll(" ", "%20"));
                    ifs = EFS.getLocalFileSystem().getStore(iuri);
                    workflowList.add(ifs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            ++iext;
        }
        return workflowList;
    }

    public void refreshTools() {
        IFileStore toolxml;
        IFileInfo finf;
        String epath;
        this.getInternalXMLWorkflows();
        ArrayList<ExternalToolProcess> theTools = new ArrayList<ExternalToolProcess>();
        IFileSystem loc = EFS.getLocalFileSystem();
        String fiList = this.getPreferenceStore().getString("tool_def_xml_location");
        String[] fiLocs = fiList.split(",,,");
        ArrayList<IFileStore> files = new ArrayList<IFileStore>();
        IFileStore fi = null;
        int i = 0;
        while (i < fiLocs.length) {
            try {
                fi = loc.getStore(new URI(fiLocs[i]));
            }
            catch (URISyntaxException uRISyntaxException) {
                fi = EFS.getLocalFileSystem().getStore((IPath)new Path(fiLocs[i]));
            }
            IFileInfo finf2 = fi.fetchInfo();
            if (finf2.exists() && !finf2.isDirectory()) {
                files.add(fi);
            }
            ++i;
        }
        if (files.size() == 0 && (epath = BuildLaunchUtils.checkLocalToolEnvPath("eclipse")) != null && (finf = (toolxml = loc.getStore((IPath)new Path(epath))).fetchInfo()).exists() && (finf = (toolxml = toolxml.getChild("tool.xml")).fetchInfo()).exists()) {
            files.add(toolxml);
            this.getPreferenceStore().setValue("tool_def_xml_location", toolxml.toURI().toString());
        }
        i = 0;
        while (i < workflowList.size()) {
            tools = ToolMaker.makeTools((IFileStore)workflowList.get(i));
            if (tools != null) {
                int j = 0;
                while (j < tools.length) {
                    theTools.add(tools[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < files.size()) {
            try {
                tools = ToolMaker.makeTools((IFileStore)((IFileStore)files.get(i)));
            }
            catch (Exception e) {
                tools = null;
                e.printStackTrace();
                System.out.println(String.valueOf(Messages.Activator_ProblemReading) + ((IFileStore)files.get(i)).toString());
            }
            if (tools != null) {
                int j = 0;
                while (j < tools.length) {
                    theTools.add(tools[j]);
                    ++j;
                }
            }
            tools = null;
            ++i;
        }
        tools = theTools.toArray(new ExternalToolProcess[theTools.size()]);
        i = 0;
        while (i < tools.length) {
            BuildLaunchUtils.verifyLocalEnvToolPath(tools[i]);
            ++i;
        }
    }

    public static ArrayList<AbstractToolConfigurationTab> getPerfTabs() {
        if (perfConfTabs != null) {
            return perfConfTabs;
        }
        perfConfTabs = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.configurationTabs");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractToolConfigurationTab aGetter = (AbstractToolConfigurationTab)((Object)ce.createExecutableExtension("class"));
                    perfConfTabs.add(aGetter);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            ++iext;
        }
        return perfConfTabs;
    }

    public static ArrayList<IToolUITab> getToolUITabs() {
        if (toolUITabs == null) {
            toolUITabs = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.toolUITabs");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iext = 0;
            while (iext < extensions.length) {
                IExtension ext = extensions[iext];
                IConfigurationElement[] elements = ext.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement ce = elements[i];
                    try {
                        IToolUITab aGetter = (IToolUITab)ce.createExecutableExtension("class");
                        toolUITabs.add(aGetter);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                ++iext;
            }
        }
        return toolUITabs;
    }

    private ArrayList<AbstractToolDataManager> getPerfConfManagers() {
        if (perfConfManagers != null) {
            return perfConfManagers;
        }
        perfConfManagers = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.dataManagers");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractToolDataManager aGetter = (AbstractToolDataManager)ce.createExecutableExtension("class");
                    perfConfManagers.add(aGetter);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            ++iext;
        }
        return perfConfManagers;
    }

    public static AbstractToolDataManager getPerfDataManager(String name) {
        if (name == null) {
            return null;
        }
        AbstractToolDataManager check2 = null;
        for (AbstractToolDataManager check2 : perfConfManagers) {
            if (!check2.getName().equals(name)) continue;
            return check2;
        }
        return null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.refreshTools();
        Activator.getPerfTabs();
        this.getPerfConfManagers();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

