/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.remote.rse.core.DStoreHostShell;
import org.eclipse.ptp.remote.rse.core.RSEAdapterCorePlugin;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.services.dstore.shells.DStoreShellService;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;

public class SpawnerSubsystem
extends SubSystem {
    private boolean fIsInitializing;

    protected SpawnerSubsystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
        this.setHidden(true);
    }

    public synchronized void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        boolean isFirstCall = false;
        if (!this.fIsInitializing) {
            this.fIsInitializing = true;
            isFirstCall = true;
        }
        try {
            super.initializeSubSystem(monitor);
            DataStore dataStore = this.getDataStore(monitor);
            DataElement status = dataStore.activateMiner("org.eclipse.ptp.internal.remote.rse.core.miners.SpawnerMiner");
            if (status != null) {
                DStoreStatusMonitor statusMonitor = new DStoreStatusMonitor(dataStore);
                try {
                    statusMonitor.waitForUpdate(status, monitor);
                }
                catch (InterruptedException e) {
                    RSEAdapterCorePlugin.log(e);
                }
            }
        }
        finally {
            if (isFirstCall) {
                this.fIsInitializing = false;
            }
        }
    }

    protected synchronized DataStore getDataStore(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            RSEAdapterCorePlugin.log(e);
            return null;
        }
        IConnectorService connectorService = this.getConnectorService();
        if (connectorService instanceof DStoreConnectorService) {
            DStoreConnectorService dstoreConnectorService = (DStoreConnectorService)connectorService;
            if (!this.fIsInitializing && !dstoreConnectorService.isConnected()) {
                try {
                    dstoreConnectorService.connect(monitor);
                }
                catch (Exception e) {
                    RSEAdapterCorePlugin.log(e);
                }
            }
            return dstoreConnectorService.getDataStore();
        }
        return null;
    }

    public synchronized Process spawnLocalRedirected(String cmd, String workingDirectory, String encoding, String[] envp, IProgressMonitor monitor) throws IOException {
        return null;
    }

    public synchronized IHostShell spawnRedirected(String cmd, String workingDirectory, String encoding, String[] envp, IProgressMonitor monitor) throws IOException {
        DataStore dataStore = this.getDataStore(monitor);
        if (dataStore != null) {
            monitor.beginTask("Launching command: " + cmd, 100);
            DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_SPAWN_REDIRECTED");
            if (queryCmd != null) {
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                DataElement dataElement = dataStore.createObject(null, "Type.Spawner.String", cmd);
                args.add(dataElement);
                dataElement = dataStore.createObject(null, "Type.Spawner.String", workingDirectory);
                args.add(dataElement);
                dataElement = dataStore.createObject(null, "Type.Spawner.String", new Integer(envp.length).toString());
                args.add(dataElement);
                String[] stringArray = envp;
                int n = envp.length;
                int n2 = 0;
                while (n2 < n) {
                    String envVar = stringArray[n2];
                    dataElement = dataStore.createObject(null, "Type.Spawner.String", envVar);
                    args.add(dataElement);
                    ++n2;
                }
                DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
                IShellService shellService = this.getShellServiceSubSystem().getShellService();
                if (shellService instanceof DStoreShellService) {
                    DStoreStatusMonitor statusMonitor = ((DStoreShellService)shellService).getStatusMonitor(dataStore);
                    return new DStoreHostShell(statusMonitor, status, dataStore, workingDirectory, cmd, encoding, envp, true);
                }
            }
        }
        return null;
    }

    public IShellServiceSubSystem getShellServiceSubSystem() {
        ISubSystem[] subsystems;
        ISubSystem[] iSubSystemArray = subsystems = this.getConnectorService().getSubSystems();
        int n = subsystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof IShellServiceSubSystem) {
                return (IShellServiceSubSystem)subsystem;
            }
            ++n2;
        }
        return null;
    }
}

