/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.rse.core.RSEConnectionManager;
import org.eclipse.ptp.remote.rse.ui.messages.Messages;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.widgets.Shell;

public class RSEUIConnectionManager
implements IRemoteUIConnectionManager {
    private SystemNewConnectionAction action;
    private final RSEConnectionManager manager;

    public RSEUIConnectionManager(IRemoteServices services) {
        this.manager = (RSEConnectionManager)services.getConnectionManager();
    }

    public IRemoteConnection newConnection(Shell shell) {
        IRemoteConnection[] oldConns = this.manager.getConnections();
        if (this.action == null) {
            this.action = new SystemNewConnectionAction(shell, false, false, null);
        }
        try {
            this.action.run();
        }
        catch (Exception exception) {}
        this.manager.refreshConnections();
        IRemoteConnection[] newConns = this.manager.getConnections();
        if (newConns.length <= oldConns.length) {
            return null;
        }
        Arrays.sort(oldConns, new Comparator<IRemoteConnection>(){

            @Override
            public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        Arrays.sort(newConns, new Comparator<IRemoteConnection>(){

            @Override
            public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        int i = 0;
        while (i < oldConns.length) {
            if (!oldConns[i].equals(newConns[i])) {
                return newConns[i];
            }
            ++i;
        }
        return newConns[newConns.length - 1];
    }

    public IRemoteConnection newConnection(Shell shell, String[] attrHints, String[] attrHintValues) {
        return this.newConnection(shell);
    }

    public void openConnectionWithProgress(final Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        if (!connection.isOpen()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        ErrorDialog.openError((Shell)shell, (String)Messages.RSEUIConnectionManager_0, (String)Messages.RSEUIConnectionManager_1, (IStatus)new Status(4, "org.eclipse.ptp.remote.rse.core.ui", e.getMessage()));
                    }
                }
            };
            try {
                if (context != null) {
                    context.run(true, true, op);
                } else {
                    new ProgressMonitorDialog(shell).run(true, true, op);
                }
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.RSEUIConnectionManager_0, (String)Messages.RSEUIConnectionManager_1, (IStatus)new Status(4, "org.eclipse.ptp.remote.rse.core.ui", e.getMessage()));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.RSEUIConnectionManager_0, (String)Messages.RSEUIConnectionManager_1, (IStatus)new Status(4, "org.eclipse.ptp.remote.rse.core.ui", e.getMessage()));
            }
        }
    }

    public void updateConnection(Shell shell, IRemoteConnection connection) {
    }
}

