/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.control;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.core.IAuthInfo;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetConfig;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSHTargetControl
implements ITargetControl {
    private IRemoteConnection remoteConnection = null;
    private CoreException pendingException = null;
    private ITargetConfig fConfig = null;
    private IAuthInfo fAuthInfo = null;
    private final String USE_LOGIN_SHELL_ATTR = "org.eclipse.ptp.remotetools.environment.generichost.use-login-shell";

    public static Map<String, String> getCipherTypesMap() {
        HashMap<String, String> cipherTypesMap = new HashMap<String, String>(RemotetoolsPlugin.getCipherTypesMap());
        return cipherTypesMap;
    }

    @Override
    public boolean create(IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)this.fAuthInfo, (String)"missing ssh parameters");
        try {
            if (monitor.isCanceled()) {
                this.disconnect();
                throw new CoreException((IStatus)new Status(8, EnvironmentPlugin.getUniqueIdentifier(), 0, Messages.SSHTargetControl_1, null));
            }
            this.kill();
            this.connect(monitor);
            if (monitor.isCanceled()) {
                this.disconnect();
                throw new CoreException((IStatus)new Status(8, EnvironmentPlugin.getUniqueIdentifier(), 0, Messages.SSHTargetControl_1, null));
            }
            return true;
        }
        catch (RemoteConnectionException e) {
            this.disconnect();
            String message = e.getMessage();
            Throwable t = e.getCause();
            if (t != null) {
                message = String.valueOf(message) + ": " + t.getMessage();
            }
            throw new CoreException((IStatus)new Status(4, EnvironmentPlugin.getUniqueIdentifier(), message));
        }
    }

    @Override
    public ITargetControl.TargetSocket createTargetSocket(int port) throws CoreException {
        ITargetControl.TargetSocket test = new ITargetControl.TargetSocket();
        test.host = "localhost";
        test.port = port;
        return test;
    }

    public boolean executeRemoteCommand(IProgressMonitor monitor, String command, String[] args) throws CoreException {
        if (this.remoteConnection == null) {
            throw new CoreException((IStatus)new Status(4, EnvironmentPlugin.getUniqueIdentifier(), Messages.SSHTargetControl_5, null));
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            command = String.valueOf(command) + " " + arg;
            ++n2;
        }
        try {
            IRemoteExecutionManager executionManager = this.remoteConnection.createRemoteExecutionManager();
            executionManager.getExecutionTools().executeWithExitValue(command);
            executionManager.close();
            return true;
        }
        catch (RemoteConnectionException e) {
            throw new CoreException((IStatus)new Status(4, EnvironmentPlugin.getUniqueIdentifier(), 0, Messages.SSHTargetControl_2, (Throwable)e));
        }
        catch (CancelException e) {
            throw new CoreException((IStatus)new Status(4, EnvironmentPlugin.getUniqueIdentifier(), 0, Messages.SSHTargetControl_3, (Throwable)e));
        }
        catch (RemoteExecutionException e) {
            throw new CoreException((IStatus)new Status(4, EnvironmentPlugin.getUniqueIdentifier(), 0, Messages.SSHTargetControl_4, (Throwable)e));
        }
    }

    public IRemoteConnection getConnection() {
        Assert.isTrue((boolean)false, (String)"this method is not supported");
        return this.remoteConnection;
    }

    @Override
    public void kill() throws CoreException {
        this.disconnect();
    }

    protected synchronized void connect(IProgressMonitor monitor) throws RemoteConnectionException {
        Assert.isNotNull((Object)this.fAuthInfo, (String)"missing ssh parameters");
        if (this.remoteConnection == null) {
            this.remoteConnection = RemotetoolsPlugin.createSSHConnection();
        }
        try {
            String cipherType = "";
            if (this.fConfig.getCipherType() != null) {
                cipherType = this.fConfig.getCipherType();
            }
            if (this.fConfig.getAttributes().getBoolean("org.eclipse.ptp.remotetools.environment.generichost.use-login-shell")) {
                cipherType = String.valueOf(cipherType) + "+true";
            }
            this.remoteConnection.connect(this.fAuthInfo, this.fConfig.getConnectionAddress(), this.fConfig.getConnectionPort(), cipherType, this.fConfig.getConnectionTimeout() * 1000, monitor);
        }
        catch (RemoteConnectionException e) {
            this.disconnect();
            throw e;
        }
    }

    protected IRemoteExecutionManager createRemoteExecutionManager() throws RemoteConnectionException {
        return this.remoteConnection.createRemoteExecutionManager();
    }

    protected synchronized void disconnect() {
        if (this.remoteConnection != null) {
            this.remoteConnection.disconnect();
        }
    }

    protected boolean isConnected() {
        return this.remoteConnection != null && this.remoteConnection.isConnected();
    }

    protected synchronized void notifyException(CoreException e) {
        this.pendingException = e;
    }

    protected synchronized void setConnectionParameters(ITargetConfig config, IAuthInfo authInfo) {
        this.fConfig = config;
        this.fAuthInfo = authInfo;
    }

    protected synchronized void throwPendingException() throws CoreException {
        if (this.pendingException != null) {
            throw this.pendingException;
        }
    }
}

