/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.ui.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorChangedListener;
import org.eclipse.ptp.rm.lml.monitor.ui.ExtensionUtils;
import org.eclipse.ptp.rm.lml.monitor.ui.MonitorImages;
import org.eclipse.ptp.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class MonitorView
extends ViewPart {
    private TableViewer fViewer;
    private final TableColumnLayout fTableColumnLayout = new TableColumnLayout();
    private final MonitorChangedListener fMonitorChangedListener = new MonitorChangedListener();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.fTableColumnLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fViewer = new TableViewer(composite, 65540);
        this.fViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fViewer.setComparator((ViewerComparator)new SystemsViewSorter());
        this.fViewer.setUseHashlookup(true);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MonitorControlManager.getInstance().fireSelectionChanged(event);
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(final DoubleClickEvent event) {
                UIJob job = new UIJob(Messages.MonitorView_Start_Stop_Monitor){

                    public IStatus runInUIThread(IProgressMonitor progress) {
                        IStructuredSelection sel;
                        if (event.getSelection() instanceof IStructuredSelection && !(sel = (IStructuredSelection)event.getSelection()).isEmpty()) {
                            IMonitorControl monitor = (IMonitorControl)sel.getFirstElement();
                            try {
                                if (!monitor.isActive()) {
                                    monitor.start(progress);
                                } else {
                                    monitor.stop();
                                }
                            }
                            catch (CoreException e) {
                                return e.getStatus();
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        this.createColumns();
        this.fViewer.setInput((Object)MonitorControlManager.getInstance().getMonitorControls());
        this.fViewer.getTable().setLinesVisible(true);
        this.fViewer.getTable().setHeaderVisible(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        MonitorControlManager.getInstance().addMonitorChangedListener((IMonitorChangedListener)this.fMonitorChangedListener);
    }

    public void dispose() {
        MonitorControlManager.getInstance().removeMonitorChangedListener((IMonitorChangedListener)this.fMonitorChangedListener);
        super.dispose();
    }

    private void createColumns() {
        String[] columnTitles = new String[]{"Status", "Connection Name", "System Type"};
        int i = 0;
        while (i < columnTitles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fViewer, 0);
            final int cellNumber = i;
            switch (cellNumber) {
                case 0: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CenterImageLabelProvider(){

                        public Image getImage(Object element) {
                            IMonitorControl monitor = (IMonitorControl)element;
                            return monitor.isActive() ? MonitorImages.get(MonitorImages.IMG_STARTED) : null;
                        }
                    });
                    break;
                }
                case 1: 
                case 2: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            IMonitorControl monitor = (IMonitorControl)element;
                            switch (cellNumber) {
                                case 1: {
                                    return monitor.getConnectionName();
                                }
                                case 2: {
                                    return ExtensionUtils.getMonitorName(monitor.getSystemType());
                                }
                            }
                            return null;
                        }
                    });
                }
            }
            tableViewerColumn.getColumn().setText(columnTitles[i]);
            tableViewerColumn.getColumn().pack();
            int width = tableViewerColumn.getColumn().getWidth();
            this.fTableColumnLayout.setColumnData((Widget)tableViewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(i > 0 ? 100 : 0, width));
            ++i;
        }
    }

    public void setFocus() {
    }

    private abstract class CenterImageLabelProvider
    extends OwnerDrawLabelProvider {
        private CenterImageLabelProvider() {
        }

        protected void measure(Event event, Object element) {
        }

        protected void paint(Event event, Object element) {
            Image img = this.getImage(element);
            if (img != null) {
                Rectangle bounds = ((TableItem)event.item).getBounds(event.index);
                Rectangle imgBounds = img.getBounds();
                bounds.width /= 2;
                bounds.width -= imgBounds.width / 2;
                bounds.height /= 2;
                bounds.height -= imgBounds.height / 2;
                int x = bounds.width > 0 ? bounds.x + bounds.width : bounds.x;
                int y = bounds.height > 0 ? bounds.y + bounds.height : bounds.y;
                event.gc.drawImage(img, x, y);
            }
        }

        protected abstract Image getImage(Object var1);
    }

    private class MonitorChangedListener
    implements IMonitorChangedListener {
        private MonitorChangedListener() {
        }

        public void monitorAdded(IMonitorControl[] monitors) {
            MonitorView.this.fViewer.refresh();
        }

        public void monitorRemoved(IMonitorControl[] monitors) {
            MonitorView.this.fViewer.refresh();
        }

        public void monitorUpdated(IMonitorControl[] monitors) {
            MonitorView.this.fViewer.refresh();
        }
    }

    private class SystemsViewSorter
    extends ViewerComparator {
        private SystemsViewSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name1 = null;
            String name2 = null;
            if (e1 instanceof IMonitorControl) {
                name1 = ExtensionUtils.getMonitorName(((IMonitorControl)e1).getSystemType());
            }
            if (e2 instanceof IMonitorControl) {
                name2 = ExtensionUtils.getMonitorName(((IMonitorControl)e2).getSystemType());
            }
            if (name1 != null && name2 != null) {
                int res = name1.compareTo(name2);
                if (res == 0) {
                    res = ((IMonitorControl)e1).getConnectionName().compareTo(((IMonitorControl)e2).getConnectionName());
                }
                return res;
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

