/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolResourceManager;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2LaunchAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2MachineAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.launch.MPICH2LaunchConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.launch.MPICH2LaunchConfigurationDefaults;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.EffectiveMPICH2ResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.MPICH2ResourceManager;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.MPICH2ResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2DiscoverJob;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2PeriodicJob;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystemJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICH2RuntimeSystem
extends AbstractToolRuntimeSystem {
    private String machineID;
    private final Map<String, String> nodeNameToIDMap = new HashMap<String, String>();

    public MPICH2RuntimeSystem(MPICH2ResourceManager rm) {
        super((AbstractToolResourceManager)rm);
    }

    public Job createRuntimeSystemJob(String jobID, AttributeManager attrMgr) {
        return new MPICH2RuntimeSystemJob(jobID, Messages.MPICH2RuntimeSystem_JobName, this, attrMgr);
    }

    public List<IAttribute<?, ?, ?>> getAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        List attrs = super.getAttributes(configuration, mode);
        IPResourceManager rm = this.getPResourceManager();
        if (rm != null) {
            IPQueue[] queues = rm.getQueues();
            if (queues.length != 1) {
                throw new CoreException((IStatus)new Status(4, MPICH2Plugin.getUniqueIdentifier(), Messages.MPICH2RuntimeSystem_NoDefaultQueue));
            }
            attrs.add(JobAttributes.getQueueIdAttributeDefinition().create(queues[0].getID()));
        }
        int numProcs = configuration.getAttribute(MPICH2LaunchConfiguration.ATTR_NUMPROCS, MPICH2LaunchConfigurationDefaults.ATTR_NUMPROCS);
        try {
            attrs.add(JobAttributes.getNumberOfProcessesAttributeDefinition().create(Integer.valueOf(numProcs)));
        }
        catch (IllegalValueException e) {
            throw new CoreException((IStatus)new Status(4, MPICH2Plugin.getUniqueIdentifier(), Messages.MPICH2RuntimeSystem_InvalidConfiguration, (Throwable)e));
        }
        attrs.add(MPICH2LaunchAttributes.getLaunchArgumentsAttributeDefinition().create(MPICH2LaunchConfiguration.calculateArguments(configuration)));
        return attrs;
    }

    public String getNodeIDforName(String hostname) {
        return this.nodeNameToIDMap.get(hostname);
    }

    public AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration() {
        return new EffectiveMPICH2ResourceManagerConfiguration(this.getRmConfiguration());
    }

    public void setNodeIDForName(String hostname, String nodeID) {
        this.nodeNameToIDMap.put(hostname, nodeID);
    }

    private MPICH2ResourceManagerConfiguration getConfiguration() {
        return (MPICH2ResourceManagerConfiguration)this.getResourceManager().getConfiguration();
    }

    protected Job createContinuousMonitorJob() {
        return null;
    }

    protected Job createDiscoverJob() {
        if (!this.getConfiguration().hasDiscoverCmd()) {
            return null;
        }
        MPICH2DiscoverJob job = new MPICH2DiscoverJob(this);
        job.setPriority(10);
        job.setSystem(false);
        job.setUser(false);
        return job;
    }

    protected Job createPeriodicMonitorJob() {
        if (!this.getConfiguration().hasPeriodicMonitorCmd()) {
            return null;
        }
        MPICH2PeriodicJob job = new MPICH2PeriodicJob(this);
        job.setPriority(10);
        job.setSystem(false);
        job.setUser(false);
        return job;
    }

    protected void doFilterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
    }

    protected void doShutdown() throws CoreException {
    }

    protected void doStartEvents() throws CoreException {
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        this.machineID = this.createMachine(this.getResourceManager().getName());
        this.createQueue(Messages.MPICH2DiscoverJob_defaultQueueName);
    }

    protected void doStopEvents() throws CoreException {
    }

    protected String getMachineId() {
        return this.machineID;
    }

    protected void notifyMonitorFailed(AbstractRemoteCommandJob job, Exception exception) {
        AttributeManager attrManager = new AttributeManager();
        attrManager.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.ERROR));
        attrManager.addAttribute((IAttribute)MPICH2MachineAttributes.getStatusMessageAttributeDefinition().create(NLS.bind((String)Messages.MPICH2MonitorJob_Exception_InternalError, (Object)exception.getMessage())));
        this.changeMachine(this.machineID, attrManager);
    }
}

