/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPINodeAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.parameters.OmpiInfo;
import org.eclipse.ptp.rm.mpi.openmpi.core.parameters.Parameters;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIHostMap;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIHostMapParser;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIRuntimeSystem;

public class OpenMPIDiscoverJob
extends AbstractRemoteCommandJob {
    OpenMPIRuntimeSystem rts;

    public OpenMPIDiscoverJob(OpenMPIRuntimeSystem rts) {
        super((AbstractToolRuntimeSystem)rts, NLS.bind((String)Messages.OpenMPIDiscoverJob_name, (Object)rts.getRmConfiguration().getName()), rts.retrieveEffectiveToolRmConfiguration().getDiscoverCmd(), Messages.OpenMPIDiscoverJob_interruptedErrorMessage, Messages.OpenMPIDiscoverJob_processErrorMessage, Messages.OpenMPIDiscoverJob_parsingErrorMessage);
        this.rts = rts;
    }

    protected void parse(BufferedReader output) throws CoreException {
        OpenMPIHostMap hostMap;
        IRemoteConnection connection = this.rts.getConnection();
        assert (connection != null);
        IRemoteServices remoteServices = this.rts.getRemoteServices();
        assert (remoteServices != null);
        IRemoteFileManager fileMgr = remoteServices.getFileManager(connection);
        OmpiInfo info = this.rts.getOmpiInfo();
        IOpenMPIResourceManagerConfiguration rmConfiguration = (IOpenMPIResourceManagerConfiguration)this.rts.getRmConfiguration();
        assert (fileMgr != null);
        IPResourceManager rm = this.rts.getPResourceManager();
        IPMachine machine = rm.getMachineById(this.rts.getMachineID());
        assert (machine != null);
        this.parseOmpiInfo(output, info);
        String version = info.get("ompi:version:full");
        if (version != null) {
            if (!rmConfiguration.setDetectedVersion(version)) {
                throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OpenMPIDiscoverJob_Exception_InvalidVersion, (Object)version)));
            }
        } else {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), Messages.OpenMPIDiscoverJob_Exception_UnableToDetermineVersion));
        }
        try {
            hostMap = this.readHostFile(connection, remoteServices, fileMgr, info, rmConfiguration);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), e.getLocalizedMessage()));
        }
        int rankCounter = 0;
        boolean hasSomeError = false;
        assert (hostMap != null);
        OpenMPIHostMap.Host[] hostArray = hostMap.getHosts();
        int n = hostArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeManager attrManager;
            String nodeId;
            OpenMPIHostMap.Host host;
            block25: {
                block24: {
                    host = hostArray[n2];
                    nodeId = this.rts.createNode(machine.getID(), host.getName(), rankCounter++);
                    this.rts.setNodeIDForName(host.getName(), nodeId);
                    attrManager = new AttributeManager();
                    if (host.getNumProcessors() != 0) {
                        try {
                            attrManager.addAttribute((IAttribute)OpenMPINodeAttributes.getNumberOfNodesAttributeDefinition().create(Integer.valueOf(host.getNumProcessors())));
                        }
                        catch (IllegalValueException illegalValueException) {
                            if ($assertionsDisabled) break block24;
                            throw new AssertionError();
                        }
                    }
                }
                if (host.getMaxNumProcessors() != 0) {
                    try {
                        attrManager.addAttribute((IAttribute)OpenMPINodeAttributes.getMaximalNumberOfNodesAttributeDefinition().create(Integer.valueOf(host.getMaxNumProcessors())));
                    }
                    catch (IllegalValueException illegalValueException) {
                        if ($assertionsDisabled) break block25;
                        throw new AssertionError();
                    }
                }
            }
            if (host.getErrors() != 0) {
                if ((host.getErrors() & 4) != 0) {
                    attrManager.addAttribute((IAttribute)OpenMPINodeAttributes.getStatusMessageAttributeDefinition().create(Messages.OpenMPIDiscoverJob_Exception_InvalidMaxSlotsParameter));
                } else if ((host.getErrors() & 2) != 0) {
                    attrManager.addAttribute((IAttribute)OpenMPINodeAttributes.getStatusMessageAttributeDefinition().create(Messages.OpenMPIDiscoverJob_Exception_InvalidSlotsParameter));
                } else if ((host.getErrors() & 8) != 0) {
                    attrManager.addAttribute((IAttribute)OpenMPINodeAttributes.getStatusMessageAttributeDefinition().create(Messages.OpenMPIDiscoverJob_Exception_IgnoredInvalidParameter));
                }
                attrManager.addAttribute((IAttribute)NodeAttributes.getStateAttributeDefinition().create((Enum)NodeAttributes.State.UP));
                hasSomeError = true;
            }
            this.rts.changeNode(nodeId, attrManager);
            ++n2;
        }
        if (hostMap.hasParseErrors() || hasSomeError) {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getDefault().getBundle().getSymbolicName(), Messages.OpenMPIDiscoverJob_Exception_HostFileParseError));
        }
    }

    private OpenMPIHostMap readHostFile(IRemoteConnection connection, IRemoteServices remoteServices, IRemoteFileManager fileMgr, OmpiInfo info, IOpenMPIResourceManagerConfiguration rmConfiguration) throws CoreException, IOException {
        OpenMPIHostMap hostMap = null;
        String hostFileName = null;
        Path hostFilePath = null;
        Parameters.Parameter rds_param = info.getParameter("rds_hostfile_path");
        Parameters.Parameter orte_param = info.getParameter("orte_default_hostfile");
        String prefix = info.get("path:prefix");
        DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"rds_hostfile_path: {0}", (Object[])new Object[]{rds_param == null ? "null" : rds_param.getValue()});
        DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"orte_default_hostfile: {0}", (Object[])new Object[]{orte_param == null ? "null" : orte_param.getValue()});
        DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"prefix: {0}", (Object[])new Object[]{prefix == null ? "null" : prefix});
        if (rds_param != null && (hostFileName = rds_param.getValue()).trim().length() != 0) {
            hostFilePath = new Path(hostFileName);
        }
        if (hostFilePath == null && orte_param != null && (hostFileName = orte_param.getValue()).trim().length() != 0) {
            hostFilePath = new Path(hostFileName);
        }
        if (hostFilePath == null) {
            if (rmConfiguration.getDetectedVersion().equals("1.2")) {
                DebugUtil.error((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Missing mandatory hostfile for Open MPI 1.2.");
                throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), Messages.OpenMPIDiscoverJob_Exception_DiscoverCommandMissingHostFilePath));
            }
            hostMap = new OpenMPIHostMap();
            String hostname = this.getRemoteHostname(connection, remoteServices);
            hostMap.addDefaultHost(hostname);
            DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Missing optional hostfile. Assuming {0} as default host.", (Object[])new Object[]{hostname});
            return hostMap;
        }
        DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Found hostfile for Open MPI");
        DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"hostFilePath: {0}", (Object[])new Object[]{hostFilePath});
        if (!hostFilePath.isAbsolute()) {
            if (rmConfiguration.getDetectedVersion().equals("1.2")) {
                throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OpenMPIDiscoverJob_Exception_DiscoverCommandHostFilePathNotAbsolute, (Object)hostFilePath)));
            }
            hostMap = new OpenMPIHostMap();
            String hostname = this.getRemoteHostname(connection, remoteServices);
            hostMap.addDefaultHost(hostname);
            DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Bad hostfile specification. Assuming {0} as default host.", (Object[])new Object[]{hostname});
            return hostMap;
        }
        DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Opening hostfile.");
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFileStore hostFile = fileMgr.getResource(hostFilePath.toString());
        InputStream is = null;
        try {
            is = hostFile.openInputStream(0, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OpenMPIDiscoverJob_Exception_DiscoverCommandFailedReadHostFile, (Object)hostFileName), (Throwable)e));
        }
        DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Parsing hostfile.");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            hostMap = OpenMPIHostMapParser.parse(reader);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OpenMPIDiscoverJob_Exception_DiscoverCommandFailedParseHostFile, (Object)hostFileName), (Throwable)e));
        }
        if (hostMap.count() == 0) {
            if (rmConfiguration.getDetectedVersion().equals("1.2")) {
                String hostname = this.getRemoteHostname(connection, remoteServices);
                hostMap.addDefaultHost(hostname);
                DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Hostfile is empty. Added default host {0} for Open MPI 1.2.", (Object[])new Object[]{hostname});
            } else {
                DebugUtil.error((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Empty hostfile is not allowed.");
                throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OpenMPIDiscoverJob_Exception_DiscoverCommandHostFileEmpty, (Object)hostFileName)));
            }
        }
        return hostMap;
    }

    private String getRemoteHostname(IRemoteConnection connection, IRemoteServices remoteServices) throws CoreException, IOException {
        String string;
        IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, new String[]{"hostname"});
        IRemoteProcess process = null;
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), Messages.OpenMPIDiscoverJob_Exception_HostnameCommandFailed, (Throwable)e));
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            if (process.exitValue() != 0) {
                throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OpenMPIDiscoverJob_Exception_HostnameCommandFailedWithCode, (Object)process.exitValue())));
            }
            String hostname = br.readLine();
            if (hostname == null) {
                throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), Messages.OpenMPIDiscoverJob_Exception_HostnameCommandFailedParse));
            }
            string = hostname;
        }
        catch (Throwable throwable) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            br.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    private void parseOmpiInfo(BufferedReader output, OmpiInfo info) throws CoreException {
        try {
            String line;
            while ((line = output.readLine()) != null) {
                if (line.indexOf("mca:") == 0) {
                    int pos2;
                    int pos;
                    int nameStart = line.indexOf(":param:");
                    if (nameStart < 0 || (pos = line.indexOf(":", nameStart += 7)) < 0) continue;
                    String name = line.substring(nameStart, pos);
                    Parameters.Parameter param = info.getParameter(name);
                    if (param == null) {
                        param = info.addParameter(name);
                    }
                    if ((pos2 = line.indexOf(":value:", pos)) >= 0) {
                        param.setValue(line.substring(pos2 + 7));
                        continue;
                    }
                    pos2 = line.indexOf(":status:", pos);
                    if (pos2 >= 0) {
                        if (!line.substring(pos2 + 8).equals("read-only")) continue;
                        param.setReadOnly(true);
                        continue;
                    }
                    pos2 = line.indexOf(":help:", pos);
                    if (pos2 < 0) continue;
                    param.setHelp(line.substring(pos2 + 6));
                    continue;
                }
                int valStart = line.lastIndexOf(":");
                if (valStart < 0) continue;
                info.add(line.substring(0, valStart), line.substring(valStart + 1));
            }
            if (DebugUtil.RTS_DISCOVER_TRACING) {
                System.out.println("Open MPI parameters:");
                Parameters.Parameter[] parameterArray = info.getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameters.Parameter param = parameterArray[n2];
                    System.out.println(NLS.bind((String)"  {0}={1}", (Object)param.getName(), (Object)param.getValue()));
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getDefault().getBundle().getSymbolicName(), e.getMessage(), null));
        }
    }
}

