/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.ui.rmLaunchConfiguration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.IntegerAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.slurm.core.SLURMJobAttributes;
import org.eclipse.ptp.rm.slurm.core.SLURMLaunchConfiguration;
import org.eclipse.ptp.rm.slurm.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SLURMRMLaunchConfigurationDynamicTab
extends AbstractRMLaunchConfigurationDynamicTab {
    private Text nProcsText;
    private String nProcsString = "1";
    private static final String JOB_NUMBER_OF_PROCESSES_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_nprocs;
    private Text nNodesText;
    private String nNodesString = "1";
    private static final String JOB_NUMBER_OF_NODES_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_nnodes;
    private Text tLimitText;
    private String tLimitString = "5";
    private static final String JOB_TIME_LIMIT_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_tlimit;
    private Text partText;
    private String partString = "";
    private static final String JOB_PARTITION_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_partition;
    private Text reqNodeListText;
    private String reqNodeListString = "";
    private static final String JOB_REQUESTED_NODELIST_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_reqlist;
    private Text excNodeListText;
    private String excNodeListString = "";
    private static final String JOB_EXCLUDED_NODELIST_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_exclist;
    private static final RMLaunchValidation success = new RMLaunchValidation(true, "");
    private Composite control;

    public RMLaunchValidation canSave(Control control) {
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getJobNumProcsAttrDef();
            new IntegerAttribute(numProcsAttrDef, this.nProcsString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobNumNodesAttrDef = this.getJobNumNodesAttrDef();
            new IntegerAttribute(jobNumNodesAttrDef, this.nNodesString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_NODES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef();
            new IntegerAttribute(jobTimeLimitAttrDef, this.tLimitString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        StringAttributeDefinition jobPartitionAttrDef = this.getJobPartitionAttrDef();
        new StringAttribute(jobPartitionAttrDef, this.partString);
        StringAttributeDefinition jobReqNodeListAttrDef = this.getJobReqNodeListAttrDef();
        new StringAttribute(jobReqNodeListAttrDef, this.reqNodeListString);
        StringAttributeDefinition jobExcNodeListAttrDef = this.getJobExcNodeListAttrDef();
        new StringAttribute(jobExcNodeListAttrDef, this.excNodeListString);
        return new RMLaunchValidation(true, "");
    }

    public void createControl(Composite parent, String id) throws CoreException {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(this.control, 2048);
        GridLayout launchConfigLayout = new GridLayout(2, true);
        launchConfigLayout.marginHeight = 0;
        launchConfigLayout.marginWidth = 0;
        launchConfigLayout.numColumns = 2;
        comp.setLayout((Layout)launchConfigLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Label nProcsLabel = new Label(comp, 0);
        nProcsLabel.setText(JOB_NUMBER_OF_PROCESSES_LABEL);
        GridData gd_nProcsLabel = new GridData(4, 4, true, false, 1, 1);
        gd_nProcsLabel.minimumWidth = nProcsLabel.computeSize((int)-1, (int)-1).x;
        nProcsLabel.setLayoutData((Object)gd_nProcsLabel);
        this.nProcsText = new Text(comp, 2112);
        this.nProcsText.setTextLimit(20);
        this.nProcsText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_nprocs_tip);
        GridData gd_nProcsText = new GridData(4, 4, true, false, 1, 1);
        this.nProcsText.setLayoutData((Object)gd_nProcsText);
        this.nProcsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.nProcsString = SLURMRMLaunchConfigurationDynamicTab.this.nProcsText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
        Label nNodesLabel = new Label(comp, 0);
        nNodesLabel.setText(JOB_NUMBER_OF_NODES_LABEL);
        GridData gd_nNodesLabel = new GridData(4, 4, true, false, 1, 1);
        gd_nNodesLabel.minimumWidth = nNodesLabel.computeSize((int)-1, (int)-1).x;
        nNodesLabel.setLayoutData((Object)gd_nNodesLabel);
        this.nNodesText = new Text(comp, 2112);
        this.nNodesText.setTextLimit(20);
        this.nNodesText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_nnodes_tip);
        GridData gd_nNodesText = new GridData(4, 0x1000000, true, false, 1, 1);
        this.nNodesText.setLayoutData((Object)gd_nNodesText);
        this.nNodesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.nNodesString = SLURMRMLaunchConfigurationDynamicTab.this.nNodesText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
        Label tLimitLabel = new Label(comp, 0);
        tLimitLabel.setText(JOB_TIME_LIMIT_LABEL);
        GridData gd_tLimitLabel = new GridData(4, 4, true, false, 1, 1);
        gd_tLimitLabel.minimumWidth = tLimitLabel.computeSize((int)-1, (int)-1).x;
        tLimitLabel.setLayoutData((Object)gd_tLimitLabel);
        this.tLimitText = new Text(comp, 2112);
        this.tLimitText.setTextLimit(10);
        this.tLimitText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_tlimit_tip);
        GridData gd_tLimitText = new GridData(4, 0x1000000, true, false, 1, 1);
        this.tLimitText.setLayoutData((Object)gd_tLimitText);
        this.tLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.tLimitString = SLURMRMLaunchConfigurationDynamicTab.this.tLimitText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
        Label partLabel = new Label(comp, 0);
        partLabel.setText(JOB_PARTITION_LABEL);
        GridData gd_partLabel = new GridData(4, 4, true, false, 1, 1);
        gd_partLabel.minimumWidth = partLabel.computeSize((int)-1, (int)-1).x;
        partLabel.setLayoutData((Object)gd_partLabel);
        this.partText = new Text(comp, 2112);
        this.partText.setTextLimit(20);
        this.partText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_partition_tip);
        GridData gd_partText = new GridData(4, 0x1000000, true, false, 1, 1);
        this.partText.setLayoutData((Object)gd_partText);
        this.partText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.partString = SLURMRMLaunchConfigurationDynamicTab.this.partText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
        Label reqNodeListLabel = new Label(comp, 0);
        reqNodeListLabel.setText(JOB_REQUESTED_NODELIST_LABEL);
        GridData gd_reqNodeListLabel = new GridData(4, 4, true, false, 1, 1);
        gd_reqNodeListLabel.minimumWidth = reqNodeListLabel.computeSize((int)-1, (int)-1).x;
        reqNodeListLabel.setLayoutData((Object)gd_reqNodeListLabel);
        this.reqNodeListText = new Text(comp, 2112);
        this.reqNodeListText.setTextLimit(200);
        this.reqNodeListText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_reqlist_tip);
        GridData gd_reqNodeListText = new GridData(4, 0x1000000, true, false, 1, 1);
        this.reqNodeListText.setLayoutData((Object)gd_reqNodeListText);
        this.reqNodeListText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.reqNodeListString = SLURMRMLaunchConfigurationDynamicTab.this.reqNodeListText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
        Label excNodeListLabel = new Label(comp, 0);
        excNodeListLabel.setText(JOB_EXCLUDED_NODELIST_LABEL);
        GridData gd_excNodeListLabel = new GridData(4, 4, true, false, 1, 1);
        gd_excNodeListLabel.minimumWidth = excNodeListLabel.computeSize((int)-1, (int)-1).x;
        excNodeListLabel.setLayoutData((Object)gd_excNodeListLabel);
        this.excNodeListText = new Text(comp, 2112);
        this.excNodeListText.setTextLimit(200);
        this.excNodeListText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_exclist_tip);
        GridData gd_excNodeListText = new GridData(4, 0x1000000, true, false, 1, 1);
        this.excNodeListText.setLayoutData((Object)gd_excNodeListText);
        this.excNodeListText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.excNodeListString = SLURMRMLaunchConfigurationDynamicTab.this.excNodeListText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    public RMLaunchValidation initializeFrom(ILaunchConfiguration configuration) {
        String jobExcNodeList;
        String jobReqNodeList;
        String jobPartition;
        int jobTimeLimit;
        int jobNumNodes;
        int jobnumProcs;
        try {
            jobnumProcs = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_NUMPROCS, 1);
        }
        catch (CoreException e) {
            try {
                IntegerAttributeDefinition nProcsAttrDef = this.getJobNumProcsAttrDef();
                this.nProcsText.setText(nProcsAttrDef.create().getValueAsString());
            }
            catch (IllegalValueException e1) {
                return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_PROCESSES_LABEL) + e.getMessage() + " : " + e1.getMessage());
            }
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        this.nProcsText.setText(Integer.toString(jobnumProcs));
        try {
            jobNumNodes = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_NUMNODES, 1);
        }
        catch (CoreException e) {
            try {
                IntegerAttributeDefinition jobNumNodesAttrDef = this.getJobNumNodesAttrDef();
                this.nNodesText.setText(jobNumNodesAttrDef.create().getValueAsString());
            }
            catch (IllegalValueException e1) {
                return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_NODES_LABEL) + e.getMessage() + " : " + e1.getMessage());
            }
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_NODES_LABEL) + e.getMessage());
        }
        this.nNodesText.setText(Integer.toString(jobNumNodes));
        try {
            jobTimeLimit = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_TIMELIMIT, 5);
        }
        catch (CoreException e) {
            try {
                IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef();
                this.tLimitText.setText(jobTimeLimitAttrDef.create().getValueAsString());
            }
            catch (IllegalValueException e1) {
                return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage() + " : " + e1.getMessage());
            }
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        this.tLimitText.setText(Integer.toString(jobTimeLimit));
        try {
            jobPartition = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_JOBPARTITION, "");
        }
        catch (CoreException e) {
            StringAttributeDefinition jobPartitionAttrDef = this.getJobPartitionAttrDef();
            this.partText.setText(jobPartitionAttrDef.create().getValueAsString());
            return new RMLaunchValidation(false, String.valueOf(JOB_PARTITION_LABEL) + e.getMessage());
        }
        this.partText.setText(jobPartition);
        try {
            jobReqNodeList = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_JOBREQNODELIST, "");
        }
        catch (CoreException e) {
            StringAttributeDefinition jobReqNodeListAttrDef = this.getJobReqNodeListAttrDef();
            this.reqNodeListText.setText(jobReqNodeListAttrDef.create().getValueAsString());
            return new RMLaunchValidation(false, String.valueOf(JOB_REQUESTED_NODELIST_LABEL) + e.getMessage());
        }
        this.reqNodeListText.setText(jobReqNodeList);
        try {
            jobExcNodeList = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_JOBEXCNODELIST, "");
        }
        catch (CoreException e) {
            StringAttributeDefinition jobExcNodeListAttrDef = this.getJobExcNodeListAttrDef();
            this.excNodeListText.setText(jobExcNodeListAttrDef.create().getValueAsString());
            return new RMLaunchValidation(false, String.valueOf(JOB_EXCLUDED_NODELIST_LABEL) + e.getMessage());
        }
        this.excNodeListText.setText(jobExcNodeList);
        return success;
    }

    public RMLaunchValidation isValid(ILaunchConfiguration configuration) {
        IntegerAttribute iattr;
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getJobNumProcsAttrDef();
            iattr = new IntegerAttribute(numProcsAttrDef, this.nProcsString);
            if (iattr.getValue() < 1) {
                return new RMLaunchValidation(false, Messages.SLURMConfigurationWizardPage_numProcsInvalid);
            }
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobNumNodesAttrDef = this.getJobNumNodesAttrDef();
            iattr = new IntegerAttribute(jobNumNodesAttrDef, this.nNodesString);
            if (iattr.getValue() < 1) {
                return new RMLaunchValidation(false, Messages.SLURMConfigurationWizardPage_numNodesInvalid);
            }
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_NODES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef();
            iattr = new IntegerAttribute(jobTimeLimitAttrDef, this.tLimitString);
            if (iattr.getValue() < 1) {
                return new RMLaunchValidation(false, Messages.SLURMConfigurationWizardPage_timeLimitInvalid);
            }
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        StringAttributeDefinition jobPartitionAttrDef = this.getJobPartitionAttrDef();
        new StringAttribute(jobPartitionAttrDef, this.partString);
        StringAttributeDefinition jobReqNodeListAttrDef = this.getJobReqNodeListAttrDef();
        new StringAttribute(jobReqNodeListAttrDef, this.reqNodeListString);
        StringAttributeDefinition jobExcNodeListAttrDef = this.getJobExcNodeListAttrDef();
        new StringAttribute(jobExcNodeListAttrDef, this.excNodeListString);
        return new RMLaunchValidation(true, "");
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration) {
        IntegerAttribute iattr0 = null;
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getJobNumProcsAttrDef();
            iattr0 = new IntegerAttribute(numProcsAttrDef, this.nProcsString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        configuration.setAttribute(SLURMLaunchConfiguration.ATTR_NUMPROCS, iattr0.getValue().intValue());
        IntegerAttribute iattr1 = null;
        try {
            IntegerAttributeDefinition jobNumNodesAttrDef = this.getJobNumNodesAttrDef();
            iattr1 = new IntegerAttribute(jobNumNodesAttrDef, this.nNodesString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_NODES_LABEL) + e.getMessage());
        }
        configuration.setAttribute(SLURMLaunchConfiguration.ATTR_NUMNODES, iattr1.getValue().intValue());
        IntegerAttribute iattr2 = null;
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef();
            iattr2 = new IntegerAttribute(jobTimeLimitAttrDef, this.tLimitString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        configuration.setAttribute(SLURMLaunchConfiguration.ATTR_TIMELIMIT, iattr2.getValue().intValue());
        StringAttribute sattr0 = null;
        StringAttributeDefinition jobPartitionAttrDef = this.getJobPartitionAttrDef();
        sattr0 = new StringAttribute(jobPartitionAttrDef, this.partString);
        if (sattr0.getValue().length() > 0) {
            configuration.setAttribute(SLURMLaunchConfiguration.ATTR_JOBPARTITION, sattr0.getValue());
        } else {
            configuration.removeAttribute(SLURMLaunchConfiguration.ATTR_JOBPARTITION);
        }
        StringAttribute sattr1 = null;
        StringAttributeDefinition jobReqNodeListAttrDef = this.getJobReqNodeListAttrDef();
        sattr1 = new StringAttribute(jobReqNodeListAttrDef, this.reqNodeListString);
        if (sattr1.getValue().length() > 0) {
            configuration.setAttribute(SLURMLaunchConfiguration.ATTR_JOBREQNODELIST, sattr1.getValue());
        } else {
            configuration.removeAttribute(SLURMLaunchConfiguration.ATTR_JOBREQNODELIST);
        }
        StringAttribute sattr2 = null;
        StringAttributeDefinition jobExcNodeListAttrDef = this.getJobExcNodeListAttrDef();
        sattr2 = new StringAttribute(jobExcNodeListAttrDef, this.excNodeListString);
        if (sattr2.getValue().length() > 0) {
            configuration.setAttribute(SLURMLaunchConfiguration.ATTR_JOBEXCNODELIST, sattr2.getValue());
        } else {
            configuration.removeAttribute(SLURMLaunchConfiguration.ATTR_JOBEXCNODELIST);
        }
        return new RMLaunchValidation(true, "");
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getJobNumProcsAttrDef();
            configuration.setAttribute(SLURMLaunchConfiguration.ATTR_NUMPROCS, numProcsAttrDef.create().getValue().intValue());
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobNumNodesAttrDef = this.getJobNumNodesAttrDef();
            configuration.setAttribute(SLURMLaunchConfiguration.ATTR_NUMNODES, jobNumNodesAttrDef.create().getValue().intValue());
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_NUMBER_OF_NODES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef();
            configuration.setAttribute(SLURMLaunchConfiguration.ATTR_TIMELIMIT, jobTimeLimitAttrDef.create().getValue().intValue());
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        StringAttributeDefinition jobPartitionAttrDef = this.getJobPartitionAttrDef();
        configuration.setAttribute(SLURMLaunchConfiguration.ATTR_JOBPARTITION, jobPartitionAttrDef.create().getValue());
        StringAttributeDefinition jobReqNodeListAttrDef = this.getJobReqNodeListAttrDef();
        configuration.setAttribute(SLURMLaunchConfiguration.ATTR_JOBREQNODELIST, jobReqNodeListAttrDef.create().getValue());
        StringAttributeDefinition jobExcNodeListAttrDef = this.getJobExcNodeListAttrDef();
        configuration.setAttribute(SLURMLaunchConfiguration.ATTR_JOBEXCNODELIST, jobExcNodeListAttrDef.create().getValue());
        return success;
    }

    private IntegerAttributeDefinition getJobNumProcsAttrDef() {
        return SLURMJobAttributes.getJobNumberOfProcsAttributeDefinition();
    }

    private IntegerAttributeDefinition getJobNumNodesAttrDef() {
        return SLURMJobAttributes.getJobNumberOfNodesAttributeDefinition();
    }

    private IntegerAttributeDefinition getJobTimeLimitAttrDef() {
        return SLURMJobAttributes.getJobTimelimitAttributeDefinition();
    }

    private StringAttributeDefinition getJobPartitionAttrDef() {
        return SLURMJobAttributes.getJobPartitionAttributeDefinition();
    }

    private StringAttributeDefinition getJobReqNodeListAttrDef() {
        return SLURMJobAttributes.getJobReqNodeListAttributeDefinition();
    }

    private StringAttributeDefinition getJobExcNodeListAttrDef() {
        return SLURMJobAttributes.getJobExcNodeListAttributeDefinition();
    }
}

