/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.ptp.remote.rse.core.RSEAdapterCorePlugin;
import org.eclipse.rse.internal.services.local.shells.LocalShellOutputReader;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class LocalHostShellWrapper
extends AbstractHostShell
implements IHostShell {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected Process fProcess;
    protected ProcessMonitoringThread fProcessMonitoringThread;
    protected LocalShellOutputReader fStdoutHandler;
    protected LocalShellOutputReader fStderrHandler;
    protected BufferedReader fOutputReader;
    protected BufferedReader fErrReader;

    public LocalHostShellWrapper(Process process) {
        this.fProcess = process;
        this.fProcessMonitoringThread = new ProcessMonitoringThread(process);
        this.fProcessMonitoringThread.start();
        this.fOutputReader = new BufferedReader(new InputStreamReader(this.fProcess.getInputStream()));
        this.fErrReader = new BufferedReader(new InputStreamReader(this.fProcess.getErrorStream()));
        this.fStdoutHandler = new LocalShellOutputReader((IHostShell)this, this.fOutputReader, false);
        this.fStderrHandler = new LocalShellOutputReader((IHostShell)this, this.fErrReader, true);
    }

    public boolean isActive() {
        return this.fProcessMonitoringThread.isAlive();
    }

    public void writeToShell(String command) {
        OutputStream outputStream = this.fProcess.getOutputStream();
        try {
            outputStream.write((String.valueOf(command) + NEWLINE).getBytes());
        }
        catch (IOException e) {
            RSEAdapterCorePlugin.log(e);
        }
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this.fStdoutHandler;
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this.fStderrHandler;
    }

    public void exit() {
        this.writeToShell("exit");
    }

    protected class ProcessMonitoringThread
    extends Thread {
        protected Process fProcessToMonitor;

        public ProcessMonitoringThread(Process process) {
            this.fProcessToMonitor = process;
        }

        public void run() {
            try {
                this.fProcessToMonitor.waitFor();
            }
            catch (InterruptedException e) {
                RSEAdapterCorePlugin.log(e);
            }
        }
    }
}

