/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.rephraserengine.core.preservation.Messages;
import org.eclipse.rephraserengine.core.preservation.Model;
import org.eclipse.rephraserengine.core.preservation.ModelDiff;
import org.eclipse.rephraserengine.core.preservation.PostTransformationContext;
import org.eclipse.rephraserengine.core.preservation.PreservationRuleset;
import org.eclipse.rephraserengine.core.preservation.Replacement;
import org.eclipse.rephraserengine.core.preservation.ReplacementList;
import org.eclipse.rephraserengine.core.preservation.ResetOffsetLength;
import org.eclipse.rephraserengine.core.util.OffsetLength;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;

public final class PreservationAnalysis {
    private static final String SEPARATOR = ",";
    private IAdapterManager adapterManager = Platform.getAdapterManager();
    private EclipseVPG vpg;
    private Model initialModel;
    private ReplacementList replacements;
    private PreservationRuleset ruleset;
    private String fields;
    private String times;

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, IFile file, PreservationRuleset ruleset) {
        this(vpg, progressMonitor, ticks, EclipseVPG.getFilenameForIFile(file), ruleset);
    }

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, Collection<IFile> files, PreservationRuleset ruleset) {
        this(vpg, progressMonitor, ticks, PreservationAnalysis.getFilenames(files), ruleset);
    }

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, String filename, PreservationRuleset ruleset) {
        this(vpg, progressMonitor, ticks, Collections.singletonList(filename), ruleset);
    }

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, List<String> filenames, PreservationRuleset ruleset) {
        this.vpg = vpg;
        this.replacements = new ReplacementList();
        this.ruleset = ruleset;
        this.fields = "Filenames";
        this.times = filenames.toString();
        progressMonitor.subTask(Messages.PreservationAnalysis_EnteringHypotheticalMode);
        long start = System.currentTimeMillis();
        this.ensureDatabaseIsInHypotheticalMode();
        this.fields = String.valueOf(this.fields) + ",Hypothetical";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        this.initialModel = new Model("initial model", progressMonitor, ticks, vpg, filenames);
        this.fields = String.valueOf(this.fields) + ",Init Model";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
    }

    private static List<String> getFilenames(Collection<IFile> files) {
        ArrayList<String> result = new ArrayList<String>(files.size());
        for (IFile file : files) {
            result.add(EclipseVPG.getFilenameForIFile(file));
        }
        return result;
    }

    private void ensureDatabaseIsInHypotheticalMode() throws Error {
        if (!this.vpg.isInHypotheticalMode()) {
            try {
                this.vpg.enterHypotheticalMode();
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }

    public void markAlpha(IFile file, Object node) {
        String filename = EclipseVPG.getFilenameForIFile(file);
        OffsetLength offsetLength = (OffsetLength)this.adapterManager.getAdapter(node, OffsetLength.class);
        if (offsetLength == null) {
            throw new Error("Unable to get OffsetLength adapter for " + node.getClass().getName());
        }
        Replacement alpha = new Replacement(filename, offsetLength.getOffset(), 0, offsetLength.getLength());
        this.replacements.add(alpha);
        this.adapterManager.getAdapter(node, ResetOffsetLength.class);
    }

    public void markEpsilon(IFile file, Object node) {
        String filename = EclipseVPG.getFilenameForIFile(file);
        OffsetLength offsetLength = (OffsetLength)this.adapterManager.getAdapter(node, OffsetLength.class);
        if (offsetLength == null) {
            throw new Error("Unable to get OffsetLength adapter for " + node.getClass().getName());
        }
        Replacement epsilon = new Replacement(filename, offsetLength.getOffset(), offsetLength.getLength(), 0);
        this.replacements.add(epsilon);
    }

    public void markRho(IFile file, Object node, int oldLength, int newLength) {
        String filename = EclipseVPG.getFilenameForIFile(file);
        OffsetLength offsetLength = (OffsetLength)this.adapterManager.getAdapter(node, OffsetLength.class);
        if (offsetLength == null) {
            throw new Error("Unable to get OffsetLength adapter for " + node.getClass().getName());
        }
        Replacement rho = new Replacement(filename, offsetLength.getOffset(), oldLength, newLength);
        this.replacements.add(rho);
    }

    public String toString() {
        return this.replacements.toString();
    }

    public void logPostTransformTime(long milliseconds) {
        this.fields = String.valueOf(this.fields) + ",PostTransform";
        this.times = String.valueOf(this.times) + SEPARATOR + milliseconds;
    }

    public void checkForPreservation(RefactoringStatus status, IProgressMonitor progressMonitor, int ticks) {
        this.printDebug("INITIAL MODEL", this.initialModel);
        this.printDebug("NORMALIZING RELATIVE TO", this.replacements);
        long start = System.currentTimeMillis();
        this.initialModel.inormalize(this.replacements, progressMonitor);
        this.fields = String.valueOf(this.fields) + ",I-Normalize";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
        this.printDebug("NORMALIZED INITIAL MODEL", this.initialModel);
        this.printDebug("File ordering:", this.initialModel.getFiles());
        start = System.currentTimeMillis();
        Model derivativeModel = new Model("derivative model", progressMonitor, ticks + 3, this.vpg, this.initialModel.getFiles());
        this.fields = String.valueOf(this.fields) + ",D-Model";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
        this.printDebug("DERIVATIVE MODEL", derivativeModel);
        start = System.currentTimeMillis();
        derivativeModel.dnormalize(this.replacements, progressMonitor);
        this.fields = String.valueOf(this.fields) + ",D-Normalize";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
        this.printDebug("NORMALIZED DERIVATIVE MODEL", derivativeModel);
        start = System.currentTimeMillis();
        ModelDiff diff = this.initialModel.checkPreservation(derivativeModel, this.ruleset, progressMonitor);
        this.fields = String.valueOf(this.fields) + ",Preservation";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        this.describeDifferences(status, diff);
        this.fields = String.valueOf(this.fields) + ",Desc Diff";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        this.leaveHypotheticalMode(progressMonitor);
        this.fields = String.valueOf(this.fields) + ",Leave Hypoth";
        this.times = String.valueOf(this.times) + SEPARATOR + (System.currentTimeMillis() - start);
        this.logTimes();
    }

    private void logTimes() {
        try {
            FileWriter output = new FileWriter(String.valueOf(System.getProperty("user.home")) + File.separator + "Desktop" + File.separator + "times.csv", true);
            output.write(String.valueOf(this.fields) + "\n");
            output.write(String.valueOf(this.times) + "\n");
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void leaveHypotheticalMode(IProgressMonitor progressMonitor) throws Error {
        try {
            progressMonitor.subTask(Messages.PreservationAnalysis_ExitingHypotheticalMode);
            this.vpg.leaveHypotheticalMode();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void printDebug(String string, Object object) {
        System.out.println();
        System.out.println();
        System.out.print(string);
        System.out.println(":");
        System.out.println(object.toString());
    }

    private void describeDifferences(final RefactoringStatus status, ModelDiff diff) {
        final HashMap modifiedSourceCode = new HashMap();
        diff.processUsing(new ModelDiff.ModelDiffProcessor(){

            @Override
            public void processAllEdgesDeleted(Set<String> filesWithAllEdgesDeleted) {
                String msg = Messages.PreservationAnalysis_TheFollowingFilesWillNotCompile;
                status.addError(msg);
                for (String filename : filesWithAllEdgesDeleted) {
                    status.addError("    " + filename, (RefactoringStatusContext)new FileStatusContext(EclipseVPG.getIFileForFilename(filename), null));
                }
            }

            private String getCode(IFile file, HashMap<IFile, String> modifiedSourceCode2) {
                if (file == null) {
                    return null;
                }
                if (modifiedSourceCode2.containsKey(file)) {
                    return modifiedSourceCode2.get(file);
                }
                Object ast = PreservationAnalysis.this.vpg.acquireTransientAST(EclipseVPG.getFilenameForIFile(file));
                if (ast == null) {
                    return null;
                }
                String code = PreservationAnalysis.this.vpg.getSourceCodeFromAST(ast);
                if (code == null) {
                    return null;
                }
                modifiedSourceCode2.put(file, code);
                return code;
            }

            @Override
            public void processEdgeAdded(ModelDiff.EdgeAdded addition) {
                String msg = Messages.bind((String)Messages.PreservationAnalysis_TransformationWillIntroduce, (Object)PreservationAnalysis.this.vpg.describeEdgeType(addition.edge.getType()).toLowerCase(), (Object)addition);
                status.addError(msg);
                status.addError(Messages.PreservationAnalysis_FromHere, (RefactoringStatusContext)new PostTransformationContext(addition.getFileContainingSourceRegion(), this.getCode(addition.getFileContainingSourceRegion(), modifiedSourceCode), addition.getSourceRegion()));
                status.addError(Messages.PreservationAnalysis_ToHere, (RefactoringStatusContext)new PostTransformationContext(addition.getFileContainingSinkRegion(), this.getCode(addition.getFileContainingSinkRegion(), modifiedSourceCode), addition.getSinkRegion()));
            }

            @Override
            public void processEdgeDeleted(ModelDiff.EdgeDeleted deletion) {
                String msg = Messages.bind((String)Messages.PreservationAnalysis_TransformationWillEliminate, (Object)PreservationAnalysis.this.vpg.describeEdgeType(deletion.edge.getType()).toLowerCase(), (Object)deletion);
                status.addError(msg);
                status.addError(Messages.PreservationAnalysis_FromHere, (RefactoringStatusContext)new FileStatusContext(deletion.getFileContainingSourceRegion(), deletion.getSourceRegion()));
                status.addError(Messages.PreservationAnalysis_ToHere, (RefactoringStatusContext)new FileStatusContext(deletion.getFileContainingSinkRegion(), deletion.getSinkRegion()));
            }

            @Override
            public void processEdgeSinkChanged(ModelDiff.EdgeSinkChanged change) {
                String msg = Messages.bind((String)Messages.PreservationAnalysis_TransformationWillChange, (Object)PreservationAnalysis.this.vpg.describeEdgeType(change.edge.getType()).toLowerCase(), (Object)change);
                status.addError(msg);
                status.addError(Messages.bind((String)Messages.PreservationAnalysis_EdgeWillChange, (Object)PreservationAnalysis.this.vpg.describeEdgeType(change.edge.getType()).toLowerCase()), (RefactoringStatusContext)new PostTransformationContext(change.getFileContainingSourceRegion(), this.getCode(change.getFileContainingSourceRegion(), modifiedSourceCode), change.getSourceRegion()));
                status.addError(Messages.PreservationAnalysis_ToHere, (RefactoringStatusContext)new PostTransformationContext(change.getFileContainingSinkRegion(), this.getCode(change.getFileContainingSinkRegion(), modifiedSourceCode), change.getSinkRegion()));
                status.addError(Messages.PreservationAnalysis_WillPointHereInstead, (RefactoringStatusContext)new PostTransformationContext(change.getFileContainingNewSinkRegion(), this.getCode(change.getFileContainingNewSinkRegion(), modifiedSourceCode), change.getNewSinkRegion()));
            }
        });
    }

    public static boolean printModelOn(PrintStream ps, IFile file, EclipseVPG<?, ?, ?> vpg) throws UnsupportedEncodingException, IOException, CoreException {
        String filename = EclipseVPG.getFilenameForIFile(file);
        if (filename == null) {
            return false;
        }
        ArrayList<Integer> lineMap = new ArrayList<Integer>();
        String fileContents = PreservationAnalysis.readStream(lineMap, new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset())));
        ps.println(filename);
        ps.println();
        Model model = new Model("edge model", (IProgressMonitor)new NullProgressMonitor(), 0, vpg, filename);
        ps.print(model.toString(filename, fileContents, lineMap));
        return true;
    }

    private static String readStream(ArrayList<Integer> lineMap, Reader in) throws IOException {
        StringBuffer sb = new StringBuffer(4096);
        int offset = 0;
        int ch = in.read();
        while (ch >= 0) {
            sb.append((char)ch);
            ++offset;
            if (ch == 10 && lineMap != null) {
                lineMap.add(offset);
            }
            ch = in.read();
        }
        in.close();
        return sb.toString();
    }
}

