/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ems.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.ems.core.EnvManagerRegistry;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.ems.internal.ui.EMSUIPlugin;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ui.PlatformUI;

public class LazyEnvManagerDetector
implements IEnvManager {
    private final IRemoteConnection remoteConnection;
    private IProgressMonitor fMonitor;
    private IEnvManager envManager = null;

    public LazyEnvManagerDetector(IRemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
    }

    public boolean checkForCompatibleInstallation(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        return this.ensureEnvManagerDetected().checkForCompatibleInstallation(pm);
    }

    public void configure(IRemoteConnection remoteConnection) {
        this.ensureEnvManagerDetected().configure(remoteConnection);
    }

    public String createBashScript(IProgressMonitor pm, boolean echo, IEnvManagerConfig config, String commandToExecuteAfterward) throws RemoteConnectionException, IOException {
        return this.ensureEnvManagerDetected().createBashScript(pm, echo, config, commandToExecuteAfterward);
    }

    public Set<String> determineAvailableElements(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        return this.ensureEnvManagerDetected().determineAvailableElements(pm);
    }

    public Set<String> determineDefaultElements(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        return this.ensureEnvManagerDetected().determineDefaultElements(pm);
    }

    public String getBashConcatenation(String separator, boolean echo, IEnvManagerConfig config, String commandToExecuteAfterward) {
        return this.ensureEnvManagerDetected().getBashConcatenation(separator, echo, config, commandToExecuteAfterward);
    }

    public Comparator<String> getComparator() {
        return this.ensureEnvManagerDetected().getComparator();
    }

    public String getDescription(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        return this.ensureEnvManagerDetected().getDescription(pm);
    }

    public String getInstructions() {
        return this.ensureEnvManagerDetected().getInstructions();
    }

    public String getName() {
        return this.ensureEnvManagerDetected().getName();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    private IEnvManager ensureEnvManagerDetected() {
        if (this.envManager == null) {
            GetEnvManagerRunnable runnable = new GetEnvManagerRunnable();
            try {
                if (this.fMonitor != null) {
                    runnable.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.fMonitor));
                } else {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
                }
            }
            catch (InvocationTargetException e) {
                EMSUIPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {}
            this.envManager = runnable.getResult();
        }
        return this.envManager;
    }

    private class GetEnvManagerRunnable
    implements IRunnableWithProgress {
        private IEnvManager envManager = EnvManagerRegistry.getNullEnvManager();

        private GetEnvManagerRunnable() {
        }

        public IEnvManager getResult() {
            return this.envManager;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.envManager = EnvManagerRegistry.getEnvManager((IProgressMonitor)monitor, (IRemoteConnection)LazyEnvManagerDetector.this.remoteConnection);
        }
    }
}

