/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.refactoring.PermuteSubroutineArgsRefactoring;
import org.eclipse.photran.internal.ui.refactoring.Messages;
import org.eclipse.rephraserengine.ui.refactoring.CustomUserInputPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PermuteSubroutineArgsInputPage
extends CustomUserInputPage<PermuteSubroutineArgsRefactoring> {
    private Composite top;
    private Composite parent;
    private Group parameterGroup;
    private Button upButton;
    private Button downButton;
    private Table parameterTable;
    private Label statusLabel;

    public void createControl(Composite parent) {
        this.parent = parent;
        this.top = new Composite(parent, 0);
        this.initializeDialogUnits((Control)this.top);
        this.setControl((Control)this.top);
        this.top.setLayout((Layout)new GridLayout(1, false));
        this.parameterGroup = new Group(this.top, 0);
        this.parameterGroup.setLayout((Layout)new GridLayout(2, false));
        this.parameterGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parameterGroup.setText(Messages.PermuteSubroutineArgsInputPage_parameterGroupLabel);
        this.parameterTable = this.createParameterTable(this.parameterGroup);
        Composite buttonComposite = new Composite((Composite)this.parameterGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.upButton = new Button(buttonComposite, 0);
        this.upButton.setText(Messages.PermuteSubroutineArgsInputPage_upButtonLabel);
        this.upButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.downButton = new Button(buttonComposite, 0);
        this.downButton.setText(Messages.PermuteSubroutineArgsInputPage_downButtonLabel);
        this.downButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.statusLabel = new Label(this.top, 0);
        this.statusLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        for (ASTSubroutineParNode parameterNode : ((PermuteSubroutineArgsRefactoring)this.getRefactoring()).getSubroutineParameters()) {
            this.createParameterTableItem(parameterNode);
        }
        this.parameterTable.addSelectionListener((SelectionListener)new ParameterTableSelectionListener());
        this.upButton.addSelectionListener((SelectionListener)new UpButtonSelectionListener());
        this.downButton.addSelectionListener((SelectionListener)new DownButtonSelectionListener());
        this.tableSelected();
    }

    protected void createParameterTableItem(ASTSubroutineParNode parameterNode) {
        TableItem newItem = new TableItem(this.parameterTable, 0);
        if (parameterNode.isAsterisk()) {
            newItem.setText(0, "*");
            newItem.setText(3, Boolean.toString(true));
            newItem.setText(4, Boolean.toString(false));
        } else {
            List definitionList = parameterNode.getVariableName().resolveBinding();
            if (definitionList.size() == 1) {
                Definition definition = (Definition)definitionList.get(0);
                newItem.setText(0, definition.getDeclaredName());
                newItem.setText(1, definition.getType().toString());
                String intent = new String();
                if (definition.isIntentIn()) {
                    intent = String.valueOf(intent) + Messages.PermuteSubroutineArgsInputPage_intentInLabel;
                }
                if (definition.isIntentOut()) {
                    intent = String.valueOf(intent) + Messages.PermuteSubroutineArgsInputPage_intentOutLabel;
                }
                newItem.setText(2, intent);
                newItem.setText(3, Boolean.toString(false));
                newItem.setText(4, Boolean.toString(definition.isOptional()));
                newItem.setText(5, Boolean.toString(((PermuteSubroutineArgsRefactoring)this.getRefactoring()).isUsedWithKeywordInCallStmt(parameterNode)));
            }
        }
        newItem.setData((Object)parameterNode);
        this.parameterTable.pack();
    }

    protected Table createParameterTable(Group parameterGroup) {
        Table parameterTable = new Table((Composite)parameterGroup, 2816);
        parameterTable.setLayoutData((Object)new GridData(4, 4, true, true));
        parameterTable.setLinesVisible(true);
        parameterTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(parameterTable, 0);
        nameColumn.setText(Messages.PermuteSubroutineArgsInputPage_nameLabel);
        nameColumn.setWidth(100);
        TableColumn typeColumn = new TableColumn(parameterTable, 0);
        typeColumn.setText(Messages.PermuteSubroutineArgsInputPage_typeLabel);
        typeColumn.setWidth(100);
        TableColumn intentColumn = new TableColumn(parameterTable, 0);
        intentColumn.setText(Messages.PermuteSubroutineArgsInputPage_intentLabel);
        intentColumn.setWidth(100);
        TableColumn alternateReturnColumn = new TableColumn(parameterTable, 0);
        alternateReturnColumn.setText(Messages.PermuteSubroutineArgsInputPage_alternateReturnColumnLabel);
        alternateReturnColumn.setWidth(100);
        TableColumn optionalColumn = new TableColumn(parameterTable, 0);
        optionalColumn.setText(Messages.PermuteSubroutineArgsInputPage_optionalColumnLabel);
        optionalColumn.setWidth(100);
        TableColumn keywordColumn = new TableColumn(parameterTable, 0);
        keywordColumn.setText(Messages.PermuteSubroutineArgsInputPage_keywordedColumnLabel);
        keywordColumn.setWidth(100);
        parameterTable.pack();
        return parameterTable;
    }

    protected void tableSelected() {
        this.statusLabel.setText("");
        this.upButton.setEnabled(true);
        this.downButton.setEnabled(true);
        this.setPageComplete(true);
        String statusText = new String();
        ArrayList<ASTSubroutineParNode> tableNodes = new ArrayList<ASTSubroutineParNode>();
        int i = 0;
        while (i < this.parameterTable.getItemCount()) {
            tableNodes.add((ASTSubroutineParNode)this.parameterTable.getItem(i).getData());
            ++i;
        }
        int selectedIndex = this.parameterTable.getSelectionIndex();
        if (this.parameterTable.getItemCount() == 0) {
            return;
        }
        if (selectedIndex < 0 || selectedIndex > this.parameterTable.getItemCount()) {
            selectedIndex = 0;
        }
        if (selectedIndex == 0) {
            this.upButton.setEnabled(false);
        }
        if (selectedIndex == tableNodes.size() - 1) {
            this.downButton.setEnabled(false);
        }
        statusText = this.checkPreconditions(statusText, tableNodes, selectedIndex);
        this.statusLabel.setText(statusText);
        this.statusLabel.pack(true);
        this.parameterGroup.pack(true);
        this.top.pack(true);
        this.parent.pack(true);
    }

    protected String checkPreconditions(String statusText, List<ASTSubroutineParNode> tableNodes, int selectedIndex) {
        if (tableNodes.get(selectedIndex).isAsterisk()) {
            if (selectedIndex - 1 > 0 && tableNodes.get(selectedIndex - 1).isAsterisk()) {
                this.upButton.setEnabled(false);
                statusText = String.valueOf(statusText) + Messages.PermuteSubroutineArgsInputPage_alternateReturnErrorLabel;
            }
            if (selectedIndex + 1 < tableNodes.size() && tableNodes.get(selectedIndex + 1).isAsterisk()) {
                this.downButton.setEnabled(false);
                statusText = String.valueOf(statusText) + Messages.PermuteSubroutineArgsInputPage_alternateReturnErrorLabel;
            }
        }
        if (this.optionalArgumentIsBeforeAlternateReturn(tableNodes)) {
            this.setPageComplete(false);
            statusText = String.valueOf(statusText) + Messages.PermuteSubroutineArgsInputPage_optionalArgumentErrorLabel;
        }
        if (this.keywordedArgumentIsBeforeAlternateReturn(tableNodes)) {
            this.setPageComplete(false);
            statusText = String.valueOf(statusText) + Messages.PermuteSubroutineArgsInputPage_keywordErrorLabel;
        }
        if (tableNodes.size() < 2) {
            this.setPageComplete(false);
            statusText = String.valueOf(statusText) + Messages.PermuteSubroutineArgsInputPage_notEnoughArgumentsErrorLabel;
        }
        return statusText;
    }

    private boolean optionalArgumentIsBeforeAlternateReturn(List<ASTSubroutineParNode> tableNodes) {
        int i = 0;
        while (i < tableNodes.size()) {
            Definition definition;
            List definitionList;
            if (tableNodes.get(i).getVariableName() != null && (definitionList = tableNodes.get(i).getVariableName().resolveBinding()).size() == 1 && (definition = (Definition)definitionList.get(0)).isOptional()) {
                int j = i + 1;
                while (j < tableNodes.size()) {
                    if (tableNodes.get(j).isAsterisk()) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean keywordedArgumentIsBeforeAlternateReturn(List<ASTSubroutineParNode> tableNodes) {
        int i = 0;
        while (i < tableNodes.size()) {
            if (((PermuteSubroutineArgsRefactoring)this.getRefactoring()).isUsedWithKeywordInCallStmt(tableNodes.get(i))) {
                int j = i + 1;
                while (j < tableNodes.size()) {
                    if (tableNodes.get(j).isAsterisk()) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private final class DownButtonSelectionListener
    implements SelectionListener {
        private DownButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (PermuteSubroutineArgsInputPage.this.parameterTable.getSelectionCount() == 1) {
                List originalParameters = ((PermuteSubroutineArgsRefactoring)PermuteSubroutineArgsInputPage.this.getRefactoring()).getSubroutineParameters();
                TableItem selectedItem = PermuteSubroutineArgsInputPage.this.parameterTable.getSelection()[0];
                int oldIndex = PermuteSubroutineArgsInputPage.this.parameterTable.indexOf(selectedItem);
                if (oldIndex < PermuteSubroutineArgsInputPage.this.parameterTable.getItemCount() - 1) {
                    TableItem newItem = new TableItem(PermuteSubroutineArgsInputPage.this.parameterTable, 0, oldIndex + 2);
                    int i = 0;
                    while (i < PermuteSubroutineArgsInputPage.this.parameterTable.getColumnCount()) {
                        newItem.setText(i, selectedItem.getText(i));
                        ++i;
                    }
                    newItem.setData(selectedItem.getData());
                    PermuteSubroutineArgsInputPage.this.parameterTable.remove(oldIndex);
                    PermuteSubroutineArgsInputPage.this.parameterTable.select(oldIndex + 1);
                    ArrayList<Integer> sigma = new ArrayList<Integer>();
                    TableItem[] tableItemArray = PermuteSubroutineArgsInputPage.this.parameterTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        sigma.add(originalParameters.indexOf(item.getData()));
                        ++n2;
                    }
                    ((PermuteSubroutineArgsRefactoring)PermuteSubroutineArgsInputPage.this.getRefactoring()).setSigma(sigma);
                    PermuteSubroutineArgsInputPage.this.tableSelected();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private final class ParameterTableSelectionListener
    implements SelectionListener {
        private ParameterTableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PermuteSubroutineArgsInputPage.this.tableSelected();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private final class UpButtonSelectionListener
    implements SelectionListener {
        private UpButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (PermuteSubroutineArgsInputPage.this.parameterTable.getSelectionCount() == 1) {
                List originalParameters = ((PermuteSubroutineArgsRefactoring)PermuteSubroutineArgsInputPage.this.getRefactoring()).getSubroutineParameters();
                TableItem selectedItem = PermuteSubroutineArgsInputPage.this.parameterTable.getSelection()[0];
                int oldIndex = PermuteSubroutineArgsInputPage.this.parameterTable.indexOf(selectedItem);
                if (oldIndex > 0) {
                    TableItem newItem = new TableItem(PermuteSubroutineArgsInputPage.this.parameterTable, 0, oldIndex - 1);
                    int i = 0;
                    while (i < PermuteSubroutineArgsInputPage.this.parameterTable.getColumnCount()) {
                        newItem.setText(i, selectedItem.getText(i));
                        ++i;
                    }
                    newItem.setData(selectedItem.getData());
                    PermuteSubroutineArgsInputPage.this.parameterTable.remove(oldIndex + 1);
                    PermuteSubroutineArgsInputPage.this.parameterTable.select(oldIndex - 1);
                    ArrayList<Integer> sigma = new ArrayList<Integer>();
                    TableItem[] tableItemArray = PermuteSubroutineArgsInputPage.this.parameterTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        sigma.add(originalParameters.indexOf(item.getData()));
                        ++n2;
                    }
                    ((PermuteSubroutineArgsRefactoring)PermuteSubroutineArgsInputPage.this.getRefactoring()).setSigma(sigma);
                    PermuteSubroutineArgsInputPage.this.tableSelected();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

