/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.includebrowser;

import java.net.URI;
import org.eclipse.cdt.core.EFSExtensionProvider;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIndexIncludeValue;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IncludeBrowserServiceFactory;
import org.eclipse.ptp.internal.rdt.ui.includebrowser.IBViewPart;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class IncludeBrowserUI {
    public static void open(IWorkbenchWindow window, ICElement input) {
        try {
            ITranslationUnit tu = IncludeBrowserUI.convertToTranslationUnit(input);
            if (tu != null) {
                IWorkbenchPage page = window.getActivePage();
                IBViewPart result = (IBViewPart)page.showView("org.eclipse.ptp.rdt.ui.includeBrowser");
                result.setInput(tu);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)window.getShell(), (String)IBMessages.OpenIncludeBrowserAction_label, null);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void open(ITextEditor editor, ITextSelection sel) {
        if (editor != null) {
            IWorkingCopy inputCElement = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
            IncludeBrowserUI.open(editor.getSite().getWorkbenchWindow(), (ICElement)inputCElement);
        }
    }

    private static ITranslationUnit convertToTranslationUnit(ICElement input) throws CoreException, InterruptedException {
        ITranslationUnit result = null;
        if (input instanceof IInclude) {
            result = IncludeBrowserUI.findTargetTranslationUnit((IInclude)input);
        }
        if (result == null && input instanceof ISourceReference) {
            result = ((ISourceReference)input).getTranslationUnit();
        }
        return result;
    }

    private static ITranslationUnit findTargetTranslationUnit(IInclude input) throws CoreException, InterruptedException {
        URI uri;
        IIndexFileLocation loc;
        IIncludeBrowserService service;
        IIndexIncludeValue include;
        ICProject project = input.getCProject();
        if (project != null && (include = (service = new IncludeBrowserServiceFactory().getIncludeBrowserService(project)).findInclude(input, null)) != null && (loc = include.getIncludesLocation()) != null && (uri = IncludeBrowserUI.replacePath(project.getProject(), input.getLocationURI(), loc.getURI().getPath())) != null) {
            return CoreModelUtil.findTranslationUnitForLocation((URI)uri, (ICProject)project);
        }
        return null;
    }

    public static boolean isIndexed(ICElement element, IProgressMonitor monitor) throws CoreException {
        IIndexFileLocation location;
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            ICProject project = element.getCProject();
            IIncludeBrowserService service = new IncludeBrowserServiceFactory().getIncludeBrowserService(project);
            return service != null ? service.isIndexed(location, project, monitor) : false;
        }
        return false;
    }

    private static URI replacePath(IProject project, URI u, String path) {
        if (IncludeBrowserUI.isLocalServiceConfiguration(project)) {
            return new EFSExtensionProvider(){}.createNewURIFromPath(u, path);
        }
        return EFSExtensionManager.getDefault().createNewURIFromPath(u, path);
    }

    private static boolean isLocalServiceConfiguration(IProject project) {
        IService indexingService;
        IServiceConfiguration serviceConfig;
        IServiceProvider serviceProvider;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        if (smm.isConfigured(project) && (serviceProvider = (serviceConfig = smm.getActiveConfiguration(project)).getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"))) instanceof IIndexServiceProvider) {
            return !((IIndexServiceProvider)serviceProvider).isRemote();
        }
        return false;
    }
}

