/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;

public final class JAXBUtils {
    private ConnectionChangeListener connectionListener;
    private static final Map<String, RemoteServicesDelegate> fDelegates = new HashMap<String, RemoteServicesDelegate>();

    public static void checkConnection(IRemoteConnection connection, SubMonitor progress) throws RemoteConnectionException {
        if (connection != null) {
            if (!connection.isOpen()) {
                connection.open((IProgressMonitor)progress.newChild(25));
                if (!connection.isOpen()) {
                    throw new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection.getAddress());
                }
            }
        } else {
            new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection);
        }
    }

    private static void checkJobForError(ICommandJob job) throws CoreException {
        IStatus status = job.getRunStatus();
        if (status != null && status.getSeverity() == 4) {
            Throwable t = status.getException();
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            throw CoreExceptionUtils.newException((String)status.getMessage(), (Throwable)t);
        }
    }

    private static String getName(String remoteId, String connName) {
        return String.valueOf(remoteId) + "." + connName;
    }

    public static RemoteServicesDelegate getRemoteServicesDelegate(String remoteId, String connName, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IRemoteConnection conn;
            RemoteServicesDelegate delegate = fDelegates.get(JAXBUtils.getName(remoteId, connName));
            if (delegate == null) {
                delegate = new RemoteServicesDelegate(remoteId, connName);
                delegate.initialize((IProgressMonitor)progress.newChild(5));
                fDelegates.put(JAXBUtils.getName(remoteId, connName), delegate);
            }
            if (!(conn = delegate.getRemoteConnection()).isOpen()) {
                try {
                    conn.open((IProgressMonitor)progress.newChild(5));
                }
                catch (RemoteConnectionException remoteConnectionException) {}
            }
            RemoteServicesDelegate remoteServicesDelegate = delegate;
            return remoteServicesDelegate;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private class ConnectionChangeListener
    implements IRemoteConnectionChangeListener {
        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            if (event.getType() != 4) {
                event.getType();
            }
        }
    }
}

