/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.ems.core.EnvManagerProjectProperties;
import org.eclipse.ptp.ems.core.EnvManagerRegistry;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.server.RemoteServerManager;
import org.eclipse.ptp.rm.jaxb.control.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.JobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.ManagedFilesJob;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.JobIdPinTable;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.control.runnable.ScriptHandler;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.JAXBInitializationUtils;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFileType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFilesType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;
import org.eclipse.ptp.rm.jaxb.core.data.SiteType;
import org.eclipse.ptp.rm.lml.da.server.core.LMLDAServer;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchController
implements ILaunchController {
    private final ConnectionChangeListener connectionListener = new ConnectionChangeListener();
    private final Map<String, String> launchEnv = new TreeMap<String, String>();
    private final JobIdPinTable pinTable = new JobIdPinTable();
    private String fControlId;
    private ICommandJob interactiveJob;
    private ICommandJobStatusMap jobStatusMap;
    private RMVariableMap rmVarMap;
    private ControlType controlData;
    private String servicesId;
    private String connectionName;
    private boolean appendLaunchEnv;
    private boolean isActive = false;
    private boolean isInitialized = false;
    private String configURL;
    private RemoteServicesDelegate fRemoteServicesDelegate;
    private ResourceManagerData configData;

    private void addAttribute(String name, String value) {
        AttributeType attr = this.getEnvironment().get(name);
        if (attr == null) {
            attr = new AttributeType();
            attr.setName(name);
            attr.setVisible(Boolean.valueOf(true));
            attr.setReadOnly(Boolean.valueOf(true));
            this.getEnvironment().put(name, attr);
        }
        attr.setValue((Object)value);
    }

    private void addConnectionPropertyAttributes(IRemoteConnection conn) {
        String property = conn.getProperty("os.arch");
        if (property != null) {
            this.addAttribute("os.arch", property);
        }
        if ((property = conn.getProperty("os.name")) != null) {
            this.addAttribute("os.name", property);
        }
        if ((property = conn.getProperty("os.version")) != null) {
            this.addAttribute("os.version", property);
        }
    }

    private void checkConnection(IRemoteConnection connection, SubMonitor progress) throws RemoteConnectionException {
        if (connection != null) {
            if (!connection.isOpen()) {
                connection.open((IProgressMonitor)progress.newChild(25));
                if (!connection.isOpen()) {
                    throw new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection.getAddress());
                }
            }
        } else {
            new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection);
        }
    }

    private void checkJobForError(ICommandJob job) throws CoreException {
        IStatus status = job.getRunStatus();
        if (status != null && status.getSeverity() == 4) {
            Throwable t = status.getException();
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            throw CoreExceptionUtils.newException((String)status.getMessage(), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void control(String jobId, String operation, IProgressMonitor monitor) throws CoreException {
        if (!this.resourceManagerIsActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_resourceManagerNotStarted, null);
        }
        if (jobId == null) {
            LaunchController launchController = this;
            synchronized (launchController) {
                if (this.interactiveJob != null) {
                    this.interactiveJob.terminate();
                    this.interactiveJob = null;
                }
            }
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.pinTable.pin(jobId);
            AttributeType a = new AttributeType();
            a.setVisible(Boolean.valueOf(false));
            a.setName(jobId);
            this.getRMVariableMap().put(jobId, a);
            this.worked((IProgressMonitor)progress, 30);
            this.doControlCommand(jobId, operation);
            this.getRMVariableMap().remove(jobId);
            this.worked((IProgressMonitor)progress, 40);
            if ("TERMINATE".equals(operation)) {
                ICommandJobStatus canceledStatus = this.jobStatusMap.cancel(jobId);
                LaunchController launchController = this;
                synchronized (launchController) {
                    if (this.interactiveJob != null && canceledStatus == this.interactiveJob.getJobStatus()) {
                        this.interactiveJob = null;
                    }
                }
            }
            this.worked((IProgressMonitor)progress, 30);
        }
        finally {
            this.pinTable.release(jobId);
        }
    }

    @Override
    public void dispose() {
    }

    private void doControlCommand(String jobId, String operation) throws CoreException {
        CoreException ce = CoreExceptionUtils.newException((String)(String.valueOf(Messages.RMNoSuchCommandError) + operation), null);
        CommandType job = null;
        if ("TERMINATE".equals(operation)) {
            this.maybeKillInteractive(jobId);
            job = this.controlData.getTerminateJob();
            if (job == null) {
                return;
            }
        } else if ("SUSPEND".equals(operation) ? (job = this.controlData.getSuspendJob()) == null : ("RESUME".equals(operation) ? (job = this.controlData.getResumeJob()) == null : ("RELEASE".equals(operation) ? (job = this.controlData.getReleaseJob()) == null : "HOLD".equals(operation) && (job = this.controlData.getHoldJob()) == null))) {
            throw ce;
        }
        this.runCommand(jobId, job, CommandJob.JobMode.INTERACTIVE, null, "run", true);
    }

    private ICommandJob doJobSubmitCommand(String uuid, ILaunchConfiguration configuration, String mode) throws CoreException {
        CommandType command = null;
        CommandJob.JobMode jobMode = CommandJob.JobMode.INTERACTIVE;
        if ("run".equals(mode)) {
            command = this.controlData.getSubmitBatch();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.controlData.getSubmitInteractive();
            }
        } else if ("debug".equals(mode)) {
            command = this.controlData.getSubmitBatchDebug();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.controlData.getSubmitInteractiveDebug();
            }
        }
        if (command == null) {
            throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.MissingRunCommandsError) + " " + uuid + " " + mode), null);
        }
        return this.runCommand(uuid, command, jobMode, configuration, mode, true);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public boolean getAppendEnv() {
        return this.appendLaunchEnv;
    }

    @Override
    public ResourceManagerData getConfiguration() {
        return this.configData;
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    public String getControlId() {
        return this.fControlId;
    }

    @Override
    public IVariableMap getEnvironment() {
        return this.getRMVariableMap();
    }

    private IEnvManagerConfig getEnvManagerConfig(ILaunchConfiguration configuration) {
        try {
            EnvManagerProjectProperties projectProperties;
            IProject project;
            String projectName = configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
            if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && (projectProperties = new EnvManagerProjectProperties(project)).isEnvMgmtEnabled()) {
                return projectProperties;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    @Override
    public synchronized ICommandJob getInteractiveJob() {
        return this.interactiveJob;
    }

    public IJobStatus getJobStatus(String jobId, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.resourceManagerIsActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_resourceManagerNotStarted, null);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
            if (status != null) {
                if ("COMPLETED".equals(status.getState())) {
                    status = this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
                    if (status != null && status.stateChanged()) {
                        this.jobStateChanged(jobId, status);
                    }
                    ICommandJobStatus iCommandJobStatus = status;
                    return iCommandJobStatus;
                }
                if (!force) {
                    long now = System.currentTimeMillis();
                    long lapse = now - status.getLastUpdateRequest();
                    if (lapse < 30000L) {
                        ICommandJobStatus iCommandJobStatus = status;
                        return iCommandJobStatus;
                    }
                    status.setUpdateRequestTime(now);
                }
            }
            String state = status == null ? "UNDETERMINED" : status.getStateDetail();
            try {
                AttributeType a = this.getRMVariableMap().get(jobId);
                CommandType job = this.controlData.getGetJobStatus();
                if (job != null && this.resourceManagerIsActive() && !progress.isCanceled()) {
                    this.pinTable.pin(jobId);
                    AttributeType tmp = null;
                    if (a == null) {
                        tmp = new AttributeType();
                        tmp.setVisible(Boolean.valueOf(false));
                        tmp.setName(jobId);
                        this.getRMVariableMap().put(jobId, tmp);
                    }
                    this.runCommand(jobId, job, CommandJob.JobMode.STATUS, null, "run", true);
                    if (tmp != null) {
                        a = this.getRMVariableMap().remove(jobId);
                    }
                }
                if (a != null) {
                    state = String.valueOf(a.getValue());
                }
            }
            finally {
                this.pinTable.release(jobId);
            }
            if (status == null) {
                status = new CommandJobStatus(jobId, state, null, this);
                status.setOwner(this.getRMVariableMap().getString("${ptp_rm:control.user.name#value}"));
                this.jobStatusMap.addJobStatus(jobId, status);
            } else {
                status.setState(state);
            }
            if (progress.isCanceled()) {
                status.setState("UNDETERMINED");
                this.jobStateChanged(jobId, status);
                ICommandJobStatus iCommandJobStatus = status;
                return iCommandJobStatus;
            }
            if ("COMPLETED".equals(state)) {
                this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
            }
            if (status.stateChanged()) {
                this.jobStateChanged(jobId, status);
            }
            ICommandJobStatus iCommandJobStatus = status;
            return iCommandJobStatus;
        }
        catch (CoreException ce) {
            throw ce;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IJobStatus getJobStatus(String jobId, IProgressMonitor monitor) throws CoreException {
        return this.getJobStatus(jobId, false, monitor);
    }

    @Override
    public Map<String, String> getLaunchEnv() {
        return this.launchEnv;
    }

    private IRemoteConnection getRemoteConnection(IProgressMonitor monitor) {
        IRemoteServices rsrv = this.getRemoteServices(monitor);
        if (rsrv == null) {
            return null;
        }
        IRemoteConnectionManager connMgr = rsrv.getConnectionManager();
        if (connMgr == null) {
            return null;
        }
        return connMgr.getConnection(this.connectionName);
    }

    private IRemoteServices getRemoteServices(IProgressMonitor monitor) {
        return PTPRemoteCorePlugin.getDefault().getRemoteServices(this.servicesId, monitor);
    }

    @Override
    public String getRemoteServicesId() {
        return this.servicesId;
    }

    private RMVariableMap getRMVariableMap() {
        if (this.rmVarMap == null) {
            this.rmVarMap = new RMVariableMap();
        }
        if (!this.rmVarMap.isInitialized()) {
            JAXBInitializationUtils.initializeMap((ResourceManagerData)this.configData, (IVariableMap)this.rmVarMap);
        }
        return this.rmVarMap;
    }

    @Override
    public ICommandJobStatusMap getStatusMap() {
        return this.jobStatusMap;
    }

    @Override
    public void initialize() throws CoreException {
        try {
            SiteType site;
            this.realizeRMDataFromXML();
            this.controlData = this.configData.getControlData();
            if (this.servicesId == null && this.connectionName == null && (site = this.configData.getSiteData()) != null) {
                this.servicesId = site.getRemoteServices();
                if (this.servicesId == null) {
                    this.servicesId = "org.eclipse.ptp.remote.RemoteTools";
                }
                this.connectionName = site.getConnectionName();
            }
            if (this.servicesId == null || this.connectionName == null) {
                throw new Throwable(Messages.LaunchController_missingServicesOrConnectionName);
            }
            this.fControlId = LaunchControllerManager.generateControlId(this.servicesId, this.connectionName, this.configData.getName());
        }
        catch (Throwable t) {
            throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
        }
        this.isInitialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void jobStateChanged(String jobId, IJobStatus status) {
        IPJob job = ModelManager.getInstance().getUniverse().getJob(status);
        if (job != null && status.getState().equals("COMPLETED")) {
            ((EnumeratedAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getStateAttributeDefinition())).setValue((Enum)JobAttributes.State.COMPLETED);
        }
        JobManager.getInstance().fireJobChanged(status);
    }

    private void maybeAddManagedFileForScript(List<ManagedFilesType> lists, String stagingLocation, boolean delete) {
        ManagedFilesType files = null;
        if (stagingLocation == null) {
            stagingLocation = ".eclipsesettings";
        }
        for (ManagedFilesType f : lists) {
            if (!stagingLocation.equals(f.getFileStagingLocation())) continue;
            files = f;
            break;
        }
        AttributeType scriptVar = this.getRMVariableMap().get("script");
        AttributeType scriptPathVar = this.getRMVariableMap().get("script_path");
        if (scriptVar != null || scriptPathVar != null) {
            if (files == null) {
                files = new ManagedFilesType();
                files.setFileStagingLocation(stagingLocation);
                lists.add(files);
            }
            List fileList = files.getFile();
            ManagedFileType scriptFile = null;
            if (!fileList.isEmpty()) {
                for (ManagedFileType f : fileList) {
                    if (!f.getName().equals("managed_file_for_script")) continue;
                    scriptFile = f;
                    break;
                }
            }
            if (scriptFile == null) {
                scriptFile = new ManagedFileType();
                scriptFile.setName("managed_file_for_script");
                fileList.add(scriptFile);
            }
            scriptFile.setResolveContents(Boolean.valueOf(false));
            scriptFile.setUniqueIdPrefix(Boolean.valueOf(true));
            if (scriptPathVar != null) {
                scriptFile.setPath(String.valueOf(scriptPathVar.getValue()));
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(false));
            } else {
                scriptFile.setContents("${ptp_rm:script#value}");
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(true));
            }
            scriptFile.setDeleteTargetAfterUse(Boolean.valueOf(delete));
        }
    }

    private void maybeCleanupManagedFiles(String uuid, List<ManagedFilesType> lists) throws CoreException {
        if (lists == null || lists.isEmpty()) {
            return;
        }
        for (ManagedFilesType files : lists) {
            if (files.getFile().isEmpty()) continue;
            ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
            job.setOperation(ManagedFilesJob.Operation.DELETE);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean maybeHandleScript(String uuid, ScriptType script, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            AttributeType a = this.getRMVariableMap().get("script_path");
            if (a != null && a.getValue() != null) {
                return false;
            }
            if (script == null) {
                return false;
            }
            IRemoteConnection conn = this.getRemoteConnection((IProgressMonitor)progress.newChild(5));
            if (conn == null) return false;
            this.getRMVariableMap().setEnvManagerFromConnection(conn);
            ScriptHandler job = new ScriptHandler(uuid, script, this.getRMVariableMap(), this.launchEnv, false);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            boolean bl = script.isDeleteAfterSubmit();
            return bl;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean maybeKillInteractive(String jobId) {
        ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
        boolean killed = false;
        if (status != null) {
            killed = status.cancel();
        }
        return killed;
    }

    private boolean maybeTransferManagedFiles(String uuid, List<ManagedFilesType> lists) throws CoreException {
        if (lists == null || lists.isEmpty()) {
            return true;
        }
        for (ManagedFilesType files : lists) {
            if (files.getFile().isEmpty()) continue;
            ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
            job.setOperation(ManagedFilesJob.Operation.COPY);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            if (job.getSuccess()) continue;
            return false;
        }
        return true;
    }

    private void maybeUpdateServer(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IRemoteConnection conn = this.fRemoteServicesDelegate.getRemoteConnection();
            LMLDAServer server = (LMLDAServer)RemoteServerManager.getServer((String)LMLDAServer.SERVER_ID, (IRemoteConnection)conn);
            server.setWorkDir(new Path(conn.getWorkingDirectory()).append(".eclipsesettings").toString());
            try {
                server.updateServer((IProgressMonitor)progress.newChild(100));
            }
            catch (IOException e) {
                throw CoreExceptionUtils.newException((String)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void realizeRMDataFromXML() throws CoreException {
        if (this.configURL != null) {
            try {
                String configXML = JAXBInitializationUtils.getRMConfigurationXML((URL)new URL(this.configURL));
                this.configData = JAXBInitializationUtils.initializeRMData((String)configXML);
            }
            catch (Exception e) {
                throw CoreExceptionUtils.newException((String)e.getLocalizedMessage(), (Throwable)e.getCause());
            }
        }
    }

    private boolean resourceManagerIsActive() {
        return this.isActive;
    }

    @Override
    public Object runActionCommand(String action, String resetValue, ILaunchConfiguration configuration) throws CoreException {
        if (!this.resourceManagerIsActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_resourceManagerNotStarted, null);
        }
        this.updateAttributeValues(configuration, "run", null);
        AttributeType changedValue = null;
        if (resetValue != null) {
            changedValue = this.getRMVariableMap().get(resetValue);
            changedValue.setValue(null);
        }
        CommandType command = null;
        for (CommandType cmd : this.controlData.getButtonAction()) {
            if (!cmd.getName().equals(action)) continue;
            command = cmd;
            break;
        }
        if (command == null) {
            for (CommandType cmd : this.controlData.getStartUpCommand()) {
                if (!cmd.getName().equals(action)) continue;
                command = cmd;
                break;
            }
        }
        if (command == null) {
            for (CommandType cmd : this.controlData.getShutDownCommand()) {
                if (!cmd.getName().equals(action)) continue;
                command = cmd;
                break;
            }
        }
        if (command != null) {
            this.runCommand(null, command, CommandJob.JobMode.INTERACTIVE, null, "run", true);
        }
        return changedValue;
    }

    private ICommandJob runCommand(String uuid, CommandType command, CommandJob.JobMode jobMode, ILaunchConfiguration configuration, String launchMode, boolean join) throws CoreException {
        if (command == null) {
            throw CoreExceptionUtils.newException((String)Messages.RMNoSuchCommandError, null);
        }
        CommandJob job = new CommandJob(uuid, command, jobMode, this, configuration, launchMode);
        ((Job)job).setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        if (join) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!command.isIgnoreExitStatus()) {
            this.checkJobForError(job);
        }
        return job;
    }

    private void runCommands(List<CommandType> cmds) throws CoreException {
        for (CommandType cmd : cmds) {
            this.runCommand(null, cmd, CommandJob.JobMode.INTERACTIVE, null, "run", true);
        }
    }

    @Override
    public void setConnectionName(String connName) {
        this.connectionName = connName;
    }

    private void setFixedConfigurationProperties(IRemoteConnection rc) throws CoreException {
        if (rc != null) {
            this.getRMVariableMap().maybeAddAttribute("control.user.name", rc.getUsername(), false);
            this.getRMVariableMap().maybeAddAttribute("control.address", rc.getAddress(), false);
            this.getRMVariableMap().maybeAddAttribute("control.working.dir", rc.getWorkingDirectory(), false);
            this.getRMVariableMap().maybeAddAttribute("directory", rc.getWorkingDirectory(), false);
            this.getRMVariableMap().maybeAddAttribute("ptpDirectory", new Path(rc.getWorkingDirectory()).append(".eclipsesettings").toString(), false);
        }
    }

    @Override
    public synchronized void setInteractiveJob(ICommandJob interactiveJob) {
        this.interactiveJob = interactiveJob;
    }

    @Override
    public void setRemoteServicesId(String id) {
        this.servicesId = id;
    }

    @Override
    public void setRMConfigurationURL(URL url) {
        if (url != null) {
            this.configURL = url.toExternalForm();
        }
    }

    @Override
    public void start(IProgressMonitor monitor) throws CoreException {
        if (!this.isActive) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
            try {
                try {
                    if (!this.isInitialized) {
                        this.initialize();
                    }
                    this.fRemoteServicesDelegate = RemoteServicesDelegate.getDelegate((String)this.servicesId, (String)this.connectionName, (IProgressMonitor)progress.newChild(50));
                    IRemoteConnection conn = this.fRemoteServicesDelegate.getRemoteConnection();
                    if (conn != null) {
                        this.checkConnection(conn, progress);
                        conn.addConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
                    }
                    this.setFixedConfigurationProperties(conn);
                    this.addConnectionPropertyAttributes(conn);
                    this.appendLaunchEnv = true;
                    this.jobStatusMap = new JobStatusMap(this);
                    ((Thread)((Object)this.jobStatusMap)).start();
                    List onStartUp = this.controlData.getStartUpCommand();
                    this.runCommands(onStartUp);
                    this.isActive = true;
                }
                catch (CoreException ce) {
                    throw ce;
                }
                catch (Throwable t) {
                    throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws CoreException {
        if (this.isActive) {
            String iJobId = null;
            LaunchController launchController = this;
            synchronized (launchController) {
                ICommandJobStatus status;
                if (this.interactiveJob != null && (status = this.interactiveJob.getJobStatus()) != null) {
                    iJobId = status.getJobId();
                }
            }
            this.control(iJobId, "TERMINATE", null);
            List onShutDown = this.controlData.getShutDownCommand();
            this.runCommands(onShutDown);
            if (this.rmVarMap != null) {
                this.rmVarMap.clear();
            }
            this.jobStatusMap.halt();
            IRemoteConnection conn = this.fRemoteServicesDelegate.getRemoteConnection();
            if (conn != null) {
                conn.removeConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
            }
            this.isActive = false;
        }
    }

    public String submitJob(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String uuid = UUID.randomUUID().toString();
        if (!this.resourceManagerIsActive()) {
            throw CoreExceptionUtils.newException((String)Messages.LaunchController_resourceManagerNotStarted, null);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Object status;
            String jobId = null;
            AttributeType a = new AttributeType();
            a.setVisible(Boolean.valueOf(false));
            this.getRMVariableMap().put(uuid, a);
            this.updateAttributeValues(configuration, mode, (IProgressMonitor)progress.newChild(5));
            ScriptType script = this.controlData.getScript();
            boolean delScript = this.maybeHandleScript(uuid, script, (IProgressMonitor)progress.newChild(5));
            this.worked((IProgressMonitor)progress, 20);
            List files = this.controlData.getManagedFiles();
            if (script != null) {
                this.maybeAddManagedFileForScript(files, script.getFileStagingLocation(), delScript);
            }
            this.worked((IProgressMonitor)progress, 5);
            if (!this.maybeTransferManagedFiles(uuid, files)) {
                throw CoreExceptionUtils.newException((String)Messages.CannotCompleteSubmitFailedStaging, null);
            }
            this.worked((IProgressMonitor)progress, 20);
            this.maybeUpdateServer((IProgressMonitor)progress.newChild(10));
            ICommandJob job = null;
            try {
                job = this.doJobSubmitCommand(uuid, configuration, mode);
                status = job.getRunStatus();
                if (status != null && status.getSeverity() == 8) {
                    throw CoreExceptionUtils.newException((String)Messages.OperationWasCancelled, null);
                }
                this.worked((IProgressMonitor)progress, 40);
            }
            finally {
                this.maybeCleanupManagedFiles(uuid, files);
                this.worked((IProgressMonitor)progress, 5);
            }
            status = job.getJobStatus();
            if (this.interactiveJob != null && this.interactiveJob.getJobStatus() == status && this.interactiveJob != job) {
                String string = status.getJobId();
                return string;
            }
            this.getRMVariableMap().remove(uuid);
            jobId = a.getName();
            if (jobId == null) {
                status = new CommandJobStatus(uuid, "CANCELED", null, this);
                status.setOwner(this.getRMVariableMap().getString("${ptp_rm:control.user.name#value}"));
                String string = status.getJobId();
                return string;
            }
            this.jobStatusMap.addJobStatus(status.getJobId(), (ICommandJobStatus)status);
            status.setLaunchConfig(configuration);
            this.worked((IProgressMonitor)progress, 5);
            this.getRMVariableMap().remove("script_path");
            this.getRMVariableMap().remove("script");
            String string = status.getJobId();
            return string;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void updateAttributeValues(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IEnvManager envManager;
        IEnvManagerConfig envMgrConfig;
        AttributeType a;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        this.getRMVariableMap().maybeAddAttribute("launchMode", mode, false);
        Map<String, Object> lcattr = RMVariableMap.getValidAttributes(configuration);
        for (String key : lcattr.keySet()) {
            Object value = lcattr.get(key);
            AttributeType target = this.getRMVariableMap().get(key.toString());
            if (target == null) continue;
            target.setValue(value);
        }
        progress.worked(10);
        for (String key : this.getRMVariableMap().getAttributes().keySet()) {
            AttributeType target;
            if (lcattr.containsKey(key) || !(target = this.getRMVariableMap().get(key.toString())).isVisible()) continue;
            target.setValue(null);
        }
        progress.worked(10);
        this.getRMVariableMap().overwrite("script_path", "script_path", lcattr);
        this.getRMVariableMap().overwrite("executablePath", "executablePath", lcattr);
        this.getRMVariableMap().overwrite("executableDirectory", "executableDirectory", lcattr);
        this.getRMVariableMap().overwrite("progArgs", "progArgs", lcattr);
        this.getRMVariableMap().overwrite("debuggerExecutablePath", "debuggerExecutablePath", lcattr);
        this.getRMVariableMap().overwrite("debuggerId", "debuggerId", lcattr);
        this.getRMVariableMap().overwrite("debuggerLauncher", "debuggerLauncher", lcattr);
        String attr = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", null);
        if (attr != null) {
            a = this.getEnvironment().get("debuggerArgs");
            if (a == null) {
                a = new AttributeType();
                this.getEnvironment().put("debuggerArgs", a);
            }
            a.setValue((Object)attr);
        }
        if ((attr = configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null)) == null && (a = this.getEnvironment().get("executableDirectory")) != null) {
            attr = (String)a.getValue();
        }
        if (attr != null) {
            a = this.getEnvironment().get("directory");
            if (a == null) {
                a = new AttributeType();
                this.getEnvironment().put("directory", a);
            }
            a.setValue((Object)attr);
        }
        if ((envMgrConfig = this.getEnvManagerConfig(configuration)) != null && (envManager = EnvManagerRegistry.getEnvManager((IProgressMonitor)progress.newChild(1), (IRemoteConnection)this.fRemoteServicesDelegate.getRemoteConnection())) != null) {
            String emsStr = envManager.getBashConcatenation("\n", false, envMgrConfig, null);
            AttributeType a2 = this.getEnvironment().get("ems");
            if (a2 == null) {
                a2 = new AttributeType();
                this.getEnvironment().put("ems", a2);
            }
            a2.setValue((Object)emsStr);
        }
        this.launchEnv.clear();
        this.launchEnv.putAll(configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.launchEnv));
        this.appendLaunchEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, this.appendLaunchEnv);
    }

    private void worked(IProgressMonitor monitor, int units) {
        if (monitor != null) {
            if (units == 0) {
                monitor.done();
            } else {
                monitor.worked(units);
            }
        }
    }

    private class ConnectionChangeListener
    implements IRemoteConnectionChangeListener {
        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            if (event.getType() == 4 || event.getType() == 1) {
                try {
                    LaunchController.this.stop();
                }
                catch (CoreException e) {
                    JAXBControlCorePlugin.log(e);
                }
            }
        }
    }
}

