/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.runnable;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatusMap;

public class JobStatusMap
extends Thread
implements ICommandJobStatusMap {
    private final IJobControl control;
    private final Map<String, ICommandJobStatus> map;
    private boolean running = false;

    public JobStatusMap(IJobControl control) {
        this.control = control;
        this.map = new HashMap<String, ICommandJobStatus>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJobStatus(String jobId, ICommandJobStatus status) {
        boolean notifyAdd = false;
        boolean exists = false;
        Map<String, ICommandJobStatus> map = this.map;
        synchronized (map) {
            exists = this.map.containsKey(jobId);
            notifyAdd = !exists && !"UNDETERMINED".equals(status.getState());
            this.map.put(jobId, status);
        }
        if (notifyAdd) {
            try {
                status.initialize(jobId);
            }
            catch (CoreException e) {
                JAXBControlCorePlugin.log(e);
            }
            JobManager.getInstance().fireJobAdded((IJobStatus)status);
        }
        return !exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommandJobStatus cancel(String jobId) {
        ICommandJobStatus status = null;
        Map<String, ICommandJobStatus> map = this.map;
        synchronized (map) {
            status = this.map.get(jobId);
            if (status != null) {
                status.cancel();
                status.setState("CANCELED");
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommandJobStatus getStatus(String jobId) {
        ICommandJobStatus status = null;
        Map<String, ICommandJobStatus> map = this.map;
        synchronized (map) {
            status = this.map.get(jobId);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        Map<String, ICommandJobStatus> map = this.map;
        synchronized (map) {
            this.running = false;
            this.map.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        toPrune = new HashMap<String, String>();
        var2_2 = this.map;
        synchronized (var2_2) {
            this.running = true;
            // MONITOREXIT @DISABLED, blocks:[0, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl36
        }
        do {
            var2_2 = this.map;
            synchronized (var2_2) {
                try {
                    this.map.wait(0x6DDD00L);
                }
                catch (InterruptedException v1) {}
                for (String jobId : this.map.keySet()) {
                    status = null;
                    try {
                        status = this.control.getJobStatus(jobId, true, null);
                    }
                    catch (CoreException v2) {}
                    if (status != null && !"COMPLETED".equals(status.getState())) continue;
                    toPrune.put(jobId, jobId);
                }
                for (String jobId : toPrune.keySet()) {
                    this.remove(jobId, true, null);
                }
                toPrune.clear();
            }
lbl36:
            // 2 sources

        } while (this.isRunning());
        var2_2 = this.map;
        synchronized (var2_2) {
            for (String jobId : this.map.keySet()) {
                this.doTerminated(jobId, false, null);
            }
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommandJobStatus terminated(String jobId, IProgressMonitor monitor) {
        ICommandJobStatus status = null;
        Map<String, ICommandJobStatus> map = this.map;
        synchronized (map) {
            status = this.doTerminated(jobId, true, monitor);
        }
        return status;
    }

    private ICommandJobStatus doTerminated(String jobId, boolean block, IProgressMonitor monitor) {
        ICommandJobStatus status = this.map.get(jobId);
        if (status != null) {
            String d = status.getStateDetail();
            if (!"JOB_OUTERR_READY".equals(d)) {
                boolean bl = block = block && !"CANCELED".equals(d) && !"FAILED".equals(d);
                if (!status.isInteractive()) {
                    if (block) {
                        status.maybeWaitForHandlerFiles(5, monitor);
                    } else {
                        status.maybeWaitForHandlerFiles(0, monitor);
                    }
                }
            }
            status.cancel();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        boolean b = false;
        Map<String, ICommandJobStatus> map = this.map;
        synchronized (map) {
            b = this.running;
        }
        return b;
    }

    private ICommandJobStatus remove(String jobId, boolean block, IProgressMonitor monitor) {
        ICommandJobStatus status = this.doTerminated(jobId, block, monitor);
        this.map.remove(jobId);
        return status;
    }
}

