/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.util.ArrayList;
import java.util.BitSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.debug.core.IPBreakpointManager;
import org.eclipse.ptp.debug.core.IPLocationSetManager;
import org.eclipse.ptp.debug.core.IPMemoryManager;
import org.eclipse.ptp.debug.core.IPRegisterManager;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.IPSetManager;
import org.eclipse.ptp.debug.core.IPSignalManager;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.event.IPDebugInfo;
import org.eclipse.ptp.debug.core.event.PDebugErrorInfo;
import org.eclipse.ptp.debug.core.event.PDebugEvent;
import org.eclipse.ptp.debug.core.event.PDebugExitInfo;
import org.eclipse.ptp.debug.core.event.PDebugInfo;
import org.eclipse.ptp.debug.core.event.PDebugSuspendInfo;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIBreakpointInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIConnectedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDICreatedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDestroyedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDisconnectedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEndSteppingRangeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIErrorEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIErrorInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.event.IPDIExitInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIFunctionFinishedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDILocationReachedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIMemoryBlockInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIOutputEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIRegisterInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIRestartedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDISharedLibraryInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISignalInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIStartedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDISuspendedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIThreadInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIVariableInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointScopeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointTriggerInfo;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITaskManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocationBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.internal.core.PBreakpointManager;
import org.eclipse.ptp.debug.internal.core.PLocationSetManager;
import org.eclipse.ptp.debug.internal.core.PMemoryManager;
import org.eclipse.ptp.debug.internal.core.PRegisterManager;
import org.eclipse.ptp.debug.internal.core.PSetManager;
import org.eclipse.ptp.debug.internal.core.PSignalManager;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;

public class PSession
implements IPSession,
IPDIEventListener {
    private final IPDISession pdiSession;
    private final IPLaunch launch;
    private final IProject project;
    private final PSignalManager signalMgr;
    private final PBreakpointManager bptMgr;
    private final PMemoryManager memMgr;
    private final PRegisterManager regMgr;
    private final PSetManager setMgr;
    private final PLocationSetManager locMgr;

    public PSession(IPDISession pdiSession, IPLaunch launch, IProject project) {
        this.pdiSession = pdiSession;
        this.launch = launch;
        this.project = project;
        this.signalMgr = new PSignalManager(this);
        this.bptMgr = new PBreakpointManager(this);
        this.memMgr = new PMemoryManager(this);
        this.regMgr = new PRegisterManager(this);
        this.setMgr = new PSetManager(this);
        this.locMgr = new PLocationSetManager(this);
        this.getPDISession().getEventManager().addEventListener(this);
    }

    public void connectToDebugger(IProgressMonitor monitor, String app, String path, String cwd, String[] args) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        boolean failed = false;
        try {
            try {
                this.getPDISession().connectToDebugger((IProgressMonitor)progress.newChild(1), app, path, cwd, args);
            }
            catch (PDIException e) {
                failed = true;
                throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
        finally {
            if (failed || progress.isCanceled()) {
                this.dispose();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void createDebugTarget(TaskSet tasks, boolean refresh, boolean register) {
        if (this.isReady()) {
            int[] task_array;
            ArrayList<IPDITarget> targets = new ArrayList<IPDITarget>();
            int[] nArray = task_array = tasks.toArray();
            int n = task_array.length;
            int n2 = 0;
            while (n2 < n) {
                int task_id = nArray[n2];
                IPDITarget target = this.getPDISession().getTargetManager().addTarget(this.getTasks(task_id));
                if (target != null) {
                    targets.add(target);
                } else {
                    tasks.clear(task_id);
                }
                ++n2;
            }
            if (register) {
                this.getPDISession().getTaskManager().setRegisterTasks(true, tasks);
            }
            PTPDebugCorePlugin.getDebugModel().addNewDebugTargets(this.getLaunch(), tasks, targets.toArray(new IPDITarget[0]), refresh, false);
        }
    }

    public void deleteDebugTarget(TaskSet tasks, boolean refresh, boolean register) {
        int[] task_array;
        int[] nArray = task_array = tasks.toArray();
        int n = task_array.length;
        int n2 = 0;
        while (n2 < n) {
            int task_id = nArray[n2];
            if (!this.getPDISession().getTargetManager().removeTarget(this.getTasks(task_id))) {
                tasks.clear(task_id);
            }
            ++n2;
        }
        if (register) {
            this.getPDISession().getTaskManager().setRegisterTasks(false, tasks);
        }
        PTPDebugCorePlugin.getDebugModel().removeDebugTarget(this.getLaunch(), tasks, refresh);
    }

    public void deleteDebugTargets(boolean register) {
        if (this.isReady()) {
            TaskSet tasks = this.getPDISession().getTaskManager().getRegisteredTasks().copy();
            this.deleteDebugTarget(tasks, true, register);
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    public PDebugTarget findDebugTarget(TaskSet tasks) {
        return (PDebugTarget)this.launch.getDebugTarget(tasks);
    }

    public void fireDebugEvent(int type, int details, IPDebugInfo info) {
        PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this, type, details, info));
    }

    public void forceStoppedDebugger(boolean isError) {
        TaskSet tasks = this.getTasks();
        this.changeProcessState(tasks, ProcessAttributes.State.COMPLETED);
        PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this.getSession(), 8, 1024, this.getDebugInfo(tasks)));
        this.dispose(true);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPDISession.class)) {
            return this;
        }
        if (adapter.equals(PSignalManager.class)) {
            return this.getSignalManager();
        }
        return null;
    }

    public IPBreakpointManager getBreakpointManager() {
        return this.bptMgr;
    }

    public IPDebugInfo getDebugInfo(TaskSet eTasks) {
        IPDITaskManager taskMgr = this.getPDISession().getTaskManager();
        return new PDebugInfo(this.getLaunch(), eTasks, taskMgr.getRegisteredTasks(eTasks.copy()), taskMgr.getUnregisteredTasks(eTasks.copy()));
    }

    public IPLaunch getLaunch() {
        return this.launch;
    }

    public IPLocationSetManager getLocationSetManager() {
        return this.locMgr;
    }

    public IPMemoryManager getMemoryManager() {
        return this.memMgr;
    }

    public IPDISession getPDISession() {
        return this.pdiSession;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPRegisterManager getRegisterManager() {
        return this.regMgr;
    }

    public IPSession getSession() {
        return this;
    }

    public IPSetManager getSetManager() {
        return this.setMgr;
    }

    public IPSignalManager getSignalManager() {
        return this.signalMgr;
    }

    public TaskSet getTasks() {
        return this.getPDISession().getTasks();
    }

    public TaskSet getTasks(int id) {
        int max = this.getPDISession().getTotalTasks();
        TaskSet tasks = new TaskSet(max);
        if (id >= 0 && id <= max) {
            tasks.set(id);
        }
        return tasks;
    }

    public void handleDebugEvents(IPDIEvent[] events) {
        IPDIEvent[] iPDIEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIEvent event = iPDIEventArray[n2];
            if (event instanceof IPDIConnectedEvent) {
                PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this.getSession(), 4, 1024, this.getDebugInfo(event.getTasks())));
            } else if (event instanceof IPDIStartedEvent) {
                this.bptMgr.setInitialBreakpoints();
                boolean stopInMain = true;
                try {
                    stopInMain = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", false);
                }
                catch (CoreException coreException) {}
                try {
                    if (stopInMain) {
                        this.bptMgr.setStopInMain(this.getPDISession().getTasks());
                    }
                    this.getPDISession().start(this.getPDISession().getTasks());
                    this.getPDISession().setStatus(3);
                    PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this.getSession(), 16, 32, this.getDebugInfo(event.getTasks())));
                }
                catch (PDIException e) {
                    PDebugErrorInfo errInfo = new PDebugErrorInfo(this.getDebugInfo(event.getTasks()), Messages.PSession_1, e.getMessage(), 1000);
                    PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this, 64, 0, errInfo));
                }
            } else if (event instanceof IPDIDisconnectedEvent) {
                PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this.getSession(), 8, 1024, this.getDebugInfo(event.getTasks())));
                this.dispose();
            } else if (event instanceof IPDIChangedEvent) {
                this.fireChangeEvent((IPDIChangedEvent)event);
            } else if (event instanceof IPDICreatedEvent) {
                this.fireCreateEvent((IPDICreatedEvent)event);
            } else if (event instanceof IPDIDestroyedEvent) {
                this.fireDestroyEvent((IPDIDestroyedEvent)event);
            } else if (event instanceof IPDIErrorEvent) {
                this.fireErrorEvent((IPDIErrorEvent)event);
            } else if (!(event instanceof IPDIRestartedEvent)) {
                if (event instanceof IPDIResumedEvent) {
                    this.fireResumeEvent((IPDIResumedEvent)event);
                } else if (event instanceof IPDISuspendedEvent) {
                    try {
                        this.bptMgr.updatePendingBreakpoints();
                    }
                    catch (PDIException pDIException) {}
                    this.fireSuspendEvent((IPDISuspendedEvent)event);
                } else if (event instanceof IPDIOutputEvent) {
                    this.setProcessOutput(event.getTasks(), ((IPDIOutputEvent)event).getOutput());
                } else {
                    PDebugEvent debugEvent = new PDebugEvent(this, 0, 0, this.getDebugInfo(event.getTasks()));
                    PTPDebugCorePlugin.getDefault().fireDebugEvent(debugEvent);
                }
            }
            ++n2;
        }
    }

    public boolean isReady() {
        return this.getPDISession().getStatus() == 3;
    }

    public void reloadDebugTargets(TaskSet tasks, boolean refresh, boolean register) {
        if (this.isReady()) {
            TaskSet curRegTasks = this.getPDISession().getTaskManager().getRegisteredTasks(tasks.copy());
            TaskSet othRegTasks = this.getPDISession().getTaskManager().getRegisteredTasks().copy();
            othRegTasks.andNot(curRegTasks);
            this.deleteDebugTarget(othRegTasks, refresh, register);
            this.createDebugTarget(curRegTasks, refresh, register);
        }
    }

    private void changeProcessState(TaskSet tasks, ProcessAttributes.State state) {
        IPJob job = ModelManager.getInstance().getUniverse().getJob(this.getLaunch().getJobControl(), this.getLaunch().getJobId());
        if (job != null) {
            BitSet processIndices = new BitSet();
            int[] nArray = tasks.toArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int task = nArray[n2];
                processIndices.set(task);
                ++n2;
            }
            EnumeratedAttribute attr = ProcessAttributes.getStateAttributeDefinition().create((Enum)state);
            job.addProcessAttributes(processIndices, new AttributeManager((IAttribute)attr));
        }
    }

    private void dispose(final boolean force) {
        WorkspaceJob aJob = new WorkspaceJob(Messages.PSession_0){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                PSession.this.signalMgr.dispose(monitor);
                PSession.this.bptMgr.dispose(monitor);
                PSession.this.memMgr.dispose(monitor);
                PSession.this.regMgr.dispose(monitor);
                PSession.this.setMgr.dispose(monitor);
                PSession.this.locMgr.dispose(monitor);
                PSession.this.deleteDebugTargets(true);
                PSession.this.getPDISession().getEventManager().removeEventListener(PSession.this);
                PSession.this.getPDISession().shutdown(force);
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.schedule();
    }

    private void fireChangeEvent(IPDIChangedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo(event.getTasks());
        int detail = 0;
        IPDISessionObject reason = event.getReason();
        if (!(reason instanceof IPDIBreakpointInfo || reason instanceof IPDIMemoryBlockInfo || reason instanceof IPDISignalInfo)) {
            boolean cfr_ignored_0 = reason instanceof IPDIVariableInfo;
        }
        PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this, 16, detail, baseInfo));
    }

    private void fireCreateEvent(IPDICreatedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo(event.getTasks());
        int detail = 0;
        IPDISessionObject reason = event.getReason();
        if (!(reason instanceof IPDIBreakpointInfo || reason instanceof IPDIThreadInfo || reason instanceof IPDIMemoryBlockInfo || reason instanceof IPDIRegisterInfo || reason instanceof IPDISharedLibraryInfo)) {
            boolean cfr_ignored_0 = reason instanceof IPDIVariableInfo;
        }
        PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this, 4, detail, baseInfo));
    }

    private void fireDestroyEvent(IPDIDestroyedEvent event) {
        PDebugEvent debugEvent = null;
        IPDebugInfo baseInfo = this.getDebugInfo(event.getTasks());
        IPDISessionObject reason = event.getReason();
        if (!(reason instanceof IPDIBreakpointInfo)) {
            if (reason instanceof IPDIErrorInfo) {
                this.deleteDebugTarget(baseInfo.getAllRegisteredTasks().copy(), true, true);
                PDebugErrorInfo errInfo = new PDebugErrorInfo(baseInfo, ((IPDIErrorInfo)reason).getMessage(), ((IPDIErrorInfo)reason).getDetailMessage(), ((IPDIErrorInfo)reason).getCode());
                debugEvent = new PDebugEvent(this, 8, 64, errInfo);
                this.changeProcessState(event.getTasks(), ProcessAttributes.State.COMPLETED);
            } else if (reason instanceof IPDIExitInfo) {
                this.deleteDebugTarget(baseInfo.getAllRegisteredTasks().copy(), true, true);
                PDebugExitInfo exitInfo = new PDebugExitInfo(baseInfo, ((IPDIExitInfo)reason).getCode(), Messages.PSession_2, Messages.PSession_3);
                debugEvent = new PDebugEvent(this, 8, 32, exitInfo);
                this.changeProcessState(event.getTasks(), ProcessAttributes.State.COMPLETED);
            } else if (reason instanceof IPDISignalInfo) {
                this.deleteDebugTarget(baseInfo.getAllRegisteredTasks().copy(), true, true);
                PDebugExitInfo exitInfo = new PDebugExitInfo(baseInfo, 0, ((IPDISignalInfo)reason).getDescription(), ((IPDISignalInfo)reason).getName());
                debugEvent = new PDebugEvent(this, 8, 32, exitInfo);
                this.changeProcessState(event.getTasks(), ProcessAttributes.State.COMPLETED);
            } else if (!(reason instanceof IPDISharedLibraryInfo || reason instanceof IPDIThreadInfo || reason instanceof IPDIVariableInfo)) {
                debugEvent = new PDebugEvent(this, 8, 0, baseInfo);
            }
        }
        PTPDebugCorePlugin.getDefault().fireDebugEvent(debugEvent);
    }

    private void fireErrorEvent(IPDIErrorEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo(event.getTasks());
        int detail = 0;
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDIErrorInfo) {
            int code = ((IPDIErrorInfo)reason).getCode();
            switch (code) {
                case 2: {
                    detail = 4;
                    this.changeProcessState(event.getTasks(), ProcessAttributes.State.COMPLETED);
                    break;
                }
                case 1: {
                    detail = 2;
                    break;
                }
                case 0: 
                case 3: {
                    detail = 1;
                }
            }
            PDebugErrorInfo errInfo = new PDebugErrorInfo(baseInfo, ((IPDIErrorInfo)reason).getMessage(), ((IPDIErrorInfo)reason).getDetailMessage(), ((IPDIErrorInfo)reason).getCode());
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this, 64, detail, errInfo));
        } else {
            PDebugErrorInfo errInfo = new PDebugErrorInfo(baseInfo, Messages.PSession_4, Messages.PSession_5, 1000);
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this, 64, 0, errInfo));
        }
    }

    private void fireResumeEvent(IPDIResumedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo(event.getTasks());
        int detail = 0;
        switch (event.getType()) {
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        this.changeProcessState(event.getTasks(), ProcessAttributes.State.RUNNING);
        PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this, 1, detail, baseInfo));
    }

    private void fireSuspendEvent(IPDISuspendedEvent event) {
        IPDebugInfo baseInfo = this.getDebugInfo(event.getTasks());
        int detail = 0;
        int lineNumber = 0;
        int level = event.getLevel();
        int depth = event.getDepth();
        String fileName = "";
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDIBreakpointInfo) {
            IPDILocator locator;
            IPDIBreakpoint bpt = ((IPDIBreakpointInfo)reason).getBreakpoint();
            if (bpt instanceof IPDILocationBreakpoint && (locator = ((IPDILocationBreakpoint)bpt).getLocator()) != null) {
                lineNumber = locator.getLineNumber();
                fileName = String.valueOf(fileName) + locator.getFile();
                detail = 16;
            }
        } else if (reason instanceof IPDIEndSteppingRangeInfo) {
            IPDILocator locator = ((IPDIEndSteppingRangeInfo)reason).getLocator();
            if (locator != null) {
                lineNumber = locator.getLineNumber();
                fileName = String.valueOf(fileName) + locator.getFile();
                detail = 8;
            }
        } else if (reason instanceof IPDILocationReachedInfo) {
            IPDILocator locator = ((IPDILocationReachedInfo)reason).getLocator();
            if (locator != null) {
                lineNumber = locator.getLineNumber();
                fileName = String.valueOf(fileName) + locator.getFile();
                detail = 32;
            }
        } else if (reason instanceof IPDISignalInfo) {
            IPDILocator locator = ((IPDISignalInfo)reason).getLocator();
            if (locator != null) {
                lineNumber = locator.getLineNumber();
                fileName = String.valueOf(fileName) + locator.getFile();
                detail = 32;
            }
        } else if (!(reason instanceof IPDIFunctionFinishedInfo || reason instanceof IPDISharedLibraryInfo || reason instanceof IPDIWatchpointScopeInfo)) {
            boolean cfr_ignored_0 = reason instanceof IPDIWatchpointTriggerInfo;
        }
        this.changeProcessState(event.getTasks(), ProcessAttributes.State.SUSPENDED);
        PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(this.getSession(), 2, detail, new PDebugSuspendInfo(baseInfo, fileName, lineNumber, level, depth)));
    }

    private void setProcessOutput(TaskSet tasks, String output) {
        IPJob job = ModelManager.getInstance().getUniverse().getJob(this.getLaunch().getJobControl(), this.getLaunch().getJobId());
        if (job != null) {
            BitSet processIndices = new BitSet();
            int[] nArray = tasks.toArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int task = nArray[n2];
                processIndices.set(task);
                ++n2;
            }
            StringAttribute attr = ProcessAttributes.getStdoutAttributeDefinition().create(output);
            job.addProcessAttributes(processIndices, new AttributeManager((IAttribute)attr));
        }
    }
}

