/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlStateRuleType;
import org.eclipse.swt.widgets.Button;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlStateRule {
    private ControlStateRule not;
    private List<ControlStateRule> and;
    private List<ControlStateRule> or;
    private Button button;
    private boolean selected;
    private String attribute;
    private String value;
    private final IVariableMap varMap;

    public ControlStateRule(ControlStateRuleType rule, Map<String, Button> map, Set<Button> sources, IVariableMap varMap) throws Throwable {
        this.varMap = varMap;
        ControlStateRuleType.Not not = rule.getNot();
        if (not != null) {
            this.not = new ControlStateRule(not.getRule(), map, sources, varMap);
        } else {
            ControlStateRuleType.And and = rule.getAnd();
            if (and != null) {
                List list = and.getRule();
                if (!list.isEmpty()) {
                    this.and = new ArrayList<ControlStateRule>();
                    for (ControlStateRuleType t : list) {
                        this.and.add(new ControlStateRule(t, map, sources, varMap));
                    }
                }
            } else {
                ControlStateRuleType.Or or = rule.getOr();
                if (or != null) {
                    List list = or.getRule();
                    if (!list.isEmpty()) {
                        this.or = new ArrayList<ControlStateRule>();
                        for (ControlStateRuleType t : list) {
                            this.or.add(new ControlStateRule(t, map, sources, varMap));
                        }
                    }
                } else if (rule.getButton() != null) {
                    this.button = map.get(rule.getButton());
                    if (this.button == null) {
                        throw new Throwable(String.valueOf(Messages.ControlStateRule_0) + rule.getButton());
                    }
                    this.selected = rule.isSelected();
                    sources.add(this.button);
                } else if (rule.getAttribute() != null) {
                    this.attribute = rule.getAttribute();
                    if (this.attribute == null) {
                        throw new Throwable(String.valueOf(Messages.ControlStateRule_1) + rule.getAttribute());
                    }
                    this.value = rule.getValue();
                    if (this.value == null) {
                        throw new Throwable(String.valueOf(Messages.ControlStateRule_2) + rule.getAttribute());
                    }
                }
            }
        }
    }

    public boolean evaluate() {
        if (this.not != null) {
            return !this.not.evaluate();
        }
        if (this.and != null) {
            for (ControlStateRule rule : this.and) {
                if (rule.evaluate()) continue;
                return false;
            }
            return true;
        }
        if (this.or != null) {
            for (ControlStateRule rule : this.or) {
                if (!rule.evaluate()) continue;
                return true;
            }
            return false;
        }
        if (this.attribute != null) {
            AttributeType attr = this.varMap.get(this.attribute);
            String attrVal = null;
            if (attr != null && attr.getValue() != null) {
                attrVal = attr.getValue().toString();
            }
            return this.value.equals(attrVal);
        }
        return this.selected == this.button.getSelection();
    }
}

