/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.remotemake;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.ptp.internal.rdt.core.remotemake.Messages;
import org.eclipse.ptp.remote.core.IRemoteProcess;

public class RemoteProcessClosure {
    protected static int fCounter = 0;
    protected IRemoteProcess fProcess;
    protected OutputStream fOutput;
    protected OutputStream fError;
    protected ReaderThread fOutputReader;
    protected ReaderThread fErrorReader;

    public RemoteProcessClosure(IRemoteProcess process, OutputStream outputStream, OutputStream errorStream) {
        this.fProcess = process;
        this.fOutput = outputStream;
        this.fError = errorStream;
    }

    public void runNonBlocking() {
        ThreadGroup group = new ThreadGroup("CBuilder" + fCounter++);
        InputStream stdin = this.fProcess.getInputStream();
        InputStream stderr = this.fProcess.getErrorStream();
        this.fOutputReader = new ReaderThread(group, "OutputReader", stdin, this.fOutput, false, this.fProcess);
        this.fErrorReader = new ReaderThread(group, "ErrorReader", stderr, this.fError, true, this.fProcess);
        this.fOutputReader.start();
        this.fErrorReader.start();
    }

    public void runBlocking() {
        this.runNonBlocking();
        boolean finished = false;
        while (!finished) {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.fProcess.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fProcess = null;
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    public boolean isAlive() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
            this.fOutputReader.close();
            this.fErrorReader.close();
            this.fOutputReader = null;
            this.fErrorReader = null;
        }
        return false;
    }

    public boolean isRunning() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
        }
        return false;
    }

    public void terminate() {
        if (this.fProcess != null) {
            this.fProcess.destroy();
            this.fProcess = null;
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    protected static class ReaderThread
    extends Thread {
        private InputStream fInputStream;
        private OutputStream fOutputStream;
        private boolean fFinished = false;
        private String lineSeparator;
        private boolean fIsErrorReader;
        private IRemoteProcess theProcess;

        public ReaderThread(ThreadGroup group, String name, InputStream in, OutputStream out, boolean isErrorReader, IRemoteProcess fProcess) {
            super(group, name);
            this.fOutputStream = out;
            this.fInputStream = in;
            this.fIsErrorReader = isErrorReader;
            this.theProcess = fProcess;
            this.setDaemon(true);
            this.lineSeparator = System.getProperty("line.separator");
        }

        public void run() {
            block27: {
                String lastLine = null;
                try {
                    try {
                        try {
                            String line;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
                            while ((line = reader.readLine()) != null) {
                                lastLine = line;
                                line = String.valueOf(line) + this.lineSeparator;
                                if (this.fOutputStream == null) continue;
                                this.fOutputStream.write(line.getBytes());
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                if (!this.fIsErrorReader && !lastLine.contains(Messages.RemoteProcessClosure_0)) {
                                    int exit_code = 0;
                                    try {
                                        exit_code = this.theProcess.waitFor();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    String message = MessageFormat.format(Messages.RemoteProcessClosure_1, exit_code);
                                    this.fOutputStream.write(message.getBytes());
                                }
                                if (this.fOutputStream != null) {
                                    this.fOutputStream.flush();
                                }
                                break block27;
                            }
                            catch (IOException iOException2) {}
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!this.fIsErrorReader && !lastLine.contains(Messages.RemoteProcessClosure_0)) {
                                int exit_code = 0;
                                try {
                                    exit_code = this.theProcess.waitFor();
                                }
                                catch (InterruptedException interruptedException) {}
                                String message = MessageFormat.format(Messages.RemoteProcessClosure_1, exit_code);
                                this.fOutputStream.write(message.getBytes());
                            }
                            if (this.fOutputStream != null) {
                                this.fOutputStream.flush();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (!this.fIsErrorReader && !lastLine.contains(Messages.RemoteProcessClosure_0)) {
                            int exit_code = 0;
                            try {
                                exit_code = this.theProcess.waitFor();
                            }
                            catch (InterruptedException interruptedException) {}
                            String message = MessageFormat.format(Messages.RemoteProcessClosure_1, exit_code);
                            this.fOutputStream.write(message.getBytes());
                        }
                        if (this.fOutputStream != null) {
                            this.fOutputStream.flush();
                        }
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    this.complete();
                }
            }
        }

        public synchronized boolean finished() {
            return this.fFinished;
        }

        public synchronized void waitFor() {
            while (!this.fFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void complete() {
            this.fFinished = true;
            this.notify();
        }

        public void close() {
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

