/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.git.core;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.git.core.GitRemoteSyncConnection;
import org.eclipse.ptp.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.services.core.ServiceProvider;

public class GitServiceProvider
extends ServiceProvider
implements ISyncServiceProvider {
    public static final String ID = "org.eclipse.ptp.rdt.sync.git.core.GitServiceProvider";
    private static final String GIT_LOCATION = "location";
    private static final String GIT_CONNECTION_NAME = "connectionName";
    private static final String GIT_SERVICES_ID = "servicesId";
    private String fLocation = null;
    private IRemoteConnection fConnection = null;
    private boolean hasBeenSynced = false;
    private static final ReentrantLock syncLock = new ReentrantLock();
    private Integer fWaitingThreadsCount = 0;
    private Integer syncTaskId = -1;
    private int finishedSyncTaskId = -1;
    private Map<ProjectAndScenario, GitRemoteSyncConnection> syncConnectionMap = Collections.synchronizedMap(new HashMap());

    public String getLocation() {
        if (this.fLocation == null) {
            this.fLocation = this.getString(GIT_LOCATION, null);
        }
        return this.fLocation;
    }

    public IRemoteConnection getRemoteConnection() {
        IRemoteServices services;
        String name;
        if (this.fConnection == null && (name = this.getString(GIT_CONNECTION_NAME, null)) != null && (services = this.getRemoteServices()) != null) {
            this.fConnection = services.getConnectionManager().getConnection(name);
        }
        return this.fConnection;
    }

    public IRemoteServices getRemoteServices() {
        String id = this.getString(GIT_SERVICES_ID, null);
        if (id != null) {
            return PTPRemoteCorePlugin.getDefault().getRemoteServices(id);
        }
        return null;
    }

    public boolean isConfigured() {
        return this.getLocation() != null && this.getRemoteConnection() != null;
    }

    public void setLocation(String location) {
        if (this.fLocation != null) {
            throw new RuntimeException(Messages.GSP_ChangeLocationError);
        }
        this.fLocation = location;
        this.putString(GIT_LOCATION, location);
    }

    public void setRemoteConnection(IRemoteConnection conn) {
        if (this.fConnection != null) {
            throw new RuntimeException(Messages.GSP_ChangeConnectionError);
        }
        this.fConnection = conn;
        this.putString(GIT_CONNECTION_NAME, conn.getName());
    }

    public void setRemoteServices(IRemoteServices services) {
        this.putString(GIT_SERVICES_ID, services.getId());
    }

    /*
     * Exception decompiling
     */
    public void synchronize(IProject project, BuildScenario buildScenario, IResourceDelta delta, SyncFileFilter fileFilter, IProgressMonitor monitor, EnumSet<SyncFlag> syncFlags) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized GitRemoteSyncConnection getSyncConnection(IProject project, BuildScenario buildScenario, SyncFileFilter fileFilter, IProgressMonitor monitor) throws RemoteSyncException {
        try {
            if (buildScenario.getSyncProvider() == null) {
                return null;
            }
            ProjectAndScenario pas = new ProjectAndScenario(project, buildScenario);
            if (!this.syncConnectionMap.containsKey(pas)) {
                try {
                    GitRemoteSyncConnection grsc = new GitRemoteSyncConnection(project, project.getLocation().toString(), buildScenario, fileFilter, monitor);
                    this.syncConnectionMap.put(pas, grsc);
                }
                catch (MissingConnectionException missingConnectionException) {
                    if (monitor != null) {
                        monitor.done();
                    }
                    return null;
                }
            }
            GitRemoteSyncConnection fSyncConnection = this.syncConnectionMap.get(pas);
            fSyncConnection.setFileFilter(fileFilter);
            GitRemoteSyncConnection gitRemoteSyncConnection = fSyncConnection;
            return gitRemoteSyncConnection;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public Set<IPath> getMergeConflictFiles(IProject project, BuildScenario buildScenario) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, buildScenario, SyncManager.getFileFilter((IProject)project), null);
        if (fSyncConnection == null) {
            return new HashSet<IPath>();
        }
        return fSyncConnection.getMergeConflictFiles();
    }

    public String[] getMergeConflictParts(IProject project, BuildScenario buildScenario, IFile file) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, buildScenario, SyncManager.getFileFilter((IProject)project), null);
        if (fSyncConnection == null) {
            return null;
        }
        return fSyncConnection.getMergeConflictParts(file);
    }

    private boolean irrelevantPath(IProject project, IResource resource) {
        if (SyncManager.getFileFilter((IProject)project).shouldIgnore(resource)) {
            return true;
        }
        String path = resource.getFullPath().toString();
        if (path.endsWith("/.ptp-sync")) {
            return true;
        }
        if (path.endsWith("/.git")) {
            return true;
        }
        return path.endsWith("/.settings");
    }

    public IRemoteConnection getConnection() {
        return this.fConnection;
    }

    public String getConfigLocation() {
        return this.fLocation;
    }

    public void setRemoteToolsConnection(IRemoteConnection connection) {
        this.fConnection = connection;
        this.putString(GIT_CONNECTION_NAME, connection.getName());
    }

    public void setConfigLocation(String configLocation) {
        this.fLocation = configLocation;
        this.putString(GIT_LOCATION, configLocation);
    }

    public void close(IProject project) {
        for (Map.Entry<ProjectAndScenario, GitRemoteSyncConnection> entry : this.syncConnectionMap.entrySet()) {
            if (entry.getKey().project != project) continue;
            entry.getValue().close();
        }
    }

    public void setMergeAsResolved(IProject project, BuildScenario buildScenario, IPath[] paths) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, buildScenario, SyncManager.getFileFilter((IProject)project), null);
        if (fSyncConnection != null) {
            fSyncConnection.setMergeAsResolved(paths);
        }
    }

    public void checkout(IProject project, BuildScenario buildScenario, IPath[] paths) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, buildScenario, SyncManager.getFileFilter((IProject)project), null);
        if (fSyncConnection != null) {
            fSyncConnection.checkout(paths);
        }
    }

    public void checkoutRemoteCopy(IProject project, BuildScenario buildScenario, IPath[] paths) throws RemoteSyncException {
        GitRemoteSyncConnection fSyncConnection = this.getSyncConnection(project, buildScenario, SyncManager.getFileFilter((IProject)project), null);
        if (fSyncConnection != null) {
            fSyncConnection.checkoutRemoteCopy(paths);
        }
    }

    private static class ProjectAndScenario {
        private IProject project;
        private BuildScenario scenario;
        private String projectLocation;

        ProjectAndScenario(IProject p, BuildScenario bs) {
            this.project = p;
            this.scenario = bs;
            this.projectLocation = p.getLocation().toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.projectLocation == null ? 0 : this.projectLocation.hashCode());
            result = 31 * result + (this.scenario == null ? 0 : this.scenario.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectAndScenario other = (ProjectAndScenario)obj;
            if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
                return false;
            }
            if (this.projectLocation == null ? other.projectLocation != null : !this.projectLocation.equals(other.projectLocation)) {
                return false;
            }
            return !(this.scenario == null ? other.scenario != null : !this.scenario.equals((Object)other.scenario));
        }
    }
}

