/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IResource;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.osgi.service.prefs.Preferences;

public class RegexResourceMatcher
extends ResourceMatcher {
    private static final String ATTR_REGEX = "regex";
    private final String regex;
    private final Pattern pattern;

    public RegexResourceMatcher(String r) throws PatternSyntaxException {
        this.regex = r == null ? "" : r;
        this.pattern = Pattern.compile(this.regex);
    }

    @Override
    public boolean match(IResource candidate) {
        if (candidate == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(candidate.getProjectRelativePath().toOSString());
        return m.matches();
    }

    @Override
    public String toString() {
        return this.regex;
    }

    @Override
    public int hashCode() {
        return this.regex.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegexResourceMatcher)) {
            return false;
        }
        RegexResourceMatcher other = (RegexResourceMatcher)obj;
        return this.regex.equals(other.regex);
    }

    @Override
    public void saveMatcher(Preferences prefRootNode) {
        super.saveMatcher(prefRootNode);
        prefRootNode.put(ATTR_REGEX, this.regex);
    }

    public static ResourceMatcher loadMatcher(Preferences prefRootNode) throws NoSuchElementException {
        String r = prefRootNode.get(ATTR_REGEX, null);
        if (r == null) {
            throw new NoSuchElementException(Messages.RegexResourceMatcher_0);
        }
        return new RegexResourceMatcher(r);
    }
}

