/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.language.settings.providers.ICBuildOutputParser;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.language.settings.providers.GCCBuiltinSpecsDetector;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.remotemake.SyncCommandLauncher;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class SyncGCCBuiltinSpecsDetector
extends GCCBuiltinSpecsDetector
implements ILanguageSettingsEditableProvider {
    private static final String CDT_MANAGEDBUILDER_UI_PLUGIN_ID = "org.eclipse.cdt.managedbuilder.ui";
    private static final String SCANNER_DISCOVERY_CONSOLE = "org.eclipse.cdt.managedbuilder.ScannerDiscoveryConsole";
    private static final String SCANNER_DISCOVERY_GLOBAL_CONSOLE = "org.eclipse.cdt.managedbuilder.ScannerDiscoveryGlobalConsole";
    private static final String DEFAULT_CONSOLE_ICON = "icons/obj16/inspect_sys.gif";
    private static final String GMAKE_ERROR_PARSER_ID = "org.eclipse.cdt.core.GmakeErrorParser";
    private static final int MONITOR_SCALE = 100;
    private static final int TICKS_OUTPUT_PARSING = 100;
    private static final int TICKS_EXECUTE_COMMAND = 100;

    protected int runProgramForLanguage(String languageId, String command, String[] envp, URI workingDirectoryURI, OutputStream consoleOut, OutputStream consoleErr, IProgressMonitor monitor) throws CoreException, IOException {
        BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(this.currentProject);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int retval = 1;
        boolean closeAttempted = false;
        try {
            monitor.beginTask(ManagedMakeMessages.getFormattedString((String)Messages.SyncGCCBuiltinSpecsDetector_0, (String)this.getName()), 200);
            IConsole console = super.isConsoleEnabled() ? this.startProviderConsole() : CCorePlugin.getDefault().getConsole("org.eclipse.cdt.managedbuilder.core.console.hidden");
            console.start(this.currentProject);
            SyncCommandLauncher launcher = new SyncCommandLauncher();
            launcher.setProject(this.currentProject);
            Path program = new Path("");
            String[] args = new String[]{};
            String[] cmdArray = CommandLineUtil.argumentsToArray((String)command);
            if (cmdArray != null && cmdArray.length > 0) {
                program = new Path(cmdArray[0]);
                if (cmdArray.length > 1) {
                    args = new String[cmdArray.length - 1];
                    System.arraycopy(cmdArray, 1, args, 0, args.length);
                }
            }
            ErrorParserManager epm = new ErrorParserManager(this.currentProject, this.buildDirURI, null, new String[]{GMAKE_ERROR_PARSER_ID});
            ConsoleParserAdapter consoleParser = new ConsoleParserAdapter();
            consoleParser.startup(this.currentCfgDescription, (IWorkingDirectoryTracker)epm);
            ArrayList<ConsoleParserAdapter> parsers = new ArrayList<ConsoleParserAdapter>();
            parsers.add(consoleParser);
            buildRunnerHelper.setLaunchParameters((ICommandLauncher)launcher, (IPath)program, args, this.buildDirURI, envp);
            buildRunnerHelper.prepareStreams(epm, parsers, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            buildRunnerHelper.greeting(ManagedMakeMessages.getFormattedString((String)Messages.SyncGCCBuiltinSpecsDetector_1, (String)this.getName()));
            retval = buildRunnerHelper.build((IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
            closeAttempted = true;
            buildRunnerHelper.close();
            buildRunnerHelper.goodbye();
        }
        catch (Exception e) {
            if (closeAttempted) {
                ManagedBuilderCorePlugin.log((Throwable)e);
            }
            ManagedBuilderCorePlugin.log((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", Messages.SyncGCCBuiltinSpecsDetector_2, (Throwable)e)));
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e1) {
                ManagedBuilderCorePlugin.log((Throwable)e1);
            }
        }
        monitor.done();
        return retval;
    }

    protected void setSettingEntries(List<ICLanguageSettingEntry> entries) {
        if (entries == null) {
            super.setSettingEntries(entries);
            return;
        }
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        BuildScenario bs = bcm.getBuildScenarioForProject(this.currentProject);
        if (bs.getSyncProvider() == null) {
            super.setSettingEntries(entries);
            return;
        }
        IRemoteConnection conn = null;
        try {
            conn = bs.getRemoteConnection();
        }
        catch (MissingConnectionException missingConnectionException) {
            super.setSettingEntries(entries);
            return;
        }
        ArrayList<Object> newEntries = new ArrayList<Object>();
        for (ICLanguageSettingEntry entry : entries) {
            if (entry instanceof CIncludePathEntry && (entry.getFlags() & 8) == 0) {
                String oldPath = ((CIncludePathEntry)entry).getValue();
                if (oldPath.startsWith("C:")) {
                    oldPath = oldPath.substring(2);
                }
                String newPath = "//" + conn.getName() + oldPath;
                CIncludePathEntry newEntry = new CIncludePathEntry(newPath, entry.getFlags());
                newEntries.add(newEntry);
                continue;
            }
            newEntries.add(entry);
        }
        super.setSettingEntries(newEntries);
    }

    protected String getSpecFile(String languageId) {
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        BuildScenario bs = bcm.getBuildScenarioForProject(this.currentProject);
        if (bs.getSyncProvider() == null) {
            return super.getSpecFile(languageId);
        }
        String specFileName = "spec";
        String ext = this.getSpecFileExtension(languageId);
        if (ext != null) {
            specFileName = String.valueOf(specFileName) + '.' + ext;
        }
        Path workingLocation = new Path(bs.getLocation(this.currentProject));
        IPath fileLocation = workingLocation.append(".ptp-sync").append(specFileName);
        IRemoteConnection conn = null;
        try {
            conn = bs.getRemoteConnection();
        }
        catch (MissingConnectionException missingConnectionException) {
            return fileLocation.toString();
        }
        IRemoteFileManager fileManager = conn.getRemoteServices().getFileManager(conn);
        IFileStore fileStore = fileManager.getResource(fileLocation.toString());
        IFileInfo fileInfo = fileStore.fetchInfo();
        if (!fileInfo.exists()) {
            try {
                OutputStream os = fileStore.openOutputStream(0, null);
                os.write(10);
                os.close();
            }
            catch (CoreException e) {
                RDTSyncCorePlugin.log(e);
            }
            catch (IOException e) {
                RDTSyncCorePlugin.log(e);
            }
        }
        return fileLocation.toString();
    }

    private IConsole startProviderConsole() {
        IConsole console = null;
        if (super.isConsoleEnabled() && this.currentLanguageId != null) {
            String extConsoleId = this.currentProject != null ? SCANNER_DISCOVERY_CONSOLE : SCANNER_DISCOVERY_GLOBAL_CONSOLE;
            ILanguage ld = LanguageManager.getInstance().getLanguage(this.currentLanguageId);
            if (ld != null) {
                String consoleId = "org.eclipse.cdt.managedbuilder.core." + this.getId() + '.' + this.currentLanguageId;
                String consoleName = String.valueOf(this.getName()) + ", " + ld.getName();
                URL defaultIcon = Platform.getBundle((String)CDT_MANAGEDBUILDER_UI_PLUGIN_ID).getEntry(DEFAULT_CONSOLE_ICON);
                if (defaultIcon == null) {
                    String msg = String.valueOf(Messages.SyncGCCBuiltinSpecsDetector_3) + DEFAULT_CONSOLE_ICON + Messages.SyncGCCBuiltinSpecsDetector_4 + CDT_MANAGEDBUILDER_UI_PLUGIN_ID;
                    ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg));
                }
                console = CCorePlugin.getDefault().getConsole(extConsoleId, consoleId, consoleName, defaultIcon);
            }
        }
        if (console == null) {
            console = CCorePlugin.getDefault().getConsole("org.eclipse.cdt.managedbuilder.core.console.hidden");
        }
        return console;
    }

    private class ConsoleParserAdapter
    implements ICBuildOutputParser {
        private ConsoleParserAdapter() {
        }

        public void startup(ICConfigurationDescription cfgDescription, IWorkingDirectoryTracker cwdTracker) throws CoreException {
            SyncGCCBuiltinSpecsDetector.this.cwdTracker = cwdTracker;
        }

        public boolean processLine(String line) {
            return SyncGCCBuiltinSpecsDetector.this.processLine(line);
        }

        public void shutdown() {
            SyncGCCBuiltinSpecsDetector.this.cwdTracker = null;
        }
    }
}

