/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml_jaxb.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.internal.core.model.Row;
import org.eclipse.ptp.rm.lml_jaxb.actions.AbstractStatusAction;
import org.eclipse.ptp.rm.lml_jaxb.actions.ActionUtils;
import org.eclipse.ptp.rm.lml_jaxb.messages.Messages;
import org.eclipse.ui.IViewPart;

public class RefreshJobStatus
extends AbstractStatusAction {
    public void run(IAction action) {
        Job j = new Job(Messages.RefreshJobStatus){

            protected IStatus run(IProgressMonitor monitor) {
                for (Row row : RefreshJobStatus.this.selected) {
                    JobStatusData status = row.status;
                    try {
                        ActionUtils.maybeUpdateJobState(status, monitor);
                    }
                    catch (CoreException t) {
                        return CoreExceptionUtils.getErrorStatus((String)Messages.RefreshJobStatusError, (Throwable)t);
                    }
                    if (monitor == null || !monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    protected void validate(IAction action) {
        for (Row row : this.selected) {
            JobStatusData status = row.status;
            if (status == null) {
                action.setEnabled(false);
                return;
            }
            if (RefreshJobStatus.operationSupported(status, "get-job-status", (IViewPart)this.view)) continue;
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
    }
}

