/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassSpecialization
extends PDOMCPPSpecialization
implements ICPPClassSpecialization,
IPDOMMemberOwner,
IPDOMCPPClassType {
    private static final int FIRST_BASE = 40;
    private static final int MEMBER_LIST = 44;
    private static final int FINAL = 48;
    protected static final int RECORD_SIZE = 49;
    private volatile ICPPClassScope fScope;
    private ObjectMap specializationMap;
    private final ThreadLocal<Set<IBinding>> fInProgress = new ThreadLocal();

    public PDOMCPPClassSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPClassType classType, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)classType), specialized);
        this.setFinal(classType);
    }

    public PDOMCPPClassSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType ct = (ICPPClassType)newBinding;
            this.setFinal(ct);
            super.update(linkage, newBinding);
        }
    }

    @Override
    protected int getRecordSize() {
        return 49;
    }

    @Override
    public int getNodeType() {
        return 37;
    }

    @Override
    public ICPPClassType getSpecializedBinding() {
        return (ICPPClassType)super.getSpecializedBinding();
    }

    @Override
    public IBinding specializeMember(IBinding original) {
        return this.specializeMember(original, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinding specializeMember(IBinding original, IASTNode point) {
        Set<IBinding> set;
        Object cached;
        if (this.specializationMap == null) {
            Long key = this.record + 3L;
            cached = this.getPDOM().getCachedResult(key);
            if (cached != null) {
                this.specializationMap = (ObjectMap)cached;
            } else {
                ObjectMap newMap = new ObjectMap(2);
                try {
                    ICPPClassType[] nested;
                    PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
                    PDOMCPPClassScope.acceptViaCache(this, visitor, false);
                    ICPPClassType[] iCPPClassTypeArray = nested = visitor.getNestedClasses();
                    int n = nested.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPClassType classType = iCPPClassTypeArray[n2];
                        if (classType instanceof ICPPSpecialization) {
                            newMap.put(((ICPPSpecialization)((Object)classType)).getSpecializedBinding(), classType);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log((Throwable)e);
                }
                this.specializationMap = (ObjectMap)this.getPDOM().putCachedResult(key, newMap, false);
            }
        }
        cached = this.specializationMap;
        synchronized (cached) {
            IBinding result = (IBinding)this.specializationMap.get(original);
            if (result != null) {
                return result;
            }
            set = this.fInProgress.get();
            if (set == null) {
                set = new HashSet<IBinding>();
                this.fInProgress.set(set);
            }
            if (!set.add(original)) {
                return CPPClassSpecialization.RecursionResolvingBinding.createFor(original, point);
            }
        }
        IBinding newSpec = CPPTemplates.createSpecialization(this, original, point);
        set.remove(original);
        ObjectMap objectMap = this.specializationMap;
        synchronized (objectMap) {
            IBinding oldSpec = (IBinding)this.specializationMap.put(original, newSpec);
            if (oldSpec != null) {
                this.specializationMap.put(original, oldSpec);
                return oldSpec;
            }
        }
        return newSpec;
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        if (this.fScope == null) {
            try {
                if (this.hasOwnScope()) {
                    this.fScope = new PDOMCPPClassScope(this);
                    return this.fScope;
                }
            }
            catch (CoreException coreException) {}
            this.fScope = new PDOMCPPClassSpecializationScope(this);
        }
        return this.fScope;
    }

    protected boolean hasOwnScope() throws CoreException {
        return this.hasDefinition();
    }

    public PDOMCPPBase getFirstBase() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 40L);
        return rec != 0L ? new PDOMCPPBase((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        long rec = base != null ? base.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 40L, rec);
    }

    public void addBases(PDOMName classDefName, ICPPBase[] bases) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        ILinkage linkage = this.getLinkage();
        PDOMCPPBase firstBase = this.getFirstBase();
        ICPPBase[] iCPPBaseArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            PDOMCPPBase nextBase = new PDOMCPPBase((PDOMLinkage)linkage, base, classDefName);
            nextBase.setNextBase(firstBase);
            firstBase = nextBase;
            ++n2;
        }
        this.setFirstBase(firstBase);
    }

    public void removeBases(PDOMName classDefName) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        long nameRec = classDefName.getRecord();
        boolean deleted = false;
        while (base != null) {
            PDOMCPPBase nextBase = base.getNextBase();
            long classDefRec = this.getDB().getRecPtr(base.getRecord() + 0L);
            if (classDefRec == nameRec) {
                deleted = true;
                base.delete();
            } else if (deleted) {
                deleted = false;
                if (predecessor == null) {
                    this.setFirstBase(base);
                } else {
                    predecessor.setNextBase(base);
                }
                predecessor = base;
            }
            base = nextBase;
        }
        if (deleted) {
            if (predecessor == null) {
                this.setFirstBase(null);
            } else {
                predecessor.setNextBase(null);
            }
        }
    }

    @Override
    public ICPPBase[] getBases() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getBases(null);
    }

    @Override
    public ICPPBase[] getBases(IASTNode point) {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getBases(point);
        }
        Long key = this.record + 1L;
        ICPPBase[] bases = (ICPPBase[])this.getPDOM().getCachedResult(key);
        if (bases != null) {
            return bases;
        }
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            bases = list.toArray(new ICPPBase[list.size()]);
            this.getPDOM().putCachedResult(key, bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getConstructors(null);
    }

    @Override
    public ICPPConstructor[] getConstructors(IASTNode point) {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getConstructors(point);
        }
        try {
            PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getConstructors();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getDeclaredMethods(null);
    }

    @Override
    public ICPPMethod[] getDeclaredMethods(IASTNode point) {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getDeclaredMethods(point);
        }
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            PDOMCPPClassScope.acceptViaCache(this, methods, false);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getDeclaredFields(null);
    }

    @Override
    public ICPPField[] getDeclaredFields(IASTNode point) {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getDeclaredFields(point);
        }
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getNestedClasses(null);
    }

    @Override
    public ICPPClassType[] getNestedClasses(IASTNode point) {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getNestedClasses(point);
        }
        try {
            PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }
    }

    @Override
    public IBinding[] getFriends() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getFriends(null);
    }

    @Override
    public IBinding[] getFriends(IASTNode point) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public ICPPMethod[] getMethods() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getMethods(null);
    }

    @Override
    public ICPPMethod[] getMethods(IASTNode point) {
        return ClassTypeHelper.getMethods(this, point);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getAllDeclaredMethods(null);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods(IASTNode point) {
        return ClassTypeHelper.getAllDeclaredMethods(this, point);
    }

    @Override
    public IField[] getFields() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getFields(null);
    }

    @Override
    public IField[] getFields(IASTNode point) {
        return ClassTypeHelper.getFields(this, point);
    }

    @Override
    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    @Override
    public int getKey() {
        return this.getSpecializedBinding().getKey();
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (!(type instanceof ICPPClassSpecialization)) {
            return false;
        }
        return CPPClassSpecialization.isSameClassSpecialization(this, (ICPPClassSpecialization)type);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void addChild(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 44L);
        list.addMember(member);
    }

    @Override
    public void acceptUncached(IPDOMVisitor visitor) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 44L);
        list.accept(visitor);
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPClassScope.acceptViaCache(this, visitor, false);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isFinal() {
        try {
            return this.getDB().getByte(this.record + 48L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return false;
        }
    }

    private void setFinal(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 48L, (byte)(ct.isFinal() ? 1 : 0));
    }
}

