/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCTypedef
extends PDOMBinding
implements ITypedef,
ITypeContainer,
IIndexType {
    private static final int TYPE_OFFSET = 28;
    protected static final int RECORD_SIZE = 34;

    public PDOMCTypedef(PDOMLinkage linkage, PDOMNode parent, ITypedef typedef) throws CoreException {
        super(linkage, parent, typedef.getNameCharArray());
        try {
            IType type = typedef.getType();
            this.setType(parent.getLinkage(), type);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCTypedef(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ITypedef) {
            ITypedef td = (ITypedef)newBinding;
            try {
                this.setType(linkage, td.getType());
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException, DOMException {
        linkage.storeType(this.record + 28L, newType);
        if (this.introducesRecursion(this.getType(), this.getNameCharArray())) {
            linkage.storeType(this.record + 28L, null);
        }
    }

    private boolean introducesRecursion(IType type, char[] tdname) throws DOMException {
        int maxDepth = 50;
        while (--maxDepth > 0) {
            if (type instanceof ITypedef && CharArrayUtils.equals(((ITypedef)type).getNameCharArray(), tdname)) {
                return true;
            }
            if (type instanceof ITypeContainer) {
                type = ((ITypeContainer)type).getType();
                continue;
            }
            if (type instanceof IFunctionType) {
                IType[] params;
                IFunctionType ft = (IFunctionType)type;
                if (this.introducesRecursion(ft.getReturnType(), tdname)) {
                    return true;
                }
                IType[] iTypeArray = params = ft.getParameterTypes();
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    IType param = iTypeArray[n2];
                    if (this.introducesRecursion(param, tdname)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    protected int getRecordSize() {
        return 34;
    }

    @Override
    public int getNodeType() {
        return 12;
    }

    @Override
    public IType getType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 28L);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isSameType(IType type) {
        IType myrtype = this.getType();
        if (myrtype == null) {
            return false;
        }
        if (type instanceof ITypedef) {
            type = ((ITypedef)type).getType();
        }
        return myrtype.isSameType(type);
    }

    @Override
    protected String toStringBase() {
        return String.valueOf(this.getName()) + ": " + super.toStringBase();
    }

    @Override
    public void setType(IType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

