/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.model.IModelBuilderService;
import org.eclipse.ptp.internal.rdt.core.model.ModelBuilder;
import org.eclipse.ptp.internal.rdt.core.model.RemoteModelBuilderServiceFactory;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteModelWorkingCopy
extends WorkingCopy {
    WorkingCopy fOriginal;

    public RemoteModelWorkingCopy(WorkingCopy original, boolean hasFile) {
        super(original.getParent(), original.getLocationURI(), original.getContentTypeId(), original.getBufferFactory());
        this.fOriginal = original;
    }

    public RemoteModelWorkingCopy(WorkingCopy original) {
        super(original.getParent(), original.getFile(), original.getContentTypeId(), original.getBufferFactory());
        this.fOriginal = original;
    }

    public WorkingCopy getOriginalWorkingCopy() {
        return this.fOriginal;
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        this.removeChildrenInfo((Parent)this.fOriginal);
        IModelBuilderService service = new RemoteModelBuilderServiceFactory().getModelBuilderService(this.getCProject().getProject());
        if (service != null) {
            ITranslationUnit tu = null;
            try {
                tu = service.getModel((IWorkingCopy)this.fOriginal, (IProgressMonitor)new NullProgressMonitor());
                ModelBuilder builder = new ModelBuilder((org.eclipse.cdt.internal.core.model.TranslationUnit)this.fOriginal, (IProgressMonitor)new NullProgressMonitor());
                builder.buildLocalModel((TranslationUnit)tu);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void removeChildrenInfo(Parent parent) throws CModelException {
        ICElement[] children;
        ICElement[] iCElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof Parent) {
                this.removeChildrenInfo((Parent)child);
            }
            ++n2;
        }
        parent.removeChildren();
    }

    protected void generateInfos(CElementInfo info, Map<ICElement, CElementInfo> newElements, IProgressMonitor monitor) throws CModelException {
        super.generateInfos(info, newElements, monitor);
        CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this.fOriginal);
    }
}

