/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui.widgets;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.ptp.rm.ibm.lsf.ui.model.TableContentsProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class LSFQueryDialog
extends Dialog {
    protected String[] columnLabels;
    protected Vector<String[]> commandResponse;
    private String dialogTitle;
    protected Shell parentShell;
    private Table queryTable;
    private String selectedValues;
    private boolean multiSelect;
    private TableSelectionListener tableSelectionListener;

    LSFQueryDialog(Shell parent, String title, String[] labels, Vector<String[]> response, boolean mSelect) {
        super(parent);
        this.parentShell = parent;
        this.dialogTitle = title;
        this.columnLabels = labels;
        this.commandResponse = response;
        this.multiSelect = mSelect;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        TableColumnLayout tableLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableLayout);
        TableViewer viewer = this.multiSelect ? new TableViewer(composite, 770) : new TableViewer(composite, 772);
        this.queryTable = viewer.getTable();
        this.queryTable.clearAll();
        this.queryTable.setHeaderVisible(true);
        this.queryTable.setLinesVisible(true);
        TableViewerColumn[] viewColumns = new TableViewerColumn[this.columnLabels.length];
        int i = 0;
        while (i < viewColumns.length) {
            viewColumns[i] = new TableViewerColumn(viewer, 0);
            TableColumn tableColumn = viewColumns[i].getColumn();
            tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(1, 75, true));
            tableColumn.setText(this.columnLabels[i]);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            ++i;
        }
        this.tableSelectionListener = new TableSelectionListener();
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.tableSelectionListener);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableContentsProvider contentsProvider = new TableContentsProvider();
        viewer.setLabelProvider((IBaseLabelProvider)contentsProvider);
        viewer.setInput(this.commandResponse);
        int n = this.queryTable.getItemCount();
        String[] selections = this.selectedValues.split(" ");
        int[] trialSelectionIndices = new int[selections.length];
        int matchCount = 0;
        i = 0;
        while (i < trialSelectionIndices.length) {
            int j = 0;
            while (j < n) {
                TableItem rowData = this.queryTable.getItem(j);
                if (rowData.getText(0).equals(selections[i])) {
                    trialSelectionIndices[matchCount++] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (matchCount > 0) {
            int[] selectionIndices = new int[matchCount];
            i = 0;
            while (i < matchCount) {
                selectionIndices[i] = trialSelectionIndices[i];
                ++i;
            }
            this.queryTable.select(selectionIndices);
        }
        return composite;
    }

    public String getSelectedValues() {
        return this.selectedValues;
    }

    protected boolean isResizable() {
        return true;
    }

    public void setSelectedValue(String value) {
        this.selectedValues = value;
    }

    private class TableSelectionListener
    implements ISelectionChangedListener {
        private TableSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent arg0) {
            List selections = ((IStructuredSelection)arg0.getSelection()).toList();
            LSFQueryDialog.this.selectedValues = " ";
            for (String[] s : selections) {
                LSFQueryDialog.this.selectedValues = String.valueOf(LSFQueryDialog.this.selectedValues) + s[0] + " ";
            }
        }
    }
}

