/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.parser.ASTContinueStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTIfConstructNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class RemoveBranchToEndIfRefactoring
extends FortranEditorRefactoring {
    private ASTEndIfStmtNode selectedEndIfNode;
    private ASTIfConstructNode selectedIfConstructNode;
    private ASTContinueStmtNode continueAfterIfStmtNode;
    private LinkedList<ASTGotoStmtNode> gotoStatementWithEndIfLabel;
    private LinkedList<ASTGotoStmtNode> selectedGotoStatementWithEndIfLabel;

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        LinkedList<ASTGotoStmtNode> gotoStatements;
        this.ensureProjectHasRefactoringEnabled(status);
        this.selectedEndIfNode = RemoveBranchToEndIfRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor, ASTEndIfStmtNode.class);
        if (this.selectedEndIfNode == null || this.selectedEndIfNode.getLabel() == null) {
            this.fail(Messages.RemoveBranchToEndIfRefactoring_PleaseSelectLabeledEndIfStatement);
        }
        this.selectedIfConstructNode = this.selectedEndIfNode.findNearestAncestor(ASTIfConstructNode.class);
        if (this.selectedIfConstructNode == null) {
            this.fail(Messages.RemoveBranchToEndIfRefactoring_NoEnclosingIfConstruct);
        }
        if ((gotoStatements = this.getGotoNodes(ScopingNode.getLocalScope(this.selectedEndIfNode))).isEmpty()) {
            this.fail(Messages.RemoveBranchToEndIfRefactoring_NoGotoStatements);
        }
        this.gotoStatementWithEndIfLabel = this.findGotoForLabel(gotoStatements, this.selectedEndIfNode.getLabel().getText());
        if (this.gotoStatementWithEndIfLabel.size() == 0) {
            this.fail(Messages.RemoveBranchToEndIfRefactoring_NoGotoStatementReferencingThisLabel);
        }
        LinkedList<ASTGotoStmtNode> selectedGotoStatements = this.getGotoNodes(this.selectedIfConstructNode);
        this.selectedGotoStatementWithEndIfLabel = this.findGotoForLabel(selectedGotoStatements, this.selectedEndIfNode.getLabel().getText());
        if (this.selectedGotoStatementWithEndIfLabel.size() == this.gotoStatementWithEndIfLabel.size()) {
            this.fail(Messages.RemoveBranchToEndIfRefactoring_BranchToImmediateEndIf);
        }
        this.continueAfterIfStmtNode = RemoveBranchToEndIfRefactoring.continueAfterIfStmt(this.selectedIfConstructNode);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.continueAfterIfStmtNode == null) {
            this.changeNoContinueAfterEndIf();
        } else {
            this.changeGotoLabelToContinueLabel();
        }
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
    }

    private void changeGotoLabelToContinueLabel() {
        for (ASTGotoStmtNode gotoNode : this.gotoStatementWithEndIfLabel) {
            if (this.selectedGotoStatementWithEndIfLabel.contains(gotoNode)) continue;
            gotoNode.getGotoLblRef().getLabel().setText(this.continueAfterIfStmtNode.getLabel().getText());
        }
        if (this.selectedGotoStatementWithEndIfLabel.isEmpty()) {
            this.selectedEndIfNode.setLabel(null);
            this.selectedEndIfNode.findFirstToken().setWhiteBefore(this.selectedIfConstructNode.findFirstToken().getWhiteBefore());
        }
    }

    private void changeNoContinueAfterEndIf() {
        if (this.continueAfterIfStmtNode != null) {
            return;
        }
        ASTListNode listNode = (ASTListNode)this.selectedIfConstructNode.getParent();
        String programString = "program p\n" + this.selectedEndIfNode.getLabel().getText() + " CONTINUE" + EOL + "end program";
        ASTMainProgramNode programNode = (ASTMainProgramNode)RemoveBranchToEndIfRefactoring.parseLiteralProgramUnit(programString);
        ASTContinueStmtNode continueStmt = (ASTContinueStmtNode)programNode.getBody().get(0);
        continueStmt.setParent(this.selectedIfConstructNode.getParent());
        listNode.insertAfter(this.selectedIfConstructNode, continueStmt);
        if (this.selectedGotoStatementWithEndIfLabel.size() == 0) {
            this.selectedEndIfNode.setLabel(null);
            this.selectedEndIfNode.findFirstToken().setWhiteBefore(this.selectedIfConstructNode.findFirstToken().getWhiteBefore());
        } else {
            LinkedList<IActionStmt> actionStmts = this.getActionStmts(ScopingNode.getLocalScope(this.selectedEndIfNode));
            String label = this.getUniqueLabel(actionStmts);
            continueStmt.getLabel().setText(label);
            for (ASTGotoStmtNode node : this.gotoStatementWithEndIfLabel) {
                if (this.selectedGotoStatementWithEndIfLabel.contains(node)) continue;
                node.getGotoLblRef().getLabel().setText(label);
            }
        }
    }

    private LinkedList<ASTGotoStmtNode> getGotoNodes(IASTNode startNode) {
        if (startNode == null) {
            return null;
        }
        final LinkedList<ASTGotoStmtNode> gotoNodes = this.getGotoStmtsInAllProperLoopConstructs(startNode);
        startNode.accept(new ASTVisitor(){

            @Override
            public void visitASTGotoStmtNode(ASTGotoStmtNode node) {
                gotoNodes.add(node);
            }
        });
        return gotoNodes;
    }

    private LinkedList<ASTGotoStmtNode> getGotoStmtsInAllProperLoopConstructs(IASTNode startNode) {
        final LinkedList<ASTGotoStmtNode> gotoNodes = new LinkedList<ASTGotoStmtNode>();
        LinkedList<ASTProperLoopConstructNode> loopNodes = this.getProperLoopConstructs(startNode);
        for (ASTProperLoopConstructNode loop : loopNodes) {
            for (IASTNode iASTNode : loop.getBody()) {
                iASTNode.accept(new ASTVisitor(){

                    @Override
                    public void visitASTGotoStmtNode(ASTGotoStmtNode node) {
                        gotoNodes.add(node);
                    }
                });
            }
        }
        return gotoNodes;
    }

    private LinkedList<ASTGotoStmtNode> findGotoForLabel(LinkedList<ASTGotoStmtNode> gotos, String label) {
        if (gotos == null) {
            return new LinkedList<ASTGotoStmtNode>();
        }
        LinkedList<ASTGotoStmtNode> gotoWithLabel = new LinkedList<ASTGotoStmtNode>();
        for (ASTGotoStmtNode gotoNode : gotos) {
            if (!gotoNode.getGotoLblRef().getLabel().getText().contentEquals(label)) continue;
            gotoWithLabel.add(gotoNode);
        }
        return gotoWithLabel;
    }

    private static ASTContinueStmtNode continueAfterIfStmt(ASTIfConstructNode ifStmt) {
        if (ifStmt == null) {
            return null;
        }
        ASTListNode list = (ASTListNode)ifStmt.getParent();
        int i = 0;
        while (i < list.size() - 1) {
            if (list.get(i) != null && ((ASTNode)list.get(i)).equals(ifStmt) && list.get(i + 1) instanceof ASTContinueStmtNode) {
                return (ASTContinueStmtNode)list.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    private String getUniqueLabel(LinkedList<IActionStmt> actionStmts) {
        int label = Integer.parseInt(this.selectedEndIfNode.getLabel().getText());
        for (IActionStmt stmt : actionStmts) {
            int currentLabel;
            if (stmt.getLabel() == null || (currentLabel = Integer.parseInt(stmt.getLabel().getText())) <= label) continue;
            label = currentLabel;
        }
        return String.valueOf(label += 10);
    }

    private LinkedList<IActionStmt> getActionStmts(IASTNode startNode) {
        final LinkedList<IActionStmt> actionStmts = this.getActionStmtsInAllProperLoopConstructs();
        startNode.accept(new ASTVisitor(){

            @Override
            public void visitIActionStmt(IActionStmt node) {
                actionStmts.add(node);
            }
        });
        return actionStmts;
    }

    private LinkedList<IActionStmt> getActionStmtsInAllProperLoopConstructs() {
        final LinkedList<IActionStmt> actionStmts = new LinkedList<IActionStmt>();
        LinkedList<ASTProperLoopConstructNode> loopNodes = this.getProperLoopConstructs(ScopingNode.getLocalScope(this.selectedEndIfNode));
        for (ASTProperLoopConstructNode loop : loopNodes) {
            for (IASTNode iASTNode : loop.getBody()) {
                iASTNode.accept(new ASTVisitor(){

                    @Override
                    public void visitIActionStmt(IActionStmt node) {
                        actionStmts.add(node);
                    }
                });
            }
        }
        return actionStmts;
    }

    private LinkedList<ASTProperLoopConstructNode> getProperLoopConstructs(IASTNode startNode) {
        final LinkedList<ASTProperLoopConstructNode> loopNodes = new LinkedList<ASTProperLoopConstructNode>();
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        startNode.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
                loopNodes.add(node);
            }
        });
        return loopNodes;
    }

    public String getName() {
        return Messages.RemoveBranchToEndIfRefactoring_Name;
    }
}

