/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.IPSetManager;
import org.eclipse.ptp.debug.core.TaskSet;

public class PSetManager
implements IPSetManager {
    private final IPSession session;
    private final Map<String, TaskSet> setMap = new HashMap<String, TaskSet>();

    public PSetManager(IPSession session) {
        this.session = session;
        this.createSet("Root", session.getTasks());
    }

    public void addTasks(String sid, TaskSet tasks) {
        this.createSet(sid, tasks);
    }

    public void createSet(String sid, TaskSet tasks) {
        TaskSet oldTasks = this.getTasks(sid);
        if (oldTasks == null) {
            this.setMap.put(sid, tasks);
        } else {
            oldTasks.or(tasks);
        }
    }

    public void deleteSets(String sid) {
        this.setMap.remove(sid);
    }

    public void dispose(IProgressMonitor monitor) {
        this.setMap.clear();
    }

    public IPSession getSession() {
        return this.session;
    }

    public TaskSet getTasks(String sid) {
        return this.setMap.get(sid);
    }

    public void removeTasks(String sid, TaskSet tasks) {
        TaskSet oldTasks = this.getTasks(sid);
        if (oldTasks != null) {
            oldTasks.andNot(tasks);
            if (oldTasks.isEmpty()) {
                this.deleteSets(sid);
            }
        }
    }
}

