/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.model.IExecFileInfo;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPGlobalVariable;
import org.eclipse.ptp.debug.core.model.IPGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPPersistableRegisterGroup;
import org.eclipse.ptp.debug.core.model.IPRegisterDescriptor;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIBreakpointInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDICreatedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDestroyedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDisconnectedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEndSteppingRangeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIErrorInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.event.IPDIFunctionFinishedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDILocationReachedInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIMemoryBlockInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIRegisterInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDISharedLibraryInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISignalInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISuspendedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIThreadInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIVariableInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointScopeInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIWatchpointTriggerInfo;
import org.eclipse.ptp.debug.core.pdi.model.IPDIGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.internal.debug.core.PDebugUtils;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.model.PDebugElement;
import org.eclipse.ptp.internal.debug.core.model.PExpression;
import org.eclipse.ptp.internal.debug.core.model.PThread;
import org.eclipse.ptp.internal.debug.core.model.PVariableFactory;
import org.eclipse.ptp.internal.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.ptp.internal.debug.core.sourcelookup.PSourceLookupDirector;
import org.eclipse.ptp.internal.debug.core.sourcelookup.PSourceLookupParticipant;
import org.eclipse.ptp.internal.debug.core.sourcelookup.ResourceMappingSourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDebugTarget
extends PDebugElement
implements IPDebugTarget,
IPDIEventListener,
ILaunchListener,
IExpressionListener,
ISourceLookupChangeListener {
    private final String PROCESS_NAME = Messages.PDebugTarget_0;
    private ArrayList<IThread> fThreads;
    private final IPDITarget pdiTarget;
    private final IProcess fProcess;
    private Boolean fIsLittleEndian = null;

    public PDebugTarget(IPSession session, IProcess process, IPDITarget pdiTarget, boolean allowTerminate, boolean allowDisconnect) {
        super(session, pdiTarget.getTasks());
        this.fProcess = process;
        this.pdiTarget = pdiTarget;
        this.initializePreferences();
        this.setThreadList(new ArrayList<IThread>(5));
        if (session.getPDISession().isTerminated(pdiTarget.getTasks())) {
            this.setState(PDebugElementState.TERMINATED);
        } else {
            if (session.getPDISession().isSuspended(pdiTarget.getTasks())) {
                this.setState(PDebugElementState.SUSPENDED);
            } else {
                this.setState(PDebugElementState.UNDEFINED);
            }
            this.initialize();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
            DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionListener)this);
            this.getPDISession().getEventManager().addEventListener(this);
        }
    }

    @Override
    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        Preferences.addPreferenceChangeListener((String)PTPDebugCorePlugin.getUniqueIdentifier(), (IEclipsePreferences.IPreferenceChangeListener)listener);
    }

    @Override
    public void addRegisterGroup(String name, IPRegisterDescriptor[] descriptors) {
        this.fSession.getRegisterManager().addRegisterGroup(this.getTasks(), name, descriptors);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    @Override
    public boolean canRestart() {
        return this.isSuspended();
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    @Override
    public boolean canResumeWithoutSignal() {
        return this.canResume() && this.getCurrentStateInfo() instanceof IPDISignalInfo;
    }

    public boolean canSuspend() {
        if (this.getState().equals(PDebugElementState.RESUMED)) {
            IThread[] threads;
            IThread[] iThreadArray = threads = this.getThreads();
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                IThread thread = iThreadArray[n2];
                if (thread.isSuspended()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean canTerminate() {
        return this.isAvailable();
    }

    @Override
    public IPGlobalVariable createGlobalVariable(IPGlobalVariableDescriptor info) throws DebugException {
        IPDIGlobalVariableDescriptor vo = null;
        try {
            vo = this.getPDITarget().getGlobalVariableDescriptors(info.getPath().lastSegment(), null, info.getName());
        }
        catch (PDIException e) {
            throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 5010, vo != null ? String.valueOf(vo.getName()) + ": " + e.getMessage() : e.getMessage(), null));
        }
        return PVariableFactory.createGlobalVariable(this, info, vo);
    }

    public void disconnect() throws DebugException {
        PDebugTarget.targetRequestFailed(Messages.PDebugTarget_1, null);
    }

    @Override
    public void dispose() {
        this.cleanup();
    }

    @Override
    public void enableInstructionStepping(boolean enabled) {
        Preferences.setBoolean((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)"instruction_stepping_mode", (boolean)enabled);
    }

    public void expressionAdded(IExpression expression) {
    }

    public void expressionChanged(IExpression expression) {
    }

    public void expressionRemoved(IExpression expression) {
        if (expression instanceof PExpression && expression.getDebugTarget().equals(this)) {
            ((PExpression)expression).dispose();
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPDebugElement.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(IPDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(IPDITarget.class)) {
            return this.pdiTarget;
        }
        if (adapter.equals(IExecFileInfo.class)) {
            return this;
        }
        if (adapter.equals(IPDISession.class)) {
            return this.getPDISession();
        }
        if (adapter.equals(IMemoryBlockRetrievalExtension.class)) {
            return this.fSession.getMemoryManager().getMemoryRetrieval(this.getTasks());
        }
        if (adapter.equals(IMemoryBlockRetrieval.class)) {
            return this.fSession.getMemoryManager().getMemoryRetrieval(this.getTasks());
        }
        return super.getAdapter(adapter);
    }

    @Override
    public BigInteger getBreakpointAddress(IPLineBreakpoint breakpoint) throws DebugException {
        return this.fSession.getBreakpointManager() != null ? this.fSession.getBreakpointManager().getBreakpointAddress(breakpoint) : new BigInteger("0");
    }

    @Override
    public PDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public IPGlobalVariableDescriptor[] getGlobals() throws DebugException {
        PDebugTarget.targetRequestFailed(Messages.PDebugTarget_2, null);
        return new IPGlobalVariableDescriptor[0];
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return this.fSession.getMemoryManager().getMemoryBlock(this.getTasks(), startAddress, length);
    }

    public String getName() throws DebugException {
        return String.valueOf(this.PROCESS_NAME) + this.getID();
    }

    @Override
    public IPDITarget getPDITarget() {
        return this.pdiTarget;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    @Override
    public IPRegisterDescriptor[] getRegisterDescriptors() throws DebugException {
        return this.fSession.getRegisterManager().getAllRegisterDescriptors(this.getTasks());
    }

    @Override
    public IPSignal[] getSignals() throws DebugException {
        return this.fSession.getSignalManager().getSignals(this.getTasks());
    }

    public IThread[] getThreads() {
        ArrayList<IThread> threads = this.getThreadList();
        return threads.toArray(new IThread[threads.size()]);
    }

    @Override
    public void handleDebugEvents(IPDIEvent[] events) {
        IPDIEvent[] iPDIEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIEvent event = iPDIEventArray[n2];
            if (event.contains(this.getTasks())) {
                if (event instanceof IPDIDestroyedEvent) {
                    this.handleTerminatedEvent((IPDIDestroyedEvent)event);
                } else if (event instanceof IPDICreatedEvent) {
                    this.handleCreatedEvent((IPDICreatedEvent)event);
                } else if (event instanceof IPDISuspendedEvent) {
                    this.handleSuspendedEvent((IPDISuspendedEvent)event);
                } else if (event instanceof IPDIResumedEvent) {
                    this.handleResumedEvent((IPDIResumedEvent)event);
                } else if (event instanceof IPDIDisconnectedEvent) {
                    this.handleDisconnectedEvent((IPDIDisconnectedEvent)event);
                } else if (event instanceof IPDIChangedEvent) {
                    this.handleChangedEvent((IPDIChangedEvent)event);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean hasSignals() throws DebugException {
        return this.fSession.getSignalManager().getSignals(this.getTasks()).length > 0;
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public boolean isDisconnected() {
        return this.getState().equals(PDebugElementState.DISCONNECTED);
    }

    @Override
    public boolean isInstructionSteppingEnabled() {
        return Preferences.getBoolean((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)"instruction_stepping_mode") || Preferences.getBoolean((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_INSTRUCTION_STEP_MODE_ON);
    }

    @Override
    public boolean isLittleEndian() {
        if (this.fIsLittleEndian == null) {
            this.fIsLittleEndian = Boolean.TRUE;
        }
        return this.fIsLittleEndian;
    }

    @Override
    public boolean isPostMortem() {
        return false;
    }

    public boolean isSuspended() {
        return this.getState().equals(PDebugElementState.SUSPENDED);
    }

    public boolean isTerminated() {
        return this.getState().equals(PDebugElementState.TERMINATED);
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    @Override
    public void modifyRegisterGroup(IPPersistableRegisterGroup group, IPRegisterDescriptor[] descriptors) {
        this.fSession.getRegisterManager().modifyRegisterGroup(this.getTasks(), group, descriptors);
    }

    @Override
    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        Preferences.removePreferenceChangeListener((String)PTPDebugCorePlugin.getUniqueIdentifier(), (IEclipsePreferences.IPreferenceChangeListener)listener);
    }

    @Override
    public void removeRegisterGroups(IRegisterGroup[] groups) {
        this.fSession.getRegisterManager().removeRegisterGroups(this.getTasks(), groups);
    }

    @Override
    public void restart() throws DebugException {
        PDebugTarget.targetRequestFailed(Messages.PDebugTarget_3, null);
        if (!this.canRestart()) {
            return;
        }
    }

    @Override
    public void restoreDefaultRegisterGroups() {
        this.fSession.getRegisterManager().restoreDefaults(this.getTasks());
    }

    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        this.changeState(PDebugElementState.RESUMING);
        try {
            this.getPDISession().resume(this.getTasks(), false);
        }
        catch (PDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    @Override
    public void resumeWithoutSignal() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        this.changeState(PDebugElementState.RESUMING);
        try {
            this.getPDISession().resume(this.getTasks(), false);
        }
        catch (PDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.setSourceLookupPath(director.getSourceContainers());
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof IPBreakpoint;
    }

    @Override
    public boolean supportsInstructionStepping() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public void suspend() throws DebugException {
        if (!this.canSuspend()) {
            return;
        }
        this.changeState(PDebugElementState.SUSPENDING);
        try {
            this.getPDISession().suspend(this.getTasks());
        }
        catch (PDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void terminate() throws DebugException {
        if (!this.canTerminate()) {
            return;
        }
        this.changeState(PDebugElementState.TERMINATING);
        try {
            this.getPDISession().terminate(this.getTasks());
        }
        catch (PDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {}
        return result;
    }

    private void changeState(PDebugElementState state) {
        this.setState(state);
        Iterator<IThread> it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((PThread)it.next()).setState(state);
        }
    }

    private void cleanup() {
        this.resetStatus();
        this.removeAllThreads();
        this.getPDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.disposeSignalManager();
        this.disposeRegisterManager();
        this.disposeMemoryManager();
        this.disposeSourceLookupPath();
        this.removeAllExpressions();
    }

    private PThread findThread(IPDIThread pdiThread) {
        ArrayList<IThread> threads = this.getThreadList();
        int i = 0;
        while (i < threads.size()) {
            PThread t = (PThread)threads.get(i);
            if (t.getPDIThread().equals(pdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private PThread findThread(List<IThread> threads, IPDIThread pdiThread) {
        int i = 0;
        while (i < threads.size()) {
            PThread t = (PThread)threads.get(i);
            if (t.getPDIThread().equals(pdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private void getSourceLookupPath(List<String> list, ISourceContainer[] containers) {
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            File dir;
            IContainer container;
            IProject project;
            ISourceContainer container2 = iSourceContainerArray[n2];
            if (container2 instanceof ProjectSourceContainer && (project = ((ProjectSourceContainer)container2).getProject()) != null && project.exists()) {
                list.add(project.getLocationURI().getPath());
            }
            if (container2 instanceof FolderSourceContainer && (container = ((FolderSourceContainer)container2).getContainer()) != null && container.exists()) {
                list.add(container.getLocationURI().getPath());
            }
            if (container2 instanceof DirectorySourceContainer && (dir = ((DirectorySourceContainer)container2).getDirectory()) != null && dir.exists()) {
                Path path = new Path(dir.getAbsolutePath());
                list.add(path.toPortableString());
            }
            if (container2.isComposite()) {
                try {
                    this.getSourceLookupPath(list, container2.getSourceContainers());
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.log(e.getStatus());
                }
            }
            ++n2;
        }
    }

    private void handleChangedEvent(IPDIChangedEvent event) {
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDISignalInfo) {
            this.fSession.getSignalManager().signalChanged(this.getTasks(), ((IPDISignalInfo)reason).getSignal());
        } else if (!(reason instanceof IPDIBreakpointInfo) && !(reason instanceof IPDIMemoryBlockInfo)) {
            boolean cfr_ignored_0 = reason instanceof IPDIVariableInfo;
        }
    }

    private void handleCreatedEvent(IPDICreatedEvent event) {
        IPDISessionObject reason = event.getReason();
        if (!(reason instanceof IPDIBreakpointInfo)) {
            if (reason instanceof IPDIThreadInfo) {
                IPDIThread pdiThread = ((IPDIThreadInfo)reason).getThread();
                PThread thread = this.findThread(pdiThread);
                if (thread == null) {
                    thread = this.createThread(pdiThread);
                    thread.fireCreationEvent();
                }
            } else if (!(reason instanceof IPDISharedLibraryInfo || reason instanceof IPDIMemoryBlockInfo || reason instanceof IPDIRegisterInfo)) {
                boolean cfr_ignored_0 = reason instanceof IPDIVariableInfo;
            }
        }
    }

    private void handleDisconnectedEvent(IPDIDisconnectedEvent event) {
        this.disconnected();
    }

    private void handleResumedEvent(IPDIResumedEvent event) {
        this.setState(PDebugElementState.RESUMED);
        this.setCurrentStateInfo(null);
        this.resetStatus();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(10);
        int detail = 0;
        switch (event.getType()) {
            case 0: {
                detail = 32;
                break;
            }
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        debugEvents.add(this.createResumeEvent(detail));
        this.resumeThreads(debugEvents, detail);
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    private void handleSuspendedEvent(IPDISuspendedEvent event) {
        this.setState(PDebugElementState.SUSPENDED);
        IPDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        this.fSession.getRegisterManager().targetSuspended(this.getTasks());
        this.fSession.getBreakpointManager().skipBreakpoints(false);
        this.refreshThreads();
        this.suspendThreads(event);
        if (reason instanceof IPDIEndSteppingRangeInfo) {
            this.fireSuspendEvent(0);
        } else if (reason instanceof IPDIThreadInfo) {
            IPDIThread pdiThread = ((IPDIThreadInfo)reason).getThread();
            PThread thread = this.findThread(pdiThread);
            if (thread != null) {
                this.getThreadList().remove(thread);
                thread.handleDebugEvents(new IPDIEvent[]{event});
            }
        } else if (reason instanceof IPDIBreakpointInfo) {
            this.fireSuspendEvent(16);
        } else if (reason instanceof IPDISignalInfo) {
            this.fireSuspendEvent(32);
        } else if (reason instanceof IPDIWatchpointTriggerInfo) {
            this.fireSuspendEvent(16);
        } else if (reason instanceof IPDIWatchpointScopeInfo) {
            this.fSession.getBreakpointManager().watchpointOutOfScope(this.getTasks(), ((IPDIWatchpointScopeInfo)reason).getWatchpoint());
            this.fireSuspendEvent(16);
        } else if (reason instanceof IPDISharedLibraryInfo) {
            this.fireSuspendEvent(0);
        } else if (!(reason instanceof IPDIFunctionFinishedInfo) && !(reason instanceof IPDILocationReachedInfo)) {
            this.fireSuspendEvent(0);
        }
    }

    private void handleTerminatedEvent(IPDIDestroyedEvent event) {
        IPDISessionObject reason = event.getReason();
        if (!(reason instanceof IPDIBreakpointInfo)) {
            if (reason instanceof IPDIThreadInfo) {
                IPDIThread pdiThread = ((IPDIThreadInfo)reason).getThread();
                PThread thread = this.findThread(pdiThread);
                if (thread != null) {
                    this.getThreadList().remove(thread);
                    thread.terminated();
                    thread.fireTerminateEvent();
                }
            } else if (reason instanceof IPDIErrorInfo) {
                IPDIErrorInfo info = (IPDIErrorInfo)reason;
                this.setStatus(2, info.getMessage());
                MultiStatus status = new MultiStatus(PTPDebugCorePlugin.getUniqueIdentifier(), 10002, Messages.PDebugTarget_4, null);
                StringTokenizer st = new StringTokenizer(info.getDetailMessage(), "\n\r");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.length() > 200) {
                        token = token.substring(0, 200);
                    }
                    status.add((IStatus)new Status(4, status.getPlugin(), 10002, token, null));
                }
                PDebugUtils.error((IStatus)status, this);
                this.fireTerminateEvent();
            } else if (!(reason instanceof IPDISharedLibraryInfo)) {
                if (reason instanceof IPDISignalInfo) {
                    this.removeAllThreads();
                    this.setState(PDebugElementState.EXITED);
                    this.setCurrentStateInfo(reason);
                    this.fireChangeEvent(512);
                    this.terminated();
                } else {
                    boolean cfr_ignored_0 = reason instanceof IPDIVariableInfo;
                }
            }
        }
    }

    private void initializePreferences() {
        Preferences.setDefaultBoolean((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)"instruction_stepping_mode", (boolean)false);
    }

    private boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected() && !this.isDisconnecting();
    }

    private void setSourceLookupPath(ISourceContainer[] containers) {
        ArrayList<String> list = new ArrayList<String>(containers.length);
        this.getSourceLookupPath(list, containers);
        try {
            this.getPDITarget().setSourcePaths(list.toArray(new String[list.size()]));
        }
        catch (PDIException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    private void setThreadList(ArrayList<IThread> threads) {
        this.fThreads = threads;
    }

    private void terminated() {
        if (!this.isTerminated()) {
            if (!this.isDisconnected()) {
                this.setState(PDebugElementState.TERMINATED);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected PThread createThread(IPDIThread pdiThread) {
        PThread thread = new PThread(this, pdiThread);
        this.getThreadList().add(thread);
        return thread;
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setState(PDebugElementState.DISCONNECTED);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void disposeMemoryManager() {
        this.fSession.getMemoryManager().dispose(this.getTasks());
    }

    protected void disposeRegisterManager() {
        this.fSession.getMemoryManager().dispose(this.getTasks());
    }

    protected void disposeSignalManager() {
        this.fSession.getSignalManager().dispose(this.getTasks());
    }

    protected void disposeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] participants;
            ISourceLookupParticipant[] iSourceLookupParticipantArray = participants = ((ISourceLookupDirector)locator).getParticipants();
            int n = participants.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceLookupParticipant participant = iSourceLookupParticipantArray[n2];
                if (participant instanceof PSourceLookupParticipant) {
                    ((PSourceLookupParticipant)participant).removeSourceLookupChangeListener(this);
                }
                ++n2;
            }
        }
    }

    protected IThread getCurrentThread() throws DebugException {
        IThread[] threads;
        IThread[] iThreadArray = threads = this.getThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            IThread thread = iThreadArray[n2];
            if (((PThread)thread).isCurrent()) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    protected ArrayList<IThread> getThreadList() {
        return this.fThreads;
    }

    protected void initialize() {
        this.initializeSourceLookupPath();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(1);
        debugEvents.add(this.createCreateEvent());
        this.initializeThreads(debugEvents);
        this.initializeRegisters();
        this.initializeMemoryBlocks();
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    protected void initializeMemoryBlocks() {
        this.fSession.getMemoryManager().initialize(this.getTasks(), this);
    }

    protected void initializeRegisters() {
        this.fSession.getRegisterManager().initialize(this.getTasks(), this);
    }

    protected void initializeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof PSourceLookupDirector) {
            PSourceLookupDirector director = (PSourceLookupDirector)locator;
            ISourceContainer[] sc = director.getSourceContainers();
            ArrayList<ISourceContainer> list = new ArrayList<ISourceContainer>(Arrays.asList(sc));
            Path backend = new Path(this.getSession().getProject().getLocationURI().getPath());
            ResourceMappingSourceContainer container = new ResourceMappingSourceContainer();
            container.setPath((IPath)backend);
            container.setContainer((IContainer)this.getSession().getProject());
            list.add((ISourceContainer)container);
            director.setSourceContainers(list.toArray(new ISourceContainer[0]));
        }
    }

    protected void initializeThreads(List<DebugEvent> debugEvents) {
        IPDIThread[] pdiThreads = new IPDIThread[]{};
        try {
            if (this.isSuspended()) {
                pdiThreads = this.getPDITarget().getThreads();
            }
        }
        catch (PDIException pDIException) {}
        DebugEvent suspendEvent = null;
        IPDIThread[] iPDIThreadArray = pdiThreads;
        int n = pdiThreads.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIThread pdiThread = iPDIThreadArray[n2];
            PThread thread = this.createThread(pdiThread);
            debugEvents.add(thread.createCreateEvent());
            try {
                if (pdiThread.equals(this.getPDITarget().getCurrentThread()) && thread.isSuspended()) {
                    suspendEvent = thread.createSuspendEvent(16);
                }
            }
            catch (PDIException pDIException) {}
            ++n2;
        }
        if (suspendEvent != null) {
            debugEvents.add(suspendEvent);
        }
    }

    protected boolean isDisconnecting() {
        return this.getState().equals(PDebugElementState.DISCONNECTING);
    }

    protected boolean isSuspending() {
        return this.getState().equals(PDebugElementState.SUSPENDING);
    }

    protected boolean isTerminating() {
        return this.getState().equals(PDebugElementState.TERMINATING);
    }

    protected synchronized List<IThread> refreshThreads() {
        ArrayList<IThread> newThreads = new ArrayList<IThread>(5);
        ArrayList<IThread> list = new ArrayList<IThread>(5);
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(5);
        List oldList = (List)this.getThreadList().clone();
        IPDIThread[] pdiThreads = new IPDIThread[]{};
        IPDIThread currentPDIThread = null;
        try {
            pdiThreads = this.getPDITarget().getThreads();
            currentPDIThread = this.getPDITarget().getCurrentThread();
        }
        catch (PDIException pDIException) {}
        IPDIThread[] iPDIThreadArray = pdiThreads;
        int n = pdiThreads.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIThread pdiThread = iPDIThreadArray[n2];
            PThread thread = this.findThread(oldList, pdiThread);
            if (thread == null) {
                thread = new PThread(this, pdiThread);
                newThreads.add(thread);
            } else {
                oldList.remove(thread);
            }
            thread.setCurrent(pdiThread.equals(currentPDIThread));
            list.add(thread);
            ++n2;
        }
        for (PThread thread : oldList) {
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.setThreadList(list);
        Iterator it = newThreads.iterator();
        while (it.hasNext()) {
            debugEvents.add(((PThread)it.next()).createCreateEvent());
        }
        if (debugEvents.size() > 0) {
            this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
        }
        return newThreads;
    }

    protected void removeAllExpressions() {
        IExpression[] expressions;
        IExpressionManager em = DebugPlugin.getDefault().getExpressionManager();
        IExpression[] iExpressionArray = expressions = em.getExpressions();
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression expression = iExpressionArray[n2];
            if (expression instanceof PExpression && expression.getDebugTarget().equals(this)) {
                em.removeExpression(expression);
            }
            ++n2;
        }
    }

    protected void removeAllThreads() {
        ArrayList<IThread> threads = this.getThreadList();
        this.setThreadList(new ArrayList<IThread>(0));
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(threads.size());
        for (PThread pThread : threads) {
            pThread.terminated();
            debugEvents.add(pThread.createTerminateEvent());
        }
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    protected void restoreOldState() {
        this.restoreState();
        Iterator<IThread> it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((PThread)it.next()).restoreState();
        }
    }

    protected synchronized void resumeThreads(List<DebugEvent> debugEvents, int detail) {
        IThread[] threads;
        IThread[] iThreadArray = threads = this.getThreadList().toArray(new IThread[0]);
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            IThread thread = iThreadArray[n2];
            ((PThread)thread).resumedByTarget(detail, debugEvents);
            ++n2;
        }
    }

    protected void saveMemoryBlocks() {
        this.fSession.getMemoryManager().save(this.getTasks());
    }

    protected void suspendThreads(IPDISuspendedEvent event) {
        for (PThread pThread : this.getThreadList()) {
            IPDIThread suspensionThread = null;
            try {
                suspensionThread = this.getPDITarget().getCurrentThread();
            }
            catch (PDIException pDIException) {}
            pThread.suspendByTarget(event.getReason(), suspensionThread);
        }
    }
}

