/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMemoryBlock;
import org.eclipse.ptp.internal.debug.core.PDebugUtils;
import org.eclipse.ptp.internal.debug.core.PMemoryManager;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.model.PDebugElement;

public class PMemoryBlockExtension
extends PDebugElement
implements IMemoryBlockExtension {
    private final BigInteger fBaseAddress;
    private MemoryByte[] fBytes = null;
    private final Set<BigInteger> fChanges = new HashSet<BigInteger>();
    private final String fExpression;
    private final String fMemorySpaceID;
    private IPDIMemoryBlock fPDIBlock = null;

    public PMemoryBlockExtension(IPSession session, TaskSet tasks, BigInteger baseAddress, String memorySpaceID) {
        super(session, tasks);
        this.fBaseAddress = baseAddress;
        this.fMemorySpaceID = memorySpaceID;
        this.fExpression = PMemoryManager.addressToString(baseAddress, memorySpaceID);
    }

    public PMemoryBlockExtension(IPSession session, TaskSet tasks, String expression, BigInteger baseAddress) {
        this(session, tasks, expression, baseAddress, 1);
    }

    public PMemoryBlockExtension(IPSession session, TaskSet tasks, String expression, BigInteger baseAddress, int wordSize) {
        super(session, tasks);
        this.fExpression = expression;
        this.fBaseAddress = baseAddress;
        this.fMemorySpaceID = null;
    }

    public void changes(IPDIMemoryBlock memoryBlock, BigInteger[] addresses) {
        IPDIMemoryBlock block = this.getPDIBlock();
        if (block != null && this.fBytes != null && memoryBlock.equals(block)) {
            MemoryByte[] memBytes = (MemoryByte[])this.fBytes.clone();
            try {
                BigInteger start = this.getRealBlockAddress();
                long length = block.getLength();
                byte[] newBytes = block.getBytes();
                this.saveChanges(addresses);
                int i = 0;
                while (i < addresses.length) {
                    int index;
                    this.fChanges.add(addresses[i]);
                    if (addresses[i].compareTo(start) >= 0 && addresses[i].compareTo(start.add(BigInteger.valueOf(length))) < 0 && (index = addresses[i].subtract(start).intValue()) >= 0 && index < memBytes.length && index < newBytes.length) {
                        memBytes[index].setChanged(true);
                        memBytes[index].setValue(newBytes[index]);
                    }
                    ++i;
                }
                this.fBytes = memBytes;
                this.fireChangeEvent(512);
            }
            catch (PDIException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }

    public void connect(Object object) {
    }

    public void disconnect(Object object) {
    }

    public void dispose() {
        this.fChanges.clear();
        IPDIMemoryBlock pdiBlock = this.getPDIBlock();
        if (pdiBlock != null) {
            try {
                this.getPDISession().getMemoryManager().removeBlocks(this.getTasks(), new IPDIMemoryBlock[]{pdiBlock});
            }
            catch (PDIException e) {
                PTPDebugCorePlugin.log(e);
            }
            this.fPDIBlock = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IMemoryBlockRetrieval.class)) {
            return this.getMemoryBlockRetrieval();
        }
        return super.getAdapter(adapter);
    }

    public int getAddressableSize() throws DebugException {
        if (this.getPDIBlock() == null) {
            try {
                this.setPDIBlock(this.createPDIBlock(this.fBaseAddress, 100L));
            }
            catch (PDIException e) {
                PMemoryBlockExtension.targetRequestFailed(e.getMessage(), null);
            }
        }
        return this.getPDIBlock().getWordSize();
    }

    public int getAddressSize() {
        return PDebugUtils.getAddressSize();
    }

    public BigInteger getBigBaseAddress() {
        return this.fBaseAddress;
    }

    public BigInteger getBigLength() throws DebugException {
        IPDIMemoryBlock block = this.getPDIBlock();
        if (block != null) {
            BigInteger length = new BigInteger(Long.toHexString(block.getLength()), 16);
            return length;
        }
        return BigInteger.ZERO;
    }

    public byte[] getBytes() throws DebugException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryByte[] getBytesFromAddress(BigInteger address, long length) throws DebugException {
        IPDIMemoryBlock pdiBlock = this.getPDIBlock();
        if (pdiBlock == null || pdiBlock.getStartAddress().compareTo(address) > 0 || pdiBlock.getStartAddress().add(BigInteger.valueOf(pdiBlock.getLength())).compareTo(address.add(BigInteger.valueOf(length))) < 0) {
            PMemoryBlockExtension pMemoryBlockExtension = this;
            synchronized (pMemoryBlockExtension) {
                byte[] bytes = null;
                try {
                    pdiBlock = this.getPDIBlock();
                    if (pdiBlock == null || pdiBlock.getStartAddress().compareTo(address) > 0 || pdiBlock.getStartAddress().add(BigInteger.valueOf(pdiBlock.getLength())).compareTo(address.add(BigInteger.valueOf(length))) < 0) {
                        if (pdiBlock != null) {
                            this.disposePDIBlock();
                            this.fBytes = null;
                        }
                        this.setPDIBlock(this.createPDIBlock(address, length));
                    }
                    bytes = this.getPDIBlock().getBytes();
                    this.fBytes = new MemoryByte[bytes.length];
                    int i = 0;
                    while (i < bytes.length) {
                        this.fBytes[i] = this.createMemoryByte(bytes[i], this.getPDIBlock().getFlags(i), this.hasChanged(this.getRealBlockAddress().add(BigInteger.valueOf(i))));
                        ++i;
                    }
                }
                catch (PDIException e) {
                    PMemoryBlockExtension.targetRequestFailed(e.getMessage(), null);
                }
            }
        }
        MemoryByte[] result = new MemoryByte[]{};
        if (this.fBytes != null && pdiBlock != null) {
            int offset = address.subtract(this.getRealBlockAddress()).intValue();
            int offsetInBytes = offset * pdiBlock.getWordSize();
            long lengthInBytes = length * (long)pdiBlock.getWordSize();
            if (offset >= 0) {
                int size;
                int n = size = (long)(this.fBytes.length - offsetInBytes) >= lengthInBytes ? (int)lengthInBytes : this.fBytes.length - offsetInBytes;
                if (size > 0) {
                    result = new MemoryByte[size];
                    System.arraycopy(this.fBytes, offsetInBytes, result, 0, size);
                }
            }
        }
        return result;
    }

    public MemoryByte[] getBytesFromOffset(BigInteger unitOffset, long addressableUnits) throws DebugException {
        return null;
    }

    public Object[] getConnections() {
        return new Object[0];
    }

    public String getExpression() {
        return this.fExpression;
    }

    public long getLength() {
        return 0L;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return (IMemoryBlockRetrieval)this.getDebugTarget().getAdapter(IMemoryBlockRetrieval.class);
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public String getMemorySpaceID() {
        return this.fMemorySpaceID;
    }

    public IPDIMemoryBlock getPDIBlock() {
        return this.fPDIBlock;
    }

    public long getStartAddress() {
        return 0L;
    }

    public void resetChanges() {
        if (this.fBytes != null) {
            BigInteger[] changes = this.fChanges.toArray(new BigInteger[this.fChanges.size()]);
            int i = 0;
            while (i < changes.length) {
                int index;
                BigInteger real = this.getRealBlockAddress();
                if (real.compareTo(changes[i]) <= 0 && real.add(BigInteger.valueOf(this.getBlockSize())).compareTo(changes[i]) > 0 && (index = changes[i].subtract(real).intValue()) >= 0 && index < this.fBytes.length) {
                    this.fBytes[index].setChanged(false);
                }
                ++i;
            }
        }
        this.fChanges.clear();
        this.fireChangeEvent(512);
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
        IPDIMemoryBlock block = this.getPDIBlock();
        if (block != null) {
            BigInteger base = this.getBigBaseAddress();
            BigInteger real = this.getRealBlockAddress();
            long realOffset = base.add(offset).subtract(real).longValue();
            try {
                block.setValue(realOffset, bytes);
            }
            catch (PDIException e) {
                PMemoryBlockExtension.targetRequestFailed(e.getMessage(), null);
            }
        }
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
        this.setValue(BigInteger.valueOf(offset), bytes);
    }

    public boolean supportBaseAddressModification() {
        return true;
    }

    public boolean supportsChangeManagement() {
        return true;
    }

    public boolean supportsValueModification() {
        return true;
    }

    private MemoryByte createMemoryByte(byte value, byte pdiFlags, boolean changed) {
        byte flags = 0;
        if ((pdiFlags & 2) != 0) {
            flags = (byte)(flags | 0x28);
            flags = (pdiFlags & 1) != 0 ? (byte)(flags | 2) : (byte)(flags | 3);
            if (this.isBigEndian()) {
                flags = (byte)(flags | 0x10);
            }
            if (changed) {
                flags = (byte)(flags | 4);
            }
        }
        return new MemoryByte(value, flags);
    }

    private IPDIMemoryBlock createPDIBlock(BigInteger address, long length) throws PDIException {
        IPDIMemoryBlock block = this.getPDISession().getMemoryManager().createMemoryBlock(this.getTasks(), address.toString(), (int)length, 1);
        block.setFrozen(false);
        return block;
    }

    private void disposePDIBlock() {
        IPDIMemoryBlock block = this.getPDIBlock();
        if (block != null) {
            try {
                this.getPDISession().getMemoryManager().removeBlocks(this.getTasks(), new IPDIMemoryBlock[]{block});
            }
            catch (PDIException e) {
                DebugPlugin.log((Throwable)e);
            }
            this.setPDIBlock(null);
        }
    }

    private long getBlockSize() {
        IPDIMemoryBlock block = this.getPDIBlock();
        return block != null ? block.getLength() : 0L;
    }

    private BigInteger getRealBlockAddress() {
        IPDIMemoryBlock block = this.getPDIBlock();
        return block != null ? block.getStartAddress() : BigInteger.ZERO;
    }

    private boolean hasChanged(BigInteger address) {
        return this.fChanges.contains(address);
    }

    private boolean isBigEndian() {
        return true;
    }

    private void saveChanges(BigInteger[] addresses) {
        this.fChanges.addAll(Arrays.asList(addresses));
    }

    private void setPDIBlock(IPDIMemoryBlock pdiBlock) {
        this.fPDIBlock = pdiBlock;
    }
}

