/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.model.IPGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.internal.debug.core.model.PDebugElement;
import org.eclipse.ptp.internal.debug.core.model.PGlobalVariable;
import org.eclipse.ptp.internal.debug.core.model.PLocalVariable;
import org.eclipse.ptp.internal.debug.core.model.PVariable;

public class PVariableFactory {
    public static PGlobalVariable createGlobalVariable(PDebugElement parent, IPGlobalVariableDescriptor descriptor, IPDIVariableDescriptor pdiVariableObject) {
        return new PGlobalVariable(parent, descriptor, pdiVariableObject);
    }

    public static IPGlobalVariableDescriptor createGlobalVariableDescriptor(final String name, final IPath path) {
        return new IPGlobalVariableDescriptor(){

            public boolean equals(Object obj) {
                if (!(obj instanceof IPGlobalVariableDescriptor)) {
                    return false;
                }
                IPGlobalVariableDescriptor d = (IPGlobalVariableDescriptor)obj;
                return this.getName().compareTo(d.getName()) == 0 && this.getPath().equals((Object)d.getPath());
            }

            public String getName() {
                return name;
            }

            public IPath getPath() {
                return path != null ? path : new Path("");
            }

            public String toString() {
                return NLS.bind((String)"{0}::{1}", (Object[])new Object[]{this.getPath().toOSString(), this.getName()});
            }
        };
    }

    public static PVariable createLocalVariable(PDebugElement parent, IPDIVariableDescriptor pdiVariableObject) {
        return new PLocalVariable(parent, pdiVariableObject);
    }

    public static PVariable createLocalVariableWithError(PDebugElement parent, IPDIVariableDescriptor pdiVariableObject, String message) {
        return new PLocalVariable(parent, pdiVariableObject, message);
    }
}

