/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.model;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignalDescriptor;
import org.eclipse.ptp.internal.debug.core.pdi.SessionObject;

public class Signal
extends SessionObject
implements IPDISignal {
    private IPDISignalDescriptor desc;

    public Signal(IPDISession session, TaskSet tasks, IPDISignalDescriptor desc) {
        super(session, tasks);
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc.getDescription();
    }

    public String getName() {
        return this.desc.getName();
    }

    public void handle(boolean isIgnore, boolean isStop) throws PDIException {
        this.session.getSignalManager().handle(this, isIgnore, isStop);
    }

    public boolean isIgnore() {
        return !this.isPass();
    }

    public boolean isPass() {
        return this.desc.getPass();
    }

    public boolean isPrint() {
        return this.desc.getPrint();
    }

    public boolean isStop() {
        return this.desc.getStop();
    }

    public boolean isStopSet() {
        return this.isStop();
    }

    public void setHandle(boolean isIgnore, boolean isStop) {
        this.desc.setPass(!isIgnore);
        this.desc.setStop(isStop);
    }

    public void setDescriptor(IPDISignalDescriptor desc) {
        this.desc = desc;
    }

    public void signal() throws PDIException {
        this.session.resume(this.getTasks(), this);
    }

    public String toString() {
        return this.desc.toString();
    }
}

