/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.request;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListArgumentsRequest;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.request.AbstractEventResultRequest;

public abstract class AbstractListArgumentsRequest
extends AbstractEventResultRequest
implements IPDIListArgumentsRequest {
    private int low = 0;
    private int high = 0;

    public AbstractListArgumentsRequest(TaskSet tasks, int low, int high) {
        super(tasks);
        this.low = low;
        this.high = high;
    }

    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.listArguments(this.tasks, this.low, this.high);
    }

    public String[] getArguments(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        throw new PDIException(qTasks, Messages.AbstractListArgumentsRequest_0);
    }

    public String getName() {
        return Messages.AbstractListArgumentsRequest_1;
    }
}

